/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.path;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.javaee.web.CustomServletReferenceAdapter;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.struts.StrutsBundle;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.ActionMappings;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.ResolvingElementQuickFix;
import icons.StrutsApiIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionWebPathsProvider
extends CustomServletReferenceAdapter {
    private final boolean myPrefixAllowed;

    public ActionWebPathsProvider() {
        this.myPrefixAllowed = true;
    }

    public ActionWebPathsProvider(boolean prefixAllowed) {
        this.myPrefixAllowed = prefixAllowed;
    }

    @Nullable
    public PathReference createWebPath(String path, @NotNull PsiElement element, ServletMappingInfo info) {
        Action action;
        StrutsModel model;
        if (element == null) {
            ActionWebPathsProvider.$$$reportNull$$$0(0);
        }
        if ((model = StrutsManager.getInstance().getStrutsModel(element)) != null && (action = model.resolveActionURL(path)) != null) {
            return new PathReference(path, (Function)new ConstantFunction((Object)StrutsApiIcons.ActionMapping)){

                public PsiElement resolve() {
                    return action.getXmlTag();
                }
            };
        }
        return null;
    }

    protected PsiReference[] createReferences(@NotNull PsiElement element, int offset, String text, @Nullable ServletMappingInfo info, boolean soft) {
        StrutsModel model;
        if (element == null) {
            ActionWebPathsProvider.$$$reportNull$$$0(1);
        }
        if ((model = StrutsManager.getInstance().getStrutsModel(element)) != null) {
            return new PsiReference[]{new ActionReference(element, offset, text, (ServletMappingInfo)(info == null || info.equals((Object)model.getServletMappingInfo()) ? info : null), soft)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/struts/inplace/reference/path/ActionWebPathsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createWebPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ActionReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        public ActionReference(PsiElement element, int offset, String text, ServletMappingInfo info, boolean soft) {
            TextRange range;
            if (element == null) {
                ActionReference.$$$reportNull$$$0(0);
            }
            super(element, new TextRange(offset, offset + text.length()), soft);
            if (info != null && (info.getType() != ServletMappingType.PATH || ActionWebPathsProvider.this.myPrefixAllowed) && (range = info.getNameRange(text)) != null) {
                this.setRangeInElement(range.shiftRight(offset));
            }
        }

        @Nullable
        public PsiElement resolve() {
            Action action;
            StrutsModel model = StrutsManager.getInstance().getStrutsModel(this.myElement);
            if (model == null) {
                return null;
            }
            String url = this.getValue();
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            if ((action = model.findAction(url)) != null) {
                return action.getXmlTag();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            StrutsModel model = StrutsManager.getInstance().getStrutsModel(this.myElement);
            if (model == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    ActionReference.$$$reportNull$$$0(1);
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            ServletMappingInfo info = model.getServletMappingInfo();
            List<Action> actions = model.getActions();
            Object[] objectArray = ElementPresentationManager.getInstance().createVariants(actions, action -> {
                String actionPath = (String)action.getPath().getValue();
                if (actionPath == null) {
                    return null;
                }
                return ActionWebPathsProvider.this.myPrefixAllowed ? info.addMapping(actionPath) : actionPath;
            }, 1);
            if (objectArray == null) {
                ActionReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = StrutsBundle.message("cannot.resolve.action", this.getValue());
            if (string == null) {
                ActionReference.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        private ResolvingElementQuickFix createFix() {
            StrutsModel model = StrutsManager.getInstance().getStrutsModel(this.myElement);
            if (model == null) {
                return null;
            }
            String text = this.getValue();
            ActionMappings scope = ((StrutsConfig)model.getMergedModel()).getActionMappings();
            return ResolvingElementQuickFix.createFix((String)text, Action.class, (DomElement)scope);
        }

        public LocalQuickFix[] getQuickFixes() {
            LocalQuickFix[] localQuickFixArray;
            ResolvingElementQuickFix quickFix = this.createFix();
            if (quickFix == null) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = quickFix;
            }
            return localQuickFixArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/struts/inplace/reference/path/ActionWebPathsProvider$ActionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/struts/inplace/reference/path/ActionWebPathsProvider$ActionReference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

