/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;

public class InternalTestDiscoveryListener
implements TestListener,
Closeable {
    private final String c;
    private final String b;
    private final List<String> a = new ArrayList<String>();
    private final boolean e;
    private Object f;
    private Class<?> d;

    public InternalTestDiscoveryListener() {
        this.b = System.getProperty("org.jetbrains.instrumentation.trace.dir");
        this.c = System.getProperty("org.jetbrains.instrumentation.main.module");
        this.e = Boolean.parseBoolean(System.getProperty("org.jetbrains.instrumentation.compact.traces", "true"));
        System.out.println(this.getClass().getSimpleName() + " instantiated with module='" + this.c + "' , directory='" + this.b + "'");
    }

    private Object a() {
        if (this.f == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            try {
                this.d = Class.forName("com.intellij.execution.testDiscovery.TestDiscoveryIndex");
                this.f = this.d.getConstructor(Project.class, String.class).newInstance(project2, this.b);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return this.f;
    }

    public void addError(Test test, Throwable throwable) {
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
    }

    public void endTest(Test test) {
        String[] stringArray;
        String string = InternalTestDiscoveryListener.a(test);
        String string2 = InternalTestDiscoveryListener.b(test);
        try {
            stringArray = this.getData();
            Method method = stringArray.getClass().getMethod("testDiscoveryEnded", String.class);
            method.invoke((Object)stringArray, "j" + string + "-" + string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.a.add("j" + string + "." + string2);
        if (this.a.size() > 50) {
            stringArray = ArrayUtil.toStringArray(this.a);
            this.a.clear();
            AppExecutorUtil.getAppExecutorService().execute(() -> this.flushCurrentTraces(stringArray));
        }
    }

    protected void flushCurrentTraces(String[] stringArray) {
        if (!this.e) {
            return;
        }
        System.out.println("Start compacting to index");
        try {
            Object object = this.a();
            Method method = Class.forName("com.intellij.execution.testDiscovery.TestDiscoveryExtension").getMethod("processAvailableTraces", stringArray.getClass(), this.b.getClass(), String.class, String.class, this.d);
            method.invoke(null, stringArray, this.b, this.c, "j", object);
            System.out.println("Compacting done.");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static String b(Test test) {
        String string = test.toString();
        int n2 = string.indexOf("(");
        return n2 > 0 ? string.substring(0, n2) : string;
    }

    private static String a(Test test) {
        String string = test.toString();
        int n2 = string.indexOf("(");
        return n2 > 0 && string.endsWith(")") ? string.substring(n2 + 1, string.length() - 1) : null;
    }

    public void startTest(Test test) {
        try {
            Object object = this.getData();
            Method method = object.getClass().getMethod("testDiscoveryStarted", String.class);
            method.invoke(object, InternalTestDiscoveryListener.a(test) + "-" + InternalTestDiscoveryListener.b(test));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected Object getData() throws Exception {
        return Class.forName("com.intellij.rt.coverage.data.ProjectData").getMethod("getProjectData", ArrayUtil.EMPTY_CLASS_ARRAY).invoke(null, ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public void close() throws IOException {
        String[] stringArray = ArrayUtil.toStringArray(this.a);
        this.a.clear();
        this.flushCurrentTraces(stringArray);
        InternalTestDiscoveryListener.a(this.b);
    }

    private static void a(String string2) {
        String string3 = "out.zip";
        File[] fileArray = new File(string2).listFiles((file, string) -> string != null && !string.equalsIgnoreCase("out.zip"));
        if (fileArray == null) {
            System.out.println("No traces found.");
            return;
        }
        System.out.println("Preparing zip.");
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(new File(string2, "out.zip")));){
            for (File file2 : fileArray) {
                ZipUtil.addFileToZip((ZipOutputStream)zipOutputStream, (File)file2, (String)("/" + file2.getName()), null, null);
            }
            System.out.println("Zip prepared.");
            for (File file2 : fileArray) {
                FileUtil.delete((File)file2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

