/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.ExecutionNodeProgressAnimator;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.SkippedResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionNode
extends CachingSimpleNode {
    private final List<ExecutionNode> l = ContainerUtil.newSmartList();
    private long i;
    private long e;
    @Nullable
    private String k;
    @Nullable
    private String b;
    @Nullable
    private String h;
    @Nullable
    private EventResult a;
    private boolean c;
    @Nullable
    private Navigatable j;
    @Nullable
    private NullableLazyValue<Icon> f;
    private final AtomicInteger g = new AtomicInteger();
    private final AtomicInteger d = new AtomicInteger();

    public ExecutionNode(Project project2, ExecutionNode executionNode) {
        super(project2, (NodeDescriptor)executionNode);
    }

    protected SimpleNode[] buildChildren() {
        return this.l.size() == 0 ? NO_CHILDREN : (SimpleNode[])ContainerUtil.toArray(this.l, (Object[])new ExecutionNode[this.l.size()]);
    }

    protected void update(PresentationData presentationData) {
        this.setIcon(this.b());
        presentationData.setPresentableText(this.myName);
        presentationData.setIcon(this.getIcon());
        if (this.k != null) {
            presentationData.addText(this.k + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        String string = this.a();
        if (this.k != null || string != null) {
            presentationData.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (string != null) {
            presentationData.addText("  " + string, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.b != null) {
            presentationData.setTooltip(this.b);
        }
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String string) {
        this.myName = string;
    }

    @Nullable
    public String getTitle() {
        return this.k;
    }

    public void setTitle(@Nullable String string) {
        this.k = string;
    }

    @Nullable
    public String getTooltip() {
        return this.b;
    }

    public void setTooltip(@Nullable String string) {
        this.b = string;
    }

    @Nullable
    public String getHint() {
        return this.h;
    }

    public void setHint(@Nullable String string) {
        this.h = string;
    }

    public void add(ExecutionNode executionNode) {
        this.l.add(executionNode);
        this.cleanUpCache();
    }

    public void add(int n2, ExecutionNode executionNode) {
        this.l.add(n2, executionNode);
        this.cleanUpCache();
    }

    void removeChildren() {
        this.l.clear();
        this.cleanUpCache();
    }

    @Nullable
    public String getDuration() {
        if (this.i == this.e) {
            return null;
        }
        if (this.isRunning()) {
            long l2 = this.i == 0L ? 0L : System.currentTimeMillis() - this.i;
            String string = StringUtil.formatDuration((long)l2);
            int n2 = string.indexOf("s ");
            if (n2 != -1) {
                string = string.substring(0, n2 + 1);
            }
            return "Running for " + string;
        }
        return this.isSkipped() ? null : StringUtil.formatDuration((long)(this.e - this.i));
    }

    public long getStartTime() {
        return this.i;
    }

    public void setStartTime(long l2) {
        this.i = l2;
    }

    public long getEndTime() {
        return this.e;
    }

    public void setEndTime(long l2) {
        this.e = l2;
    }

    public boolean isFailed() {
        return this.a instanceof FailureResult;
    }

    public boolean isSkipped() {
        return this.a instanceof SkippedResult;
    }

    public boolean isRunning() {
        return this.e <= 0L && !this.isSkipped() && !this.isFailed();
    }

    public void setResult(@Nullable EventResult eventResult) {
        this.a = eventResult;
    }

    @Nullable
    public EventResult getResult() {
        return this.a;
    }

    public boolean isAutoExpandNode() {
        return this.c;
    }

    public void setAutoExpandNode(boolean bl2) {
        this.c = bl2;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        this.j = navigatable;
    }

    @NotNull
    public List<Navigatable> getNavigatables() {
        if (this.j != null) {
            List<Navigatable> list2 = Collections.singletonList(this.j);
            if (list2 == null) {
                ExecutionNode.a(0);
            }
            return list2;
        }
        if (this.a == null) {
            List<Navigatable> list3 = Collections.emptyList();
            if (list3 == null) {
                ExecutionNode.a(1);
            }
            return list3;
        }
        if (this.a instanceof FailureResult) {
            SmartList smartList = new SmartList();
            for (Failure failure : ((FailureResult)this.a).getFailures()) {
                ContainerUtil.addIfNotNull((Collection)smartList, (Object)failure.getNavigatable());
            }
            SmartList smartList2 = smartList;
            if (smartList2 == null) {
                ExecutionNode.a(2);
            }
            return smartList2;
        }
        List<Navigatable> list4 = Collections.emptyList();
        if (list4 == null) {
            ExecutionNode.a(3);
        }
        return list4;
    }

    public void setIconProvider(final Supplier<Icon> supplier) {
        this.f = new NullableLazyValue<Icon>(){

            @Nullable
            protected Icon compute() {
                return (Icon)supplier.get();
            }
        };
    }

    public void reportChildMessageKind(MessageEvent.Kind kind) {
        if (kind == MessageEvent.Kind.ERROR) {
            this.g.incrementAndGet();
        } else if (kind == MessageEvent.Kind.WARNING) {
            this.d.incrementAndGet();
        }
    }

    private String a() {
        String string = this.h;
        int n2 = this.d.get();
        int n3 = this.g.get();
        if (n2 > 0 || n3 > 0) {
            if (string == null) {
                string = "";
            }
            string = string + (this.getParent() == null ? (this.isRunning() ? "   " : "   with ") : " (");
            if (n3 > 0) {
                string = string + n3 + " " + StringUtil.pluralize((String)"error", (int)n3);
                if (n2 > 0) {
                    string = string + ", ";
                }
            }
            if (n2 > 0) {
                string = string + n2 + " " + StringUtil.pluralize((String)"warning", (int)n2);
            }
            if (this.getParent() != null) {
                string = string + ")";
            }
        }
        return string;
    }

    private Icon b() {
        if (this.f != null) {
            return (Icon)this.f.getValue();
        }
        if (this.a instanceof MessageEventResult) {
            return ExecutionNode.a(((MessageEventResult)this.a).getKind());
        }
        return this.isRunning() ? ExecutionNodeProgressAnimator.getCurrentFrame() : (this.isFailed() ? AllIcons.Process.State.RedExcl : (this.isSkipped() ? AllIcons.Process.State.YellowStr : AllIcons.Process.State.GreenOK));
    }

    private static Icon a(MessageEvent.Kind kind) {
        switch (kind) {
            case ERROR: {
                return AllIcons.General.Error;
            }
            case WARNING: {
                return AllIcons.General.Warning;
            }
            case INFO: {
                return AllIcons.General.Information;
            }
            case STATISTICS: {
                return AllIcons.General.Mdot_empty;
            }
            case SIMPLE: {
                return AllIcons.General.Mdot_empty;
            }
        }
        return AllIcons.General.Mdot_empty;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/ExecutionNode", "getNavigatables"));
    }
}

