/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.ExecutionNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ExecutionNodeProgressAnimator
implements Runnable,
Disposable {
    private static final int b = 8;
    private static final int c = 1200;
    private static final int e = 150;
    public static final Icon[] FRAMES = new Icon[8];
    private long f = -1L;
    private Alarm d;
    private final List<ExecutionNode> g = new SmartList();
    private BuildTreeConsoleView a;

    public ExecutionNodeProgressAnimator(BuildTreeConsoleView buildTreeConsoleView) {
        Disposer.register((Disposable)buildTreeConsoleView, (Disposable)this);
        this.d = new Alarm();
        this.a = buildTreeConsoleView;
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 1200L / 150L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[ExecutionNodeProgressAnimator.getCurrentFrameIndex()];
    }

    @Override
    public void run() {
        long l2;
        if (!this.g.isEmpty() && (l2 = System.currentTimeMillis()) - this.f >= 150L) {
            this.c();
            this.f = l2;
        }
        this.d();
    }

    public void addNode(@Nullable ExecutionNode executionNode) {
        this.g.add(executionNode);
    }

    public void startMovie() {
        this.d();
    }

    public void stopMovie() {
        this.c();
        for (ExecutionNode executionNode : this.g) {
            executionNode.setIconProvider(() -> AllIcons.Process.State.YellowStr);
            executionNode.setEndTime(System.currentTimeMillis());
        }
        this.g.clear();
        this.b();
    }

    public void dispose() {
        this.a = null;
        this.g.clear();
        this.b();
    }

    private void b() {
        if (this.d != null) {
            this.d.cancelAllRequests();
            this.d = null;
        }
    }

    private void c() {
        if (this.a == null || this.a.isDisposed()) {
            return;
        }
        Iterator<ExecutionNode> iterator = this.g.iterator();
        while (iterator.hasNext()) {
            ExecutionNode executionNode = iterator.next();
            this.a.scheduleUpdate(executionNode);
            if (executionNode.isRunning()) continue;
            iterator.remove();
        }
    }

    private void d() {
        if (this.d == null) {
            return;
        }
        this.d.cancelAllRequests();
        this.d.addRequest((Runnable)this, 150);
    }

    static {
        ExecutionNodeProgressAnimator.FRAMES[0] = AllIcons.Process.State.GreyProgr_1;
        ExecutionNodeProgressAnimator.FRAMES[1] = AllIcons.Process.State.GreyProgr_2;
        ExecutionNodeProgressAnimator.FRAMES[2] = AllIcons.Process.State.GreyProgr_3;
        ExecutionNodeProgressAnimator.FRAMES[3] = AllIcons.Process.State.GreyProgr_4;
        ExecutionNodeProgressAnimator.FRAMES[4] = AllIcons.Process.State.GreyProgr_5;
        ExecutionNodeProgressAnimator.FRAMES[5] = AllIcons.Process.State.GreyProgr_6;
        ExecutionNodeProgressAnimator.FRAMES[6] = AllIcons.Process.State.GreyProgr_7;
        ExecutionNodeProgressAnimator.FRAMES[7] = AllIcons.Process.State.GreyProgr_8;
    }
}

