/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MultipleBuildsView
implements BuildProgressListener,
Disposable {
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicBoolean i;
    private final List<Runnable> c;
    private final ProgressWatcher f;
    private final ThreeComponentsSplitter k;
    private final JBList<AbstractViewManager.BuildInfo> d;
    private final Map<Object, AbstractViewManager.BuildInfo> e;
    private final Map<AbstractViewManager.BuildInfo, BuildView> h;
    private final AbstractViewManager l;
    private volatile Content g;
    private volatile DefaultActionGroup b;
    private volatile boolean j;
    private final TransferToEDTQueue<Runnable> a;

    public MultipleBuildsView(Project project2, BuildContentManager buildContentManager, AbstractViewManager abstractViewManager) {
        this.myProject = project2;
        this.myBuildContentManager = buildContentManager;
        this.l = abstractViewManager;
        this.i = new AtomicBoolean();
        this.c = ContainerUtil.createConcurrentList();
        this.k = new ThreeComponentsSplitter();
        Disposer.register((Disposable)this, (Disposable)this.k);
        this.d = new JBList();
        this.d.setModel(new DefaultListModel());
        this.d.setFixedCellHeight(40);
        this.d.installCellRenderer(object -> {
            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)object;
            JPanel jPanel = new JPanel(new BorderLayout());
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setIcon(buildInfo.getIcon());
            simpleColoredComponent.append(buildInfo.getTitle() + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            simpleColoredComponent.append(buildInfo.message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            jPanel.add((Component)simpleColoredComponent, "North");
            if (buildInfo.statusMessage != null) {
                SimpleColoredComponent simpleColoredComponent2 = new SimpleColoredComponent();
                simpleColoredComponent2.setIcon(EmptyIcon.ICON_16);
                simpleColoredComponent2.append(buildInfo.statusMessage, SimpleTextAttributes.GRAY_ATTRIBUTES);
                jPanel.add((Component)simpleColoredComponent2, "South");
            }
            return jPanel;
        });
        this.h = ContainerUtil.newConcurrentMap();
        this.e = ContainerUtil.newConcurrentMap();
        this.f = new ProgressWatcher();
        this.a = new TransferToEDTQueue("Multiple builds view queue", runnable -> {
            runnable.run();
            return true;
        }, object -> this.j);
    }

    public void dispose() {
        this.j = true;
    }

    public Content getContent() {
        return this.g;
    }

    public Map<AbstractViewManager.BuildInfo, BuildView> getBuildsMap() {
        return Collections.unmodifiableMap(this.h);
    }

    public boolean shouldConsume(BuildEvent buildEvent) {
        return buildEvent.getParentId() != null && this.e.containsKey(buildEvent.getParentId()) || this.e.containsKey(buildEvent.getId());
    }

    @Override
    public void onEvent(BuildEvent buildEvent) {
        SmartList smartList = new SmartList();
        if (buildEvent instanceof StartBuildEvent) {
            StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
            if (this.i.get()) {
                this.a((List<Runnable>)smartList, startBuildEvent);
            }
            AbstractViewManager.BuildInfo buildInfo = new AbstractViewManager.BuildInfo(buildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), buildEvent.getEventTime());
            this.e.put(buildEvent.getId(), buildInfo);
        } else if (buildEvent.getParentId() != null) {
            AbstractViewManager.BuildInfo buildInfo = this.e.get(buildEvent.getParentId());
            assert (buildInfo != null);
            this.e.put(buildEvent.getId(), buildInfo);
        }
        smartList.add(() -> {
            AbstractViewManager.BuildInfo buildInfo2 = this.e.get(buildEvent.getId());
            assert (buildInfo2 != null);
            if (buildEvent instanceof StartBuildEvent) {
                RunContentDescriptor runContentDescriptor;
                StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
                buildInfo2.message = startBuildEvent.getMessage();
                DefaultListModel defaultListModel = (DefaultListModel)this.d.getModel();
                defaultListModel.addElement(buildInfo2);
                BuildView buildView = this.h.computeIfAbsent(buildInfo2, buildInfo -> {
                    DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor(startBuildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), startBuildEvent.getEventTime());
                    String string = "build.toolwindow." + this.l.getViewName() + ".selection.state";
                    BuildView buildView = new BuildView(this.myProject, defaultBuildDescriptor, string, this.l);
                    Disposer.register((Disposable)this.k, (Disposable)buildView);
                    return buildView;
                });
                buildView.onEvent(startBuildEvent);
                this.g.setPreferredFocusedComponent(buildView::getPreferredFocusableComponent);
                Supplier<RunContentDescriptor> supplier = startBuildEvent.getContentDescriptorSupplier();
                RunContentDescriptor runContentDescriptor2 = runContentDescriptor = supplier != null ? supplier.get() : null;
                if (runContentDescriptor != null) {
                    boolean bl2;
                    buildInfo2.activateToolWindowWhenAdded = bl2 = runContentDescriptor.isActivateToolWindowWhenAdded();
                    if (runContentDescriptor instanceof BuildContentDescriptor) {
                        buildInfo2.activateToolWindowWhenFailed = ((BuildContentDescriptor)runContentDescriptor).isActivateToolWindowWhenFailed();
                    }
                    boolean bl3 = runContentDescriptor.isAutoFocusContent();
                    this.myBuildContentManager.setSelectedContent(this.g, bl3, bl3, bl2, runContentDescriptor.getActivationCallback());
                    Disposer.register((Disposable)buildView, (Disposable)runContentDescriptor);
                } else {
                    this.myBuildContentManager.setSelectedContent(this.g, true, true, false, null);
                }
                buildInfo2.content = this.g;
                if (this.k.getLastComponent() == null) {
                    this.k.setLastComponent((JComponent)buildView);
                    this.l.configureToolbar(this.b, this, buildView);
                }
                if (this.d.getModel().getSize() > 1) {
                    JBScrollPane jBScrollPane = new JBScrollPane();
                    jBScrollPane.setBorder((Border)JBUI.Borders.empty());
                    jBScrollPane.setViewportView(this.d);
                    this.k.setFirstComponent((JComponent)jBScrollPane);
                    this.d.setVisible(true);
                    this.d.setSelectedIndex(0);
                    this.k.repaint();
                    for (BuildView buildView2 : this.h.values()) {
                        BuildTreeConsoleView buildTreeConsoleView = buildView2.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
                        if (buildTreeConsoleView == null) continue;
                        buildTreeConsoleView.hideRootNode();
                    }
                } else {
                    this.k.setFirstComponent(null);
                }
                this.l.onBuildStart(buildInfo2);
                this.f.addBuild(buildInfo2);
                ((BuildContentManagerImpl)this.myBuildContentManager).startBuildNotified(buildInfo2, buildInfo2.content, startBuildEvent.getProcessHandler());
            } else {
                if (buildEvent instanceof FinishBuildEvent) {
                    buildInfo2.endTime = buildEvent.getEventTime();
                    buildInfo2.message = buildEvent.getMessage();
                    buildInfo2.result = ((FinishBuildEvent)buildEvent).getResult();
                    this.f.stopBuild(buildInfo2);
                    ((BuildContentManagerImpl)this.myBuildContentManager).finishBuildNotified(buildInfo2, buildInfo2.content);
                    this.l.onBuildFinish(buildInfo2);
                } else {
                    buildInfo2.statusMessage = buildEvent.getMessage();
                }
                this.h.get(buildInfo2).onEvent(buildEvent);
            }
        });
        if (this.g == null) {
            this.c.addAll((Collection<Runnable>)smartList);
            if (this.i.compareAndSet(false, true)) {
                this.a.offer(() -> {
                    this.d.setSelectionMode(0);
                    this.d.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent listSelectionEvent) {
                            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)MultipleBuildsView.this.d.getSelectedValue();
                            if (buildInfo == null) {
                                return;
                            }
                            BuildView buildView = (BuildView)MultipleBuildsView.this.h.get(buildInfo);
                            JComponent jComponent = MultipleBuildsView.this.k.getLastComponent();
                            if (buildView != null && jComponent != buildView.getComponent()) {
                                MultipleBuildsView.this.k.setLastComponent(buildView.getComponent());
                                buildView.getComponent().setVisible(true);
                                if (jComponent != null) {
                                    jComponent.setVisible(false);
                                }
                                MultipleBuildsView.this.l.configureToolbar(MultipleBuildsView.this.b, MultipleBuildsView.this, buildView);
                                buildView.getComponent().repaint();
                            }
                            int n2 = MultipleBuildsView.this.k.getFirstSize();
                            int n3 = MultipleBuildsView.this.k.getLastSize();
                            if (n2 == 0 && n3 == 0) {
                                EdtInvocationManager.getInstance().invokeLater(() -> {
                                    int n2 = 0;
                                    for (Object object = MultipleBuildsView.this.k; object != null && (n2 = object.getWidth()) == 0; object = object.getParent()) {
                                    }
                                    int n3 = Math.round((float)n2 / 4.0f);
                                    MultipleBuildsView.this.k.setFirstSize(n3);
                                });
                            }
                        }
                    });
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)this.k, "Center");
                    this.b = new DefaultActionGroup();
                    jPanel.add((Component)ActionManager.getInstance().createActionToolbar("BuildView", (ActionGroup)this.b, false).getComponent(), "West");
                    this.g = new ContentImpl((JComponent)jPanel, this.l.getViewName(), true);
                    Disposer.register((Disposable)this.g, (Disposable)this);
                    this.g.setCloseable(false);
                    Icon icon = this.l.getContentIcon();
                    if (icon != null) {
                        this.g.setIcon(icon);
                        this.g.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                    }
                    this.myBuildContentManager.addContent(this.g);
                    ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.c);
                    this.c.clear();
                    for (Runnable runnable : arrayList) {
                        runnable.run();
                    }
                });
            }
        } else {
            this.a.offer(() -> MultipleBuildsView.a((List)smartList));
        }
    }

    private void a(List<Runnable> list2, StartBuildEvent startBuildEvent) {
        long l2 = System.currentTimeMillis();
        DefaultListModel defaultListModel = (DefaultListModel)this.d.getModel();
        boolean bl2 = !defaultListModel.isEmpty();
        SmartList smartList = new SmartList();
        for (int i2 = 0; i2 < defaultListModel.getSize(); ++i2) {
            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)defaultListModel.getElementAt(i2);
            boolean bl3 = buildInfo.getWorkingDir().equals(startBuildEvent.getWorkingDir());
            if (buildInfo.endTime != -1L && bl3) {
                smartList.add(buildInfo);
            }
            if ((!bl2 || buildInfo.endTime != -1L) && (bl3 || l2 - buildInfo.endTime >= TimeUnit.SECONDS.toMillis(1L))) continue;
            bl2 = false;
        }
        if (bl2) {
            this.e.clear();
            SmartList smartList2 = new SmartList(this.h.values());
            list2.add(() -> smartList2.forEach(Disposer::dispose));
            this.h.clear();
            defaultListModel.clear();
            this.d.setVisible(false);
            list2.add(() -> {
                this.k.setFirstComponent(null);
                this.k.setLastComponent(null);
            });
            this.b.removeAll();
        } else {
            for (AbstractViewManager.BuildInfo buildInfo : smartList) {
                list2.add(() -> {
                    BuildView buildView = this.h.remove(buildInfo);
                    if (buildView != null) {
                        Disposer.dispose((Disposable)buildView);
                    }
                });
                defaultListModel.removeElement(buildInfo);
            }
        }
    }

    public boolean hasRunningBuilds() {
        return !this.f.b.isEmpty();
    }

    private static /* synthetic */ void a(List list2) {
        for (Runnable runnable : list2) {
            runnable.run();
        }
    }

    private class ProgressWatcher
    implements Runnable {
        private final Alarm a = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final Set<AbstractViewManager.BuildInfo> b = ContainerUtil.newConcurrentSet();

        private ProgressWatcher() {
        }

        @Override
        public void run() {
            this.a.cancelAllRequests();
            JComponent jComponent = MultipleBuildsView.this.k.getFirstComponent();
            if (jComponent != null) {
                jComponent.revalidate();
                jComponent.repaint();
            }
            if (!this.b.isEmpty()) {
                this.a.addRequest((Runnable)this, 300);
            }
        }

        void addBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.b.add(buildInfo);
            if (this.b.size() > 1) {
                this.a.cancelAllRequests();
                this.a.addRequest((Runnable)this, 300);
            }
        }

        void stopBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.b.remove(buildInfo);
        }
    }
}

