/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ExternalCompilerConfigurationStorage;
import com.intellij.compiler.ExternalCompilerConfigurationStorageKt;
import com.intellij.compiler.MalformedPatternException;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.javac.JavacCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.model.java.impl.compiler.ResourcePatterns;
import org.jetbrains.jps.model.serialization.java.compiler.AnnotationProcessorProfileSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerConfigurationSerializer;

@com.intellij.openapi.components.State(name="CompilerConfiguration", storages={@Storage(value="compiler.xml")})
public class CompilerConfigurationImpl
extends CompilerConfiguration
implements PersistentStateComponent<Element>,
ProjectComponent {
    private static final Logger m = Logger.getInstance((String)"#com.intellij.compiler.CompilerConfiguration");
    public static final String TESTS_EXTERNAL_COMPILER_HOME_PROPERTY_NAME = "tests.external.compiler.home";
    public static final int DEFAULT_BUILD_PROCESS_HEAP_SIZE = 700;
    private BackendCompiler o;
    private State g = new State();
    private final List<Pattern> d = new ArrayList<Pattern>();
    private final List<String> j = new ArrayList<String>();
    private final List<CompiledPattern> c = new ArrayList<CompiledPattern>();
    private final List<CompiledPattern> l = new ArrayList<CompiledPattern>();
    private boolean f = false;
    private final Project r;
    private final ExcludedEntriesConfiguration p;
    private final Collection<BackendCompiler> i = new ArrayList<BackendCompiler>();
    private JavacCompiler e;
    private final Perl5Matcher a = new Perl5Matcher();
    private boolean s;
    private final ProcessorConfigProfile n;
    private final List<ProcessorConfigProfile> q;
    private Map<Module, ProcessorConfigProfile> b;
    @Nullable
    private String h;
    private final Map<String, String> k;

    public CompilerConfigurationImpl(Project project2) {
        this.f();
        this.s = true;
        this.n = new ProcessorConfigProfileImpl("Default");
        this.q = new ArrayList<ProcessorConfigProfile>();
        this.b = null;
        this.h = null;
        this.k = new HashMap<String, String>();
        this.r = project2;
        this.p = this.createExcludedEntriesConfiguration(project2);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)project2);
        messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    1.a(0);
                }
                if (module2 == null) {
                    1.a(1);
                }
                CompilerConfigurationImpl.this.getAnnotationProcessingConfiguration(module2).removeModuleName(module2.getName());
            }

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    1.a(2);
                }
                if (module2 == null) {
                    1.a(3);
                }
                CompilerConfigurationImpl.this.b = null;
            }

            public void modulesRenamed(@NotNull Project project2, @NotNull List<Module> list2, @NotNull Function<Module, String> function) {
                if (project2 == null) {
                    1.a(4);
                }
                if (list2 == null) {
                    1.a(5);
                }
                if (function == null) {
                    1.a(6);
                }
                CompilerConfigurationImpl.this.a(list2.stream().collect(Collectors.toMap(arg_0 -> function.fun(arg_0), Module::getName)));
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "modules";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/compiler/CompilerConfigurationImpl$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeModuleRemoved";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleAdded";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modulesRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    protected ExcludedEntriesConfiguration createExcludedEntriesConfiguration(final @NotNull Project project2) {
        if (project2 == null) {
            CompilerConfigurationImpl.a(0);
        }
        ExcludedEntriesConfiguration excludedEntriesConfiguration = new ExcludedEntriesConfiguration((ExcludedEntriesListener)project2.getMessageBus().syncPublisher(ExcludedEntriesListener.TOPIC));
        Disposer.register((Disposable)project2, (Disposable)excludedEntriesConfiguration);
        project2.getMessageBus().connect().subscribe(ExcludedEntriesListener.TOPIC, (Object)new ExcludedEntriesListener(){

            public void onEntryAdded(@NotNull ExcludeEntryDescription excludeEntryDescription) {
                if (excludeEntryDescription == null) {
                    2.a(0);
                }
                this.a();
            }

            public void onEntryRemoved(@NotNull ExcludeEntryDescription excludeEntryDescription) {
                if (excludeEntryDescription == null) {
                    2.a(1);
                }
                this.a();
            }

            private void a() {
                if (project2.isOpen()) {
                    BuildManager.getInstance().clearState(project2);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "description";
                objectArray2[1] = "com/intellij/compiler/CompilerConfigurationImpl$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEntryAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEntryRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ExcludedEntriesConfiguration excludedEntriesConfiguration2 = excludedEntriesConfiguration;
        if (excludedEntriesConfiguration2 == null) {
            CompilerConfigurationImpl.a(1);
        }
        return excludedEntriesConfiguration2;
    }

    public Element getState() {
        Element element;
        Element element2 = new Element("state");
        XmlSerializer.serializeInto((Object)this.g, (Element)element2, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (!this.s) {
            CompilerConfigurationImpl.a(element2, "addNotNullAssertions").setAttribute("enabled", String.valueOf(this.s));
        }
        if (this.p.getExcludeEntryDescriptions().length > 0) {
            this.p.writeExternal(CompilerConfigurationImpl.a(element2, "excludeFromCompile"));
        }
        Element element3 = new Element("resourceExtensions");
        for (String string : this.c()) {
            CompilerConfigurationImpl.a(element3, "entry").setAttribute("name", string);
        }
        if (!JDOMUtil.isEmpty((Element)element3)) {
            element2.addContent(element3);
        }
        if (!(!this.f && this.j.isEmpty() || JpsJavaCompilerConfigurationSerializer.DEFAULT_WILDCARD_PATTERNS.equals(this.j))) {
            element = CompilerConfigurationImpl.a(element2, "wildcardResourcePatterns");
            for (String string : this.j) {
                CompilerConfigurationImpl.a(element, "entry").setAttribute("name", string);
            }
        }
        element = new Element("annotationProcessing");
        Element element4 = new Element("profile");
        element4.setAttribute("default", "true");
        AnnotationProcessorProfileSerializer.writeExternal((ProcessorConfigProfile)this.n, (Element)element4);
        if (!JDOMUtil.isEmpty((Element)element4, (int)2)) {
            element.addContent(element4);
        }
        for (ProcessorConfigProfile processorConfigProfile : this.q) {
            Element element5 = new Element("profile");
            AnnotationProcessorProfileSerializer.writeExternal((ProcessorConfigProfile)processorConfigProfile, (Element)element5);
            element.addContent(element5);
        }
        if (!JDOMUtil.isEmpty((Element)element)) {
            element2.addContent(element);
        }
        List<String> list2 = ExternalCompilerConfigurationStorageKt.getFilteredModuleNameList(this.r, this.k, false);
        if (!StringUtil.isEmpty((String)this.h) || !list2.isEmpty()) {
            Element element6 = JdomKt.element((Element)element2, (String)"bytecodeTargetLevel");
            if (!StringUtil.isEmpty((String)this.h)) {
                element6.setAttribute("target", this.h);
            }
            ExternalCompilerConfigurationStorageKt.writeBytecodeTarget(list2, this.k, element6);
        }
        return element2;
    }

    public int getBuildProcessHeapSize(int n2) {
        int n3 = this.g.BUILD_PROCESS_HEAP_SIZE;
        if (n3 != 700) {
            return n3;
        }
        return Math.max(n3, n2);
    }

    public void setBuildProcessHeapSize(int n2) {
        this.g.BUILD_PROCESS_HEAP_SIZE = n2 > 0 ? n2 : 700;
    }

    public String getBuildProcessVMOptions() {
        return this.g.BUILD_PROCESS_ADDITIONAL_VM_OPTIONS;
    }

    public void setBuildProcessVMOptions(String string) {
        this.g.BUILD_PROCESS_ADDITIONAL_VM_OPTIONS = string == null ? "" : string.trim();
    }

    private void a(Map<String, String> map) {
        Object object;
        Object object2;
        JpsJavaCompilerOptions jpsJavaCompilerOptions = this.h();
        boolean bl2 = false;
        for (Map.Entry<String, String> processorConfigProfile : map.entrySet()) {
            object2 = this.k.remove(processorConfigProfile.getKey());
            if (object2 != null) {
                this.k.put(processorConfigProfile.getValue(), (String)object2);
                bl2 = true;
            }
            if (jpsJavaCompilerOptions == null || (object = (String)jpsJavaCompilerOptions.ADDITIONAL_OPTIONS_OVERRIDE.remove(processorConfigProfile.getKey())) == null) continue;
            jpsJavaCompilerOptions.ADDITIONAL_OPTIONS_OVERRIDE.put(processorConfigProfile.getValue(), object);
            bl2 = true;
        }
        for (ProcessorConfigProfile processorConfigProfile : this.q) {
            object2 = processorConfigProfile.getModuleNames();
            object = ContainerUtil.intersection((Collection)object2, map.keySet());
            if (object.isEmpty()) continue;
            processorConfigProfile.removeModuleNames((Collection)object);
            processorConfigProfile.addModuleNames((Collection)ContainerUtil.map((Collection)object, map::get));
            bl2 = true;
        }
        if (bl2) {
            BuildManager.getInstance().clearState(this.r);
        }
    }

    public void setProjectBytecodeTarget(@Nullable String string) {
        String string2 = this.h;
        this.h = string;
        if (!this.r.isDefault() && !Comparing.equal((String)string2, (String)string)) {
            BuildManager.getInstance().clearState(this.r);
        }
    }

    @Nullable
    public String getProjectBytecodeTarget() {
        return this.h;
    }

    public boolean useReleaseOption() {
        return this.g.USE_RELEASE_OPTION;
    }

    public void setUseReleaseOption(boolean bl2) {
        this.g.USE_RELEASE_OPTION = bl2;
    }

    public void setModulesBytecodeTargetMap(@NotNull Map<String, String> map) {
        if (map == null) {
            CompilerConfigurationImpl.a(2);
        }
        boolean bl2 = !this.r.isDefault() && !this.k.equals(map);
        this.k.clear();
        this.k.putAll(map);
        if (bl2) {
            BuildManager.getInstance().clearState(this.r);
        }
    }

    public Map<String, String> getModulesBytecodeTargetMap() {
        return this.k;
    }

    public void setBytecodeTargetLevel(Module module2, String string) {
        Project project2;
        String string2 = StringUtil.isEmpty((String)string) ? this.k.remove(module2.getName()) : this.k.put(module2.getName(), string);
        if (!Comparing.equal((String)string2, (String)string) && !(project2 = module2.getProject()).isDefault()) {
            BuildManager.getInstance().clearState(project2);
        }
    }

    @Nullable
    public String getBytecodeTargetLevel(Module module2) {
        String string = this.k.get(module2.getName());
        if (string != null) {
            return string.isEmpty() ? null : string;
        }
        return this.h;
    }

    private void f() {
        if (!this.j.isEmpty()) {
            this.a();
        }
        try {
            for (String string : JpsJavaCompilerConfigurationSerializer.DEFAULT_WILDCARD_PATTERNS) {
                this.a(string);
            }
        }
        catch (MalformedPatternException malformedPatternException) {
            m.error((Throwable)malformedPatternException);
        }
    }

    @NotNull
    public List<String> getAdditionalOptions(@NotNull Module module2) {
        String string;
        JpsJavaCompilerOptions jpsJavaCompilerOptions;
        if (module2 == null) {
            CompilerConfigurationImpl.a(3);
        }
        if ((jpsJavaCompilerOptions = this.h()) != null && !StringUtil.isEmptyOrSpaces((String)(string = jpsJavaCompilerOptions.ADDITIONAL_OPTIONS_OVERRIDE.getOrDefault(module2.getName(), jpsJavaCompilerOptions.ADDITIONAL_OPTIONS_STRING)))) {
            List list2 = ParametersListUtil.parse((String)string);
            if (list2 == null) {
                CompilerConfigurationImpl.a(4);
            }
            return list2;
        }
        List<String> list3 = Collections.emptyList();
        if (list3 == null) {
            CompilerConfigurationImpl.a(5);
        }
        return list3;
    }

    public void setAdditionalOptions(@NotNull Module module2, @NotNull List<String> list2) {
        JpsJavaCompilerOptions jpsJavaCompilerOptions;
        if (module2 == null) {
            CompilerConfigurationImpl.a(6);
        }
        if (list2 == null) {
            CompilerConfigurationImpl.a(7);
        }
        if ((jpsJavaCompilerOptions = this.h()) != null) {
            String string = jpsJavaCompilerOptions.ADDITIONAL_OPTIONS_OVERRIDE.getOrDefault(module2.getName(), jpsJavaCompilerOptions.ADDITIONAL_OPTIONS_STRING);
            String string2 = ParametersListUtil.join(list2);
            if (!string2.equals(string)) {
                jpsJavaCompilerOptions.ADDITIONAL_OPTIONS_OVERRIDE.put(module2.getName(), string2);
                BuildManager.getInstance().clearState(this.r);
            }
        }
    }

    private JpsJavaCompilerOptions h() {
        BackendCompiler backendCompiler = this.getDefaultCompiler();
        if (backendCompiler != null) {
            String string = backendCompiler.getId();
            if (string == "Javac") {
                return JavacConfiguration.getOptions(this.r, JavacConfiguration.class);
            }
            if ("Eclipse" == string) {
                return EclipseCompilerConfiguration.getOptions(this.r, EclipseCompilerConfiguration.class);
            }
        }
        return null;
    }

    public static String getTestsExternalCompilerHome() {
        String string = System.getProperty(TESTS_EXTERNAL_COMPILER_HOME_PROPERTY_NAME, null);
        if (string == null) {
            File file = new File(System.getProperty("java.home"));
            string = SystemInfo.isMac || !new File(file.getParentFile(), "bin").exists() ? file.getAbsolutePath() : file.getParentFile().getAbsolutePath();
        }
        return string;
    }

    private static Pattern c(@NonNls String string) throws MalformedPatternException {
        try {
            Perl5Compiler perl5Compiler = new Perl5Compiler();
            return SystemInfo.isFileSystemCaseSensitive ? perl5Compiler.compile(string) : perl5Compiler.compile(string, 1);
        }
        catch (org.apache.oro.text.regex.MalformedPatternException malformedPatternException) {
            throw new MalformedPatternException((Throwable)malformedPatternException);
        }
    }

    public JavacCompiler getJavacCompiler() {
        this.g();
        return this.e;
    }

    public void projectOpened() {
        this.g();
    }

    private void g() {
        Object object;
        if (this.e != null) {
            return;
        }
        this.e = new JavacCompiler(this.r);
        this.i.add(this.e);
        if (!ApplicationManager.getApplication().isUnitTestMode() && EclipseCompiler.isInitialized()) {
            object = new EclipseCompiler(this.r);
            this.i.add((BackendCompiler)object);
        }
        object = new HashSet();
        for (BackendCompiler backendCompiler : (CompilerManager)Extensions.getExtensions(BackendCompiler.EP_NAME, (AreaInstance)this.r)) {
            this.i.add(backendCompiler);
            object.addAll(backendCompiler.getCompilableFileTypes());
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.r);
        Iterator<Object> iterator = object.iterator();
        while (iterator.hasNext()) {
            FileType fileType = (FileType)iterator.next();
            compilerManager.addCompilableFileType(fileType);
        }
        this.o = this.e;
        for (BackendCompiler backendCompiler : this.i) {
            if (!backendCompiler.getId().equals(this.g.DEFAULT_COMPILER)) continue;
            this.o = backendCompiler;
            break;
        }
        this.g.DEFAULT_COMPILER = this.o.getId();
    }

    public Collection<BackendCompiler> getRegisteredJavaCompilers() {
        this.g();
        return this.i;
    }

    public String[] getResourceFilePatterns() {
        return this.b();
    }

    private String[] c() {
        String[] stringArray = ArrayUtil.newStringArray((int)this.d.size());
        int n2 = 0;
        for (Pattern pattern : this.d) {
            stringArray[n2++] = pattern.getPattern();
        }
        return stringArray;
    }

    private String[] b() {
        return ArrayUtil.toStringArray(this.j);
    }

    public void addResourceFilePattern(String string) throws MalformedPatternException {
        this.a(string);
    }

    private void d(String string) throws MalformedPatternException {
        Pattern pattern = CompilerConfigurationImpl.c(string);
        if (pattern != null) {
            this.d.add(pattern);
        }
    }

    public ExcludesConfiguration getExcludedEntriesConfiguration() {
        return this.p;
    }

    public boolean isExcludedFromCompilation(VirtualFile virtualFile) {
        return this.p.isExcluded(virtualFile);
    }

    public boolean isResourceFile(VirtualFile virtualFile) {
        return this.a(virtualFile.getName(), virtualFile.getParent());
    }

    public boolean isAddNotNullAssertions() {
        return this.s;
    }

    public void setAddNotNullAssertions(boolean bl2) {
        this.s = bl2;
    }

    @NotNull
    public ProcessorConfigProfile getDefaultProcessorProfile() {
        ProcessorConfigProfile processorConfigProfile = this.n;
        if (processorConfigProfile == null) {
            CompilerConfigurationImpl.a(8);
        }
        return processorConfigProfile;
    }

    public void setDefaultProcessorProfile(ProcessorConfigProfile processorConfigProfile) {
        this.n.initFrom(processorConfigProfile);
    }

    @NotNull
    public List<ProcessorConfigProfile> getModuleProcessorProfiles() {
        List<ProcessorConfigProfile> list2 = this.q;
        if (list2 == null) {
            CompilerConfigurationImpl.a(9);
        }
        return list2;
    }

    public void setModuleProcessorProfiles(Collection<ProcessorConfigProfile> collection) {
        this.q.clear();
        this.q.addAll(collection);
        this.b = null;
    }

    @Nullable
    public ProcessorConfigProfile findModuleProcessorProfile(@NotNull String string) {
        if (string == null) {
            CompilerConfigurationImpl.a(10);
        }
        for (ProcessorConfigProfile processorConfigProfile : this.q) {
            if (!string.equals(processorConfigProfile.getName())) continue;
            return processorConfigProfile;
        }
        return null;
    }

    public void removeModuleProcessorProfile(ProcessorConfigProfile processorConfigProfile) {
        this.q.remove(processorConfigProfile);
        this.b = null;
    }

    public void addModuleProcessorProfile(@NotNull ProcessorConfigProfile processorConfigProfile) {
        if (processorConfigProfile == null) {
            CompilerConfigurationImpl.a(11);
        }
        this.q.add(processorConfigProfile);
        this.b = null;
    }

    @NotNull
    public ProcessorConfigProfile getAnnotationProcessingConfiguration(Module module2) {
        Object object;
        Map<Module, ProcessorConfigProfile> map = this.b;
        if (map == null) {
            map = new HashMap<Module, ProcessorConfigProfile>();
            object = new HashMap();
            for (Object object2 : ModuleManager.getInstance((Project)module2.getProject()).getModules()) {
                object.put(object2.getName(), object2);
            }
            if (!object.isEmpty()) {
                for (ProcessorConfigProfile processorConfigProfile : this.q) {
                    for (Object object2 : processorConfigProfile.getModuleNames()) {
                        Module module3 = (Module)object.get(object2);
                        if (module3 == null) continue;
                        map.put(module3, processorConfigProfile);
                    }
                }
            }
            this.b = map;
        }
        Object object3 = (object = map.get(module2)) != null ? object : this.n;
        if (object3 == null) {
            CompilerConfigurationImpl.a(12);
        }
        return object3;
    }

    public boolean isAnnotationProcessorsEnabled() {
        if (this.n.isEnabled()) {
            return true;
        }
        for (ProcessorConfigProfile processorConfigProfile : this.q) {
            if (!processorConfigProfile.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void a(@NonNls String string) throws MalformedPatternException {
        CompiledPattern compiledPattern = CompilerConfigurationImpl.e(string);
        this.j.add(string);
        if (CompilerConfigurationImpl.isPatternNegated(string)) {
            this.l.add(compiledPattern);
        } else {
            this.c.add(compiledPattern);
        }
    }

    public void removeResourceFilePatterns() {
        this.a();
    }

    private void e() {
        this.d.clear();
    }

    private void a() {
        this.j.clear();
        this.c.clear();
        this.l.clear();
    }

    private static CompiledPattern e(String string) {
        if (CompilerConfigurationImpl.isPatternNegated(string)) {
            string = string.substring(1);
        }
        string = FileUtil.toSystemIndependentName((String)string);
        String string2 = null;
        int n2 = string.indexOf(":");
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            string = string.substring(n2 + 1);
        }
        String string3 = null;
        int n3 = string.lastIndexOf(47);
        if (n3 >= 0) {
            string3 = string.substring(0, n3 + 1);
            string = string.substring(n3 + 1);
            string3 = ResourcePatterns.optimizeDirPattern((String)string3);
        }
        string = ResourcePatterns.normalizeWildcards((String)string);
        string = CompilerConfigurationImpl.b(string);
        Pattern pattern = string3 == null ? null : CompilerConfigurationImpl.c(string3);
        Pattern pattern2 = string2 == null ? null : CompilerConfigurationImpl.c(CompilerConfigurationImpl.b(ResourcePatterns.normalizeWildcards((String)string2)));
        return new CompiledPattern(CompilerConfigurationImpl.c(string), pattern, pattern2);
    }

    private static String b(String string) {
        return string.replaceAll("(?:\\.\\*)+", ".*");
    }

    public static boolean isPatternNegated(String string) {
        return string.length() > 1 && string.charAt(0) == '!';
    }

    public boolean isResourceFile(String string) {
        return this.a(string, (VirtualFile)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(String string, Pattern pattern) {
        Perl5Matcher perl5Matcher = this.a;
        synchronized (perl5Matcher) {
            try {
                return this.a.matches(string, pattern);
            }
            catch (Exception exception) {
                m.error("Exception matching file name \"" + string + "\" against the pattern \"" + pattern + "\"", (Throwable)exception);
                return false;
            }
        }
    }

    private boolean a(String string, @Nullable VirtualFile virtualFile) {
        int n2;
        Ref ref = Ref.create(null);
        for (n2 = 0; n2 < this.c.size(); ++n2) {
            if (!this.a(string, virtualFile, (Ref<String>)ref, this.c.get(n2))) continue;
            return true;
        }
        if (this.l.isEmpty()) {
            return false;
        }
        for (n2 = 0; n2 < this.l.size(); ++n2) {
            if (!this.a(string, virtualFile, (Ref<String>)ref, this.l.get(n2))) continue;
            return false;
        }
        return true;
    }

    private boolean a(String string, VirtualFile virtualFile, Ref<String> ref, CompiledPattern compiledPattern) {
        if (!this.a(string, compiledPattern.fileName)) {
            return false;
        }
        if (virtualFile != null && (compiledPattern.dir != null || compiledPattern.srcRoot != null)) {
            String string2;
            VirtualFile virtualFile2 = ProjectRootManager.getInstance((Project)this.r).getFileIndex().getSourceRootForFile(virtualFile);
            if (compiledPattern.dir != null) {
                string2 = (String)ref.get();
                if (string2 == null) {
                    string2 = virtualFile2 == null ? virtualFile.getPath() : VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (char)'/');
                    ref.set((Object)string2);
                }
                if (string2 == null || !this.a("/" + string2, compiledPattern.dir)) {
                    return false;
                }
            }
            if (compiledPattern.srcRoot != null) {
                String string3 = string2 = virtualFile2 == null ? null : virtualFile2.getName();
                if (string2 == null || !this.a(string2, compiledPattern.srcRoot)) {
                    return false;
                }
            }
        }
        return true;
    }

    public void loadState(@NotNull Element element) {
        String string;
        Object object;
        Object object22;
        Element element2;
        Object object3;
        if (element == null) {
            CompilerConfigurationImpl.a(13);
        }
        this.g = (State)XmlSerializer.deserialize((Element)element, State.class);
        if (!this.r.isDefault()) {
            object3 = element.getChildren("option").iterator();
            while (object3.hasNext() && !"DEFAULT_COMPILER".equals((element2 = (Element)object3.next()).getAttributeValue("name"))) {
            }
            if (this.g.BUILD_PROCESS_HEAP_SIZE == 700) {
                object3 = CompilerWorkspaceConfiguration.getInstance((Project)this.r);
                this.g.BUILD_PROCESS_HEAP_SIZE = ((CompilerWorkspaceConfiguration)object3).COMPILER_PROCESS_HEAP_SIZE;
            }
        }
        if ((object3 = element.getChild("addNotNullAssertions")) != null) {
            this.s = Boolean.valueOf(object3.getAttributeValue("enabled", "true"));
        }
        if ((element2 = element.getChild("excludeFromCompile")) != null) {
            this.p.readExternal(element2);
        }
        try {
            this.e();
            element2 = element.getChild("resourceExtensions");
            if (element2 != null) {
                for (Object object22 : element2.getChildren("entry")) {
                    object = (Element)object22;
                    string = object.getAttributeValue("name");
                    if (StringUtil.isEmpty((String)string)) continue;
                    this.d(string);
                }
            }
            if ((element2 = element.getChild("wildcardResourcePatterns")) != null) {
                this.f = true;
                this.a();
                for (Object object22 : element2.getChildren("entry")) {
                    object = object22.getAttributeValue("name");
                    if (StringUtil.isEmpty((String)object)) continue;
                    this.a((String)object);
                }
            }
        }
        catch (MalformedPatternException malformedPatternException) {
            m.error((Throwable)malformedPatternException);
        }
        this.q.clear();
        this.b = null;
        Element element3 = element.getChild("annotationProcessing");
        if (element3 != null) {
            object22 = element3.getChildren("profile");
            if (!object22.isEmpty()) {
                object = object22.iterator();
                while (object.hasNext()) {
                    string = object.next();
                    Element element4 = (Element)string;
                    boolean bl2 = "true".equals(element4.getAttributeValue("default"));
                    if (bl2) {
                        AnnotationProcessorProfileSerializer.readExternal((ProcessorConfigProfile)this.n, (Element)element4);
                        continue;
                    }
                    ProcessorConfigProfileImpl processorConfigProfileImpl = new ProcessorConfigProfileImpl("");
                    AnnotationProcessorProfileSerializer.readExternal((ProcessorConfigProfile)processorConfigProfileImpl, (Element)element4);
                    this.q.add((ProcessorConfigProfile)processorConfigProfileImpl);
                }
            } else {
                this.a(element3);
            }
        }
        this.h = null;
        this.k.clear();
        object22 = element.getChild("bytecodeTargetLevel");
        if (object22 != null) {
            this.h = object22.getAttributeValue("target");
            ExternalCompilerConfigurationStorageKt.readByteTargetLevel(element, this.k);
        }
        if ((object = ((ExternalCompilerConfigurationStorage)this.r.getComponent(ExternalCompilerConfigurationStorage.class)).getLoadedState()) != null) {
            this.k.putAll((Map<String, String>)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(Element element) {
        String string;
        Set<Object> set;
        Element element2;
        boolean bl2 = Boolean.parseBoolean(element.getAttributeValue("enabled", "false"));
        boolean bl3 = Boolean.parseBoolean(element.getAttributeValue("useClasspath", "true"));
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        ArrayList<Couple> arrayList = new ArrayList<Couple>();
        for (Object object2 : element.getChildren("processorPath")) {
            element2 = (Element)object2;
            String string2 = element2.getAttributeValue("value", (String)null);
            if (string2 == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(string2);
        }
        for (Object e2 : element.getChildren("processor")) {
            element2 = (Element)e2;
            String string3 = element2.getAttributeValue("name", (String)null);
            if (string3 != null) {
                hashSet2.add(string3);
            }
            set = new StringTokenizer(element2.getAttributeValue("options", ""), " ", false);
            while (((StringTokenizer)((Object)set)).hasMoreTokens()) {
                string = ((StringTokenizer)((Object)set)).nextToken();
                hashSet.add(string);
            }
        }
        for (Object e3 : element.getChildren("processModule")) {
            element2 = (Element)e3;
            String string4 = element2.getAttributeValue("name", (String)null);
            if (string4 == null) continue;
            set = element2.getAttributeValue("generatedDirName", (String)null);
            arrayList.add(Couple.of((Object)string4, (Object)set));
        }
        this.n.setEnabled(false);
        this.n.setObtainProcessorsFromClasspath(bl3);
        if (stringBuilder.length() > 0) {
            this.n.setProcessorPath(stringBuilder.toString());
        }
        if (!hashSet.isEmpty()) {
            for (String string5 : hashSet) {
                int n2 = string5.indexOf("=");
                if (n2 <= 0) continue;
                this.n.setOption(string5.substring(0, n2), string5.substring(n2 + 1));
            }
        }
        for (String string6 : hashSet2) {
            this.n.addProcessor(string6);
        }
        HashMap hashMap = new HashMap();
        for (Couple couple : arrayList) {
            String string7 = (String)couple.getSecond();
            set = (Set)hashMap.get(string7);
            if (set == null) {
                set = new HashSet<Object>();
                hashMap.put(string7, set);
            }
            set.add(couple.getFirst());
        }
        boolean bl4 = false;
        for (Map.Entry entry : hashMap.entrySet()) {
            void var9_20;
            set = (String)entry.getKey();
            string = new ProcessorConfigProfileImpl(this.n);
            string.setName("Profile" + (int)(++var9_20));
            string.setEnabled(bl2);
            string.setGeneratedSourcesDirectoryName(set, false);
            for (String string8 : (Set)entry.getValue()) {
                string.addModuleName(string8);
            }
            this.q.add((ProcessorConfigProfile)string);
        }
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("CompilerConfiguration" == null) {
            CompilerConfigurationImpl.a(14);
        }
        return "CompilerConfiguration";
    }

    public BackendCompiler getDefaultCompiler() {
        this.g();
        return this.o;
    }

    public void setDefaultCompiler(BackendCompiler backendCompiler) {
        this.o = backendCompiler;
        this.g.DEFAULT_COMPILER = backendCompiler.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertPatterns() {
        if (!this.i()) {
            return;
        }
        try {
            boolean bl2;
            try {
                bl2 = this.d();
            }
            catch (MalformedPatternException malformedPatternException) {
                bl2 = false;
            }
            if (!bl2) {
                String string = CompilerConfigurationImpl.a(this.c());
                String string2 = CompilerBundle.message((String)"message.resource.patterns.format.changed", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), string, CommonBundle.getOkButtonText(), CommonBundle.getCancelButtonText()});
                String string3 = Messages.showInputDialog((Project)this.r, (String)string2, (String)CompilerBundle.message((String)"pattern.conversion.dialog.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon(), (String)string, (InputValidator)new InputValidator(){

                    public boolean checkInput(String string) {
                        return true;
                    }

                    public boolean canClose(String string) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
                        StringBuilder stringBuilder = new StringBuilder();
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            try {
                                CompilerConfigurationImpl.this.a(string2);
                            }
                            catch (MalformedPatternException malformedPatternException) {
                                stringBuilder.append("\n\n");
                                stringBuilder.append(string2);
                                stringBuilder.append(": ");
                                stringBuilder.append(malformedPatternException.getMessage());
                            }
                        }
                        if (stringBuilder.length() > 0) {
                            Messages.showErrorDialog((String)CompilerBundle.message((String)"error.bad.resource.patterns", (Object[])new Object[]{stringBuilder.toString()}), (String)CompilerBundle.message((String)"bad.resource.patterns.dialog.title", (Object[])new Object[0]));
                            CompilerConfigurationImpl.this.a();
                            return false;
                        }
                        return true;
                    }
                });
                if (string3 == null) {
                    this.f();
                }
            }
        }
        finally {
            this.f = true;
        }
    }

    private boolean i() {
        return !this.f && !this.d.isEmpty();
    }

    private boolean d() throws MalformedPatternException {
        String[] stringArray = this.c();
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = CompilerConfigurationImpl.c("\\.\\+\\\\\\.\\((\\w+(?:\\|\\w+)*)\\)");
        Pattern pattern2 = CompilerConfigurationImpl.c("\\.\\+\\\\\\.(\\w+)");
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        for (String string : stringArray) {
            MatchResult matchResult;
            if (perl5Matcher.matches(string, pattern)) {
                matchResult = perl5Matcher.getMatch();
                StringTokenizer stringTokenizer = new StringTokenizer(matchResult.group(1), "|", false);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add("?*." + stringTokenizer.nextToken());
                }
                continue;
            }
            if (perl5Matcher.matches(string, pattern2)) {
                matchResult = perl5Matcher.getMatch();
                arrayList.add("?*." + matchResult.group(1));
                continue;
            }
            return false;
        }
        for (String string : arrayList) {
            this.a(string);
        }
        return true;
    }

    private static String a(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    public boolean isCompilableResourceFile(Project project2, VirtualFile virtualFile) {
        if (!this.isResourceFile(virtualFile)) {
            return false;
        }
        Collection<? extends Artifact> collection = ArtifactBySourceFileFinder.getInstance(project2).findArtifacts(virtualFile);
        return collection.isEmpty();
    }

    private static Element a(Element element, String string) {
        Element element2 = new Element(string);
        element.addContent(element2);
        return element2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/CompilerConfigurationImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/CompilerConfigurationImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createExcludedEntriesConfiguration";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProcessorProfile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleProcessorProfiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessingConfiguration";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExcludedEntriesConfiguration";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModulesBytecodeTargetMap";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalOptions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalOptions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findModuleProcessorProfile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addModuleProcessorProfile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompiledPattern {
        @NotNull
        final Pattern fileName;
        @Nullable
        final Pattern dir;
        @Nullable
        final Pattern srcRoot;

        private CompiledPattern(@NotNull Pattern pattern, @Nullable Pattern pattern2, @Nullable Pattern pattern3) {
            if (pattern == null) {
                CompiledPattern.a(0);
            }
            this.fileName = pattern;
            this.dir = pattern2;
            this.srcRoot = pattern3;
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/compiler/CompilerConfigurationImpl$CompiledPattern", "<init>"));
        }
    }

    private static class State {
        public String DEFAULT_COMPILER = "Javac";
        public int BUILD_PROCESS_HEAP_SIZE = 700;
        public String BUILD_PROCESS_ADDITIONAL_VM_OPTIONS = "";
        public boolean USE_RELEASE_OPTION = true;

        private State() {
        }
    }
}

