/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.task.ProjectTaskManager;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import gnu.trove.TIntArrayList;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildArtifactAction
extends DumbAwareAction {
    private static final NotificationGroup a = NotificationGroup.balloonGroup((String)"Clean artifact");

    public BuildArtifactAction() {
        super("Build Artifacts...", "Select and build artifacts configured in the project", null);
    }

    public void update(AnActionEvent anActionEvent) {
        Project project2 = BuildArtifactAction.getEventProject((AnActionEvent)anActionEvent);
        Presentation presentation = anActionEvent.getPresentation();
        presentation.setEnabled(project2 != null && !ArtifactUtil.getArtifactWithOutputPaths(project2).isEmpty());
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Object object;
        Object object22;
        Project project2 = BuildArtifactAction.getEventProject((AnActionEvent)anActionEvent);
        if (project2 == null) {
            return;
        }
        List<Artifact> list2 = ArtifactUtil.getArtifactWithOutputPaths(project2);
        if (list2.isEmpty()) {
            return;
        }
        ArrayList<ArtifactPopupItem> arrayList = new ArrayList<ArtifactPopupItem>();
        if (list2.size() > 1) {
            arrayList.add(0, new ArtifactPopupItem(null, "All Artifacts", EmptyIcon.ICON_16));
        }
        HashSet<Artifact> hashSet = new HashSet<Artifact>(ArtifactsWorkspaceSettings.getInstance(project2).getArtifactsToBuild());
        TIntArrayList tIntArrayList = new TIntArrayList();
        if (Comparing.haveEqualElements(list2, hashSet) && hashSet.size() > 1) {
            tIntArrayList.add(0);
            hashSet.clear();
        }
        for (Object object22 : list2) {
            object = new ArtifactPopupItem((Artifact)object22, object22.getName(), object22.getArtifactType().getIcon());
            if (hashSet.contains(object22)) {
                tIntArrayList.add(arrayList.size());
            }
            arrayList.add((ArtifactPopupItem)object);
        }
        ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance((Project)project2);
        object22 = projectSettingsService instanceof ArtifactAwareProjectSettingsService ? (ArtifactAwareProjectSettingsService)projectSettingsService : null;
        object = new ChooseArtifactStep(arrayList, list2.get(0), project2, (ArtifactAwareProjectSettingsService)object22);
        object.setDefaultOptionIndices(tIntArrayList.toNativeArray());
        final ListPopupImpl listPopupImpl = (ListPopupImpl)JBPopupFactory.getInstance().createListPopup((ListPopupStep)object);
        KeyStroke keyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getEditSource());
        if (object22 != null && keyStroke != null) {
            listPopupImpl.registerAction("editArtifact", keyStroke, (Action)new AbstractAction((ArtifactAwareProjectSettingsService)object22){
                final /* synthetic */ ArtifactAwareProjectSettingsService val$settingsService;
                {
                    this.val$settingsService = artifactAwareProjectSettingsService;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = listPopupImpl.getSelectedValues();
                    listPopupImpl.cancel();
                    this.val$settingsService.openArtifactSettings(objectArray.length > 0 ? ((ArtifactPopupItem)objectArray[0]).getArtifact() : null);
                }
            });
        }
        listPopupImpl.showCenteredInCurrentWindow(project2);
    }

    private static void a(@NotNull Project project2, @NotNull List<ArtifactPopupItem> list2, boolean bl2) {
        if (project2 == null) {
            BuildArtifactAction.a(0);
        }
        if (list2 == null) {
            BuildArtifactAction.a(1);
        }
        Artifact[] artifactArray = BuildArtifactAction.a(list2, project2);
        if (bl2) {
            ProjectTaskManager.getInstance((Project)project2).rebuild(artifactArray);
        } else {
            ProjectTaskManager.getInstance((Project)project2).build(artifactArray);
        }
    }

    private static Artifact[] a(List<ArtifactPopupItem> list2, Project project2) {
        LinkedHashSet<Artifact> linkedHashSet = new LinkedHashSet<Artifact>();
        for (ArtifactPopupItem artifactPopupItem : list2) {
            linkedHashSet.addAll(artifactPopupItem.getArtifacts(project2));
        }
        return (Artifact[])ContainerUtil.toArray(linkedHashSet, (Object[])new Artifact[linkedHashSet.size()]);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "items";
                break;
            }
        }
        objectArray[1] = "com/intellij/compiler/actions/BuildArtifactAction";
        objectArray[2] = "doBuild";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChooseArtifactStep
    extends MultiSelectionListPopupStep<ArtifactPopupItem> {
        private final Artifact b;
        private final Project a;
        private final ArtifactAwareProjectSettingsService c;

        public ChooseArtifactStep(List<ArtifactPopupItem> list2, Artifact artifact, Project project2, ArtifactAwareProjectSettingsService artifactAwareProjectSettingsService) {
            super("Build Artifact", list2);
            this.b = artifact;
            this.a = project2;
            this.c = artifactAwareProjectSettingsService;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public Icon getIconFor(ArtifactPopupItem artifactPopupItem) {
            return artifactPopupItem.getIcon();
        }

        @NotNull
        public String getTextFor(ArtifactPopupItem artifactPopupItem) {
            String string = artifactPopupItem.getText();
            if (string == null) {
                ChooseArtifactStep.a(0);
            }
            return string;
        }

        public boolean hasSubstep(List<ArtifactPopupItem> list2) {
            return true;
        }

        public ListSeparator getSeparatorAbove(ArtifactPopupItem artifactPopupItem) {
            return this.b.equals(artifactPopupItem.getArtifact()) ? new ListSeparator() : null;
        }

        public PopupStep<?> onChosen(List<ArtifactPopupItem> list2, boolean bl2) {
            if (bl2) {
                return this.doFinalStep(() -> BuildArtifactAction.a(this.a, list2, false));
            }
            ArrayList<ArtifactActionItem> arrayList = new ArrayList<ArtifactActionItem>();
            arrayList.add(new BuildArtifactItem((List)list2, this.a));
            arrayList.add(new RebuildArtifactItem((List)list2, this.a));
            arrayList.add(new CleanArtifactItem((List)list2, this.a));
            if (this.c != null) {
                arrayList.add(new EditArtifactItem(list2, this.a, this.c));
            }
            return new BaseListPopupStep<ArtifactActionItem>(list2.size() == 1 ? "Action" : "Action for " + list2.size() + " artifacts", arrayList){

                @NotNull
                public String getTextFor(ArtifactActionItem artifactActionItem) {
                    String string = artifactActionItem.getActionName();
                    if (string == null) {
                        1.a(0);
                    }
                    return string;
                }

                public PopupStep onChosen(ArtifactActionItem artifactActionItem, boolean bl2) {
                    return this.doFinalStep(artifactActionItem);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/actions/BuildArtifactAction$ChooseArtifactStep$1", "getTextFor"));
                }
            };
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/actions/BuildArtifactAction$ChooseArtifactStep", "getTextFor"));
        }
    }

    private static class ArtifactPopupItem {
        @Nullable
        private final Artifact c;
        private final String b;
        private final Icon a;

        private ArtifactPopupItem(@Nullable Artifact artifact, String string, Icon icon) {
            this.c = artifact;
            this.b = string;
            this.a = icon;
        }

        @Nullable
        public Artifact getArtifact() {
            return this.c;
        }

        public String getText() {
            return this.b;
        }

        public Icon getIcon() {
            return this.a;
        }

        public List<Artifact> getArtifacts(Project project2) {
            Artifact artifact = this.getArtifact();
            return artifact != null ? Collections.singletonList(artifact) : ArtifactUtil.getArtifactWithOutputPaths(project2);
        }
    }

    private static abstract class ArtifactActionItem
    implements Runnable {
        protected final List<ArtifactPopupItem> myArtifactPopupItems;
        protected final Project myProject;
        private final String a;

        protected ArtifactActionItem(@NotNull List<ArtifactPopupItem> list2, @NotNull Project project2, @NotNull String string) {
            if (list2 == null) {
                ArtifactActionItem.a(0);
            }
            if (project2 == null) {
                ArtifactActionItem.a(1);
            }
            if (string == null) {
                ArtifactActionItem.a(2);
            }
            this.myArtifactPopupItems = list2;
            this.myProject = project2;
            this.a = string;
        }

        public String getActionName() {
            return this.a;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/actions/BuildArtifactAction$ArtifactActionItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EditArtifactItem
    extends ArtifactActionItem {
        private final ArtifactAwareProjectSettingsService b;

        private EditArtifactItem(List<ArtifactPopupItem> list2, Project project2, ArtifactAwareProjectSettingsService artifactAwareProjectSettingsService) {
            super(list2, project2, "Edit...");
            this.b = artifactAwareProjectSettingsService;
        }

        @Override
        public void run() {
            this.b.openArtifactSettings(((ArtifactPopupItem)this.myArtifactPopupItems.get(0)).getArtifact());
        }
    }

    private static class RebuildArtifactItem
    extends ArtifactActionItem {
        private RebuildArtifactItem(List<ArtifactPopupItem> list2, Project project2) {
            super(list2, project2, "Rebuild");
        }

        @Override
        public void run() {
            BuildArtifactAction.a(this.myProject, this.myArtifactPopupItems, true);
        }
    }

    private static class CleanArtifactItem
    extends ArtifactActionItem {
        private CleanArtifactItem(@NotNull List<ArtifactPopupItem> list2, @NotNull Project project2) {
            if (list2 == null) {
                CleanArtifactItem.b(0);
            }
            if (project2 == null) {
                CleanArtifactItem.b(1);
            }
            super(list2, project2, "Clean");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Artifact[] virtualFile;
            HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>();
            VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots();
            Object object2 = virtualFileArray;
            int n2 = ((VirtualFile[])object2).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                VirtualFile object;
                for (VirtualFile virtualFile2 = object = object2[i2]; virtualFile2 != null && !hashSet.contains(virtualFile2); virtualFile2 = virtualFile2.getParent()) {
                    hashSet.add(virtualFile2);
                }
            }
            object2 = new HashMap();
            final ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Object object : virtualFile = BuildArtifactAction.a(this.myArtifactPopupItems, this.myProject)) {
                String string = object.getOutputFilePath();
                if (string == null) continue;
                arrayList.add(Pair.create((Object)new File(FileUtil.toSystemDependentName((String)string)), (Object)object));
                VirtualFile virtualFile3 = LocalFileSystem.getInstance().findFileByPath(string);
                if (!hashSet.contains(virtualFile3)) continue;
                object2.put(object.getName(), string);
            }
            if (!object2.isEmpty()) {
                void var6_12;
                CharSequence charSequence;
                if (object2.size() == 1 && object2.values().size() == 1) {
                    charSequence = (String)ContainerUtil.getFirstItem(object2.keySet());
                    String string = (String)object2.get(charSequence);
                    String string2 = "The output directory '" + string + "' of '" + (String)charSequence + "' artifact contains source roots of the project. Do you want to continue and clear it?";
                } else {
                    charSequence = new StringBuilder();
                    for (Object object : object2.keySet()) {
                        ((StringBuilder)charSequence).append(" '").append((String)object).append("' artifact ('").append((String)object2.get(object)).append("')\n");
                    }
                    String string = "The output directories of the following artifacts contains source roots:\n" + charSequence + "Do you want to continue and clear these directories?";
                }
                int n3 = Messages.showYesNoDialog((Project)this.myProject, (String)var6_12, (String)"Clean Artifacts", null);
                if (n3 != 0) {
                    return;
                }
            }
            new Task.Backgroundable(this.myProject, "Cleaning Artifacts", true){

                public void run(@NotNull ProgressIndicator progressIndicator) {
                    if (progressIndicator == null) {
                        1.a(0);
                    }
                    ArrayList<File> arrayList2 = new ArrayList<File>();
                    for (Pair pair2 : arrayList) {
                        progressIndicator.checkCanceled();
                        File file = (File)pair2.getFirst();
                        if (!FileUtil.delete((File)file)) {
                            a.createNotification("Cannot clean '" + ((Artifact)pair2.getSecond()).getName() + "' artifact", "cannot delete '" + file.getAbsolutePath() + "'", NotificationType.ERROR, null).notify(this.myProject);
                            continue;
                        }
                        arrayList2.add(file);
                    }
                    LocalFileSystem.getInstance().refreshIoFiles(arrayList2, true, true, null);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/compiler/actions/BuildArtifactAction$CleanArtifactItem$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/actions/BuildArtifactAction$CleanArtifactItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BuildArtifactItem
    extends ArtifactActionItem {
        private BuildArtifactItem(List<ArtifactPopupItem> list2, Project project2) {
            super(list2, project2, "Build");
        }

        @Override
        public void run() {
            BuildArtifactAction.a(this.myProject, this.myArtifactPopupItems, false);
        }
    }
}

