/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.CleanModule;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompileModuleChunkTarget;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.ModuleChunkClasspath;
import com.intellij.compiler.ant.ModuleChunkSourcePath;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.Property;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;

public class ChunkBuild
extends CompositeGenerator {
    public ChunkBuild(Project project2, ModuleChunk moduleChunk, GenerationOptions generationOptions) {
        StringBuilder stringBuilder;
        File file = moduleChunk.getBaseDir();
        if (generationOptions.forceTargetJdk) {
            if (moduleChunk.isJdkInherited()) {
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkHomeProperty((String)moduleChunk.getName()), BuildProperties.propertyRef((String)"project.jdk.home")));
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkBinProperty((String)moduleChunk.getName()), BuildProperties.propertyRef((String)"project.jdk.bin")));
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkClasspathProperty((String)moduleChunk.getName()), BuildProperties.propertyRef((String)"project.jdk.classpath")));
            } else {
                stringBuilder = moduleChunk.getJdk();
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkHomeProperty((String)moduleChunk.getName()), stringBuilder != null ? BuildProperties.propertyRef((String)BuildProperties.getJdkHomeProperty((String)stringBuilder.getName())) : ""));
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkBinProperty((String)moduleChunk.getName()), stringBuilder != null ? BuildProperties.propertyRef((String)BuildProperties.getJdkBinProperty((String)stringBuilder.getName())) : ""));
                this.add((Generator)new Property(BuildProperties.getModuleChunkJdkClasspathProperty((String)moduleChunk.getName()), stringBuilder != null ? BuildProperties.getJdkPathId((String)stringBuilder.getName()) : ""));
            }
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append(moduleChunk.getChunkSpecificCompileOptions());
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(BuildProperties.propertyRef((String)"compiler.args"));
        this.add((Generator)new Property(BuildProperties.getModuleChunkCompilerArgsProperty((String)moduleChunk.getName()), stringBuilder.toString()), 1);
        String string = moduleChunk.getOutputDirUrl();
        String string2 = string != null ? GenerationUtils.toRelativePath((String)VirtualFileManager.extractPath((String)string), (File)file, (String)BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)moduleChunk), (GenerationOptions)generationOptions) : CompilerBundle.message((String)"value.undefined", (Object[])new Object[0]);
        this.add((Generator)new Property(BuildProperties.getOutputPathProperty((String)moduleChunk.getName()), string2), 1);
        String string3 = moduleChunk.getTestsOutputDirUrl();
        if (string3 != null) {
            string2 = GenerationUtils.toRelativePath((String)VirtualFileManager.extractPath((String)string3), (File)file, (String)BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)moduleChunk), (GenerationOptions)generationOptions);
        }
        this.add((Generator)new Property(BuildProperties.getOutputPathForTestsProperty((String)moduleChunk.getName()), string2));
        this.add(ChunkBuild.a(moduleChunk), 1);
        this.add((Generator)new ModuleChunkClasspath(moduleChunk, generationOptions, false, false), 1);
        this.add((Generator)new ModuleChunkClasspath(moduleChunk, generationOptions, true, false), 1);
        this.add((Generator)new ModuleChunkClasspath(moduleChunk, generationOptions, false, true), 1);
        this.add((Generator)new ModuleChunkClasspath(moduleChunk, generationOptions, true, true), 1);
        ModuleChunkSourcePath moduleChunkSourcePath = new ModuleChunkSourcePath(project2, moduleChunk, generationOptions);
        this.add((Generator)moduleChunkSourcePath, 1);
        this.add((Generator)new CompileModuleChunkTarget(project2, moduleChunk, moduleChunkSourcePath.getSourceRoots(), moduleChunkSourcePath.getTestSourceRoots(), file, generationOptions), 1);
        this.add((Generator)new CleanModule(moduleChunk), 1);
        ChunkBuildExtension.process((CompositeGenerator)this, (ModuleChunk)moduleChunk, (GenerationOptions)generationOptions);
    }

    private static Generator a(ModuleChunk moduleChunk) {
        Path path = new Path(BuildProperties.getBootClasspathProperty((String)moduleChunk.getName()));
        path.add((Generator)new Comment(CompilerBundle.message((String)"generated.ant.build.bootclasspath.comment", (Object[])new Object[0])));
        return path;
    }
}

