/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.backwardRefs.OccurrenceCounter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.Queue;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerBackwardReferenceIndex;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;
import org.jetbrains.jps.backwardRefs.SignatureData;
import org.jetbrains.jps.backwardRefs.index.CompilerIndices;

class CompilerReferenceReader {
    private static final Logger c = Logger.getInstance(CompilerReferenceReader.class);
    private final CompilerBackwardReferenceIndex a;
    private final File b;

    private CompilerReferenceReader(File file) {
        this.a = new CompilerBackwardReferenceIndex(file, true);
        this.b = file;
    }

    @Nullable
    TIntHashSet findReferentFileIds(@NotNull LightRef lightRef, boolean bl2) throws StorageException {
        LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef;
        LightRef.NamedLightRef[] namedLightRefArray;
        if (lightRef == null) {
            CompilerReferenceReader.b(0);
        }
        if (lightRef instanceof LightRef.LightClassHierarchyElementDef) {
            namedLightRefArray = new LightRef.NamedLightRef[]{(LightRef.NamedLightRef)lightRef};
        } else {
            lightClassHierarchyElementDef = ((LightRef.LightMember)lightRef).getOwner();
            namedLightRefArray = this.getHierarchy(lightClassHierarchyElementDef, bl2, false, -1);
        }
        if (namedLightRefArray == null) {
            return null;
        }
        lightClassHierarchyElementDef = new TIntHashSet();
        for (LightRef.NamedLightRef namedLightRef : namedLightRefArray) {
            LightRef lightRef2 = lightRef.override(namedLightRef.getName());
            this.a(lightRef2, (TIntHashSet)lightClassHierarchyElementDef);
        }
        return lightClassHierarchyElementDef;
    }

    @NotNull
    Map<VirtualFile, SearchId[]> getDirectInheritors(@NotNull LightRef lightRef, @NotNull GlobalSearchScope globalSearchScope, @NotNull GlobalSearchScope globalSearchScope2, @NotNull FileType fileType, @NotNull CompilerHierarchySearchType compilerHierarchySearchType) throws StorageException {
        if (lightRef == null) {
            CompilerReferenceReader.b(1);
        }
        if (globalSearchScope == null) {
            CompilerReferenceReader.b(2);
        }
        if (globalSearchScope2 == null) {
            CompilerReferenceReader.b(3);
        }
        if (fileType == null) {
            CompilerReferenceReader.b(4);
        }
        if (compilerHierarchySearchType == null) {
            CompilerReferenceReader.b(5);
        }
        GlobalSearchScope globalSearchScope3 = GlobalSearchScope.notScope((GlobalSearchScope)globalSearchScope2).intersectWith(globalSearchScope);
        LanguageLightRefAdapter languageLightRefAdapter = LanguageLightRefAdapter.findAdapter(fileType);
        c.assertTrue(languageLightRefAdapter != null, (Object)("adapter is null for file type: " + fileType));
        Class<? extends LightRef> clazz = compilerHierarchySearchType.getRequiredClass(languageLightRefAdapter);
        HashMap hashMap = new HashMap();
        this.a.get(CompilerIndices.BACK_HIERARCHY).getData((Object)lightRef).forEach((n2, collection) -> {
            if (compilerHierarchySearchType == null) {
                CompilerReferenceReader.b(18);
            }
            List<LightRef> list2 = collection.stream().filter(clazz::isInstance).collect(Collectors.toList());
            if (list2.isEmpty()) {
                return true;
            }
            VirtualFile virtualFile = this.a(n2);
            if (virtualFile != null && globalSearchScope3.contains(virtualFile)) {
                hashMap.put(virtualFile, compilerHierarchySearchType.convertToIds(list2, this.a.getByteSeqEum()));
            }
            return true;
        });
        Map<Object, Object> map = hashMap.isEmpty() ? Collections.emptyMap() : hashMap;
        if (map == null) {
            CompilerReferenceReader.b(6);
        }
        return map;
    }

    @Nullable
    Integer getAnonymousCount(@NotNull LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef, boolean bl2) {
        if (lightClassHierarchyElementDef == null) {
            CompilerReferenceReader.b(7);
        }
        try {
            if (bl2 && this.b((LightRef.NamedLightRef)lightClassHierarchyElementDef) != DefCount.ONE) {
                return null;
            }
            final int[] nArray = new int[]{0};
            this.a.get(CompilerIndices.BACK_HIERARCHY).getData((Object)lightClassHierarchyElementDef).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Collection<LightRef>>(){

                public boolean perform(int n2, Collection<LightRef> collection) {
                    nArray[0] = nArray[0] + collection.size();
                    return true;
                }
            });
            return nArray[0];
        }
        catch (StorageException storageException) {
            throw new RuntimeException(storageException);
        }
    }

    int getOccurrenceCount(@NotNull LightRef lightRef) {
        if (lightRef == null) {
            CompilerReferenceReader.b(8);
        }
        try {
            final int[] nArray = new int[]{0};
            this.a.get(CompilerIndices.BACK_USAGES).getData((Object)lightRef).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Integer>(){

                public boolean perform(int n2, Integer n3) {
                    nArray[0] = nArray[0] + n3;
                    return true;
                }
            });
            return nArray[0];
        }
        catch (StorageException storageException) {
            throw new RuntimeException(storageException);
        }
    }

    @NotNull
    List<LightRef> getMembersFor(@NotNull SignatureData signatureData) {
        ArrayList<LightRef> arrayList;
        if (signatureData == null) {
            CompilerReferenceReader.b(9);
        }
        try {
            ArrayList<LightRef> arrayList2 = new ArrayList<LightRef>();
            this.a.get(CompilerIndices.BACK_MEMBER_SIGN).getData((Object)signatureData).forEach((n2, collection) -> {
                arrayList2.addAll((Collection<LightRef>)collection);
                return true;
            });
            arrayList = arrayList2;
        }
        catch (StorageException storageException) {
            throw new RuntimeException(storageException);
        }
        if (arrayList == null) {
            CompilerReferenceReader.b(10);
        }
        return arrayList;
    }

    @NotNull
    TIntHashSet getAllContainingFileIds(@NotNull LightRef lightRef) throws StorageException {
        if (lightRef == null) {
            CompilerReferenceReader.b(11);
        }
        TIntHashSet tIntHashSet = InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.a.get(CompilerIndices.BACK_USAGES), Collections.singletonList(lightRef), null, null, null);
        if (tIntHashSet == null) {
            CompilerReferenceReader.b(12);
        }
        return tIntHashSet;
    }

    @NotNull
    NameEnumerator getNameEnumerator() {
        NameEnumerator nameEnumerator = this.a.getByteSeqEum();
        if (nameEnumerator == null) {
            CompilerReferenceReader.b(13);
        }
        return nameEnumerator;
    }

    void close(boolean bl2) {
        this.a.close();
        if (bl2) {
            CompilerBackwardReferenceIndex.removeIndexFiles((File)this.b);
        }
    }

    public CompilerBackwardReferenceIndex getIndex() {
        return this.a;
    }

    @NotNull
    OccurrenceCounter<LightRef> getTypeCastOperands(@NotNull LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef, final @Nullable TIntHashSet tIntHashSet) throws StorageException {
        if (lightClassHierarchyElementDef == null) {
            CompilerReferenceReader.b(14);
        }
        final OccurrenceCounter<LightRef> occurrenceCounter = new OccurrenceCounter<LightRef>();
        this.a.get(CompilerIndices.BACK_CAST).getData((Object)lightClassHierarchyElementDef).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Collection<LightRef>>(){

            public boolean perform(int n2, Collection<LightRef> collection) {
                if (tIntHashSet != null && !tIntHashSet.contains(n2)) {
                    return true;
                }
                for (LightRef lightRef : collection) {
                    occurrenceCounter.add(lightRef);
                }
                return true;
            }
        });
        OccurrenceCounter<LightRef> occurrenceCounter2 = occurrenceCounter;
        if (occurrenceCounter2 == null) {
            CompilerReferenceReader.b(15);
        }
        return occurrenceCounter2;
    }

    static boolean exists(Project project2) {
        File file = BuildManager.getInstance().getProjectSystemDirectory(project2);
        if (file == null || CompilerBackwardReferenceIndex.versionDiffers((File)file)) {
            return false;
        }
        return CompilerBackwardReferenceIndex.exist((File)file);
    }

    static CompilerReferenceReader create(Project project2) {
        if (!CompilerReferenceReader.exists(project2)) {
            return null;
        }
        try {
            return new CompilerReferenceReader(BuildManager.getInstance().getProjectSystemDirectory(project2));
        }
        catch (RuntimeException runtimeException) {
            c.error("An exception while initialization of compiler reference index.", (Throwable)runtimeException);
            return null;
        }
    }

    private void a(LightRef lightRef, final TIntHashSet tIntHashSet) throws StorageException {
        this.a.get(CompilerIndices.BACK_USAGES).getData((Object)lightRef).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Integer>(){

            public boolean perform(int n2, Integer n3) {
                VirtualFile virtualFile = CompilerReferenceReader.this.a(n2);
                if (virtualFile != null) {
                    tIntHashSet.add(((VirtualFileWithId)virtualFile).getId());
                }
                return true;
            }
        });
    }

    private VirtualFile a(int n2) {
        try {
            String string = this.a.getFilePathEnumerator().valueOf(n2);
            assert (string != null);
            return VfsUtil.findFileByIoFile((File)new File(string), (boolean)false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Nullable(value="return null if the class hierarchy contains ambiguous qualified names")
    LightRef.LightClassHierarchyElementDef[] getHierarchy(LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef, boolean bl2, boolean bl3, int n3) {
        try {
            THashSet tHashSet = new THashSet();
            Queue queue = new Queue(10);
            queue.addLast((Object)lightClassHierarchyElementDef);
            while (!queue.isEmpty()) {
                LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef2 = (LightRef.LightClassHierarchyElementDef)queue.pullFirst();
                if (n3 != -1 && tHashSet.size() > n3) break;
                if (!tHashSet.add(lightClassHierarchyElementDef2)) continue;
                if (tHashSet.size() % 100 == 0) {
                    ProgressManager.checkCanceled();
                }
                if (!(lightClassHierarchyElementDef2 instanceof LightRef.LightAnonymousClassDef) && (bl2 || lightClassHierarchyElementDef2 != lightClassHierarchyElementDef) && this.a((LightRef.NamedLightRef)lightClassHierarchyElementDef2)) {
                    return null;
                }
                this.a.get(CompilerIndices.BACK_HIERARCHY).getData((Object)lightClassHierarchyElementDef2).forEach((n2, collection) -> {
                    for (LightRef lightRef : collection) {
                        if (!(lightRef instanceof LightRef.LightClassHierarchyElementDef) || !bl3 && lightRef instanceof LightRef.LightAnonymousClassDef) continue;
                        queue.addLast((Object)((LightRef.LightClassHierarchyElementDef)lightRef));
                    }
                    return true;
                });
            }
            return tHashSet.toArray(LightRef.LightClassHierarchyElementDef.EMPTY_ARRAY);
        }
        catch (StorageException storageException) {
            throw new RuntimeException(storageException);
        }
    }

    @NotNull
    LightRef.LightClassHierarchyElementDef[] getDirectInheritors(LightRef.LightClassHierarchyElementDef lightClassHierarchyElementDef) throws StorageException {
        THashSet tHashSet = new THashSet();
        this.a.get(CompilerIndices.BACK_HIERARCHY).getData((Object)lightClassHierarchyElementDef).forEach((arg_0, arg_1) -> CompilerReferenceReader.a((Set)tHashSet, arg_0, arg_1));
        LightRef.LightClassHierarchyElementDef[] lightClassHierarchyElementDefArray = tHashSet.toArray(LightRef.LightClassHierarchyElementDef.EMPTY_ARRAY);
        if (lightClassHierarchyElementDefArray == null) {
            CompilerReferenceReader.b(16);
        }
        return lightClassHierarchyElementDefArray;
    }

    private boolean a(LightRef.NamedLightRef namedLightRef) throws StorageException {
        DefCount defCount = this.b(namedLightRef);
        if (defCount == DefCount.NONE) {
            String string = namedLightRef instanceof LightRef.LightAnonymousClassDef ? String.valueOf(namedLightRef.getName()) : this.getNameEnumerator().getName(namedLightRef.getName());
            c.error("Can't get definition files for: " + string + ", class: " + namedLightRef.getClass());
        }
        return defCount == DefCount.MANY;
    }

    @NotNull
    private DefCount b(LightRef.NamedLightRef namedLightRef) throws StorageException {
        final DefCount[] defCountArray = new DefCount[]{DefCount.NONE};
        this.a.get(CompilerIndices.BACK_CLASS_DEF).getData((Object)namedLightRef).forEach((ValueContainer.ContainerAction)new ValueContainer.ContainerAction<Void>(){

            public boolean perform(int n2, Void void_) {
                if (defCountArray[0] == DefCount.NONE) {
                    defCountArray[0] = DefCount.ONE;
                    return true;
                }
                if (defCountArray[0] == DefCount.ONE) {
                    defCountArray[0] = DefCount.MANY;
                    return true;
                }
                return false;
            }
        });
        DefCount defCount = defCountArray[0];
        if (defCount == null) {
            CompilerReferenceReader.b(17);
        }
        return defCount;
    }

    private static /* synthetic */ boolean a(Set set, int n2, Collection collection) {
        for (LightRef lightRef : collection) {
            if (!(lightRef instanceof LightRef.LightClassHierarchyElementDef) || lightRef instanceof LightRef.LightAnonymousClassDef) continue;
            set.add((LightRef.LightClassHierarchyElementDef)lightRef);
        }
        return true;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/CompilerReferenceReader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDef";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "castType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/CompilerReferenceReader";
                break;
            }
            case 6: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectInheritors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersFor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContainingFileIds";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameEnumerator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCastOperands";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionCount";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findReferentFileIds";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirectInheritors";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousCount";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMembersFor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAllContainingFileIds";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCastOperands";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDirectInheritors$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum DefCount {
        NONE,
        ONE,
        MANY;

    }
}

