/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerEncodingService;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class CompilerEncodingServiceImpl
extends CompilerEncodingService {
    @NotNull
    private final Project a;
    private final CachedValue<Map<Module, Set<Charset>>> b;

    public CompilerEncodingServiceImpl(@NotNull Project project2) {
        if (project2 == null) {
            CompilerEncodingServiceImpl.a(0);
        }
        this.a = project2;
        this.b = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
            Map<Module, Set<Charset>> map = this.a();
            return CachedValueProvider.Result.create(map, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.a), ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.a)).getModificationTracker()});
        }, false);
    }

    @NotNull
    private Map<Module, Set<Charset>> a() {
        LinkedHashSet<Charset> linkedHashSet;
        Object object;
        THashMap tHashMap = new THashMap();
        Map map = ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.a)).getAllMappings();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.a).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.a);
        for (Map.Entry entry : map.entrySet()) {
            Module module2;
            VirtualFile virtualFile = (VirtualFile)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            if (virtualFile == null || charset == null || !virtualFile.isDirectory() && !compilerManager.isCompilableFileType(virtualFile.getFileType()) || !projectFileIndex.isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.SOURCES) || (module2 = projectFileIndex.getModuleForFile(virtualFile)) == null) continue;
            LinkedHashSet<Charset> linkedHashSet2 = (LinkedHashSet<Charset>)tHashMap.get(module2);
            if (linkedHashSet2 == null) {
                linkedHashSet2 = new LinkedHashSet<Charset>();
                tHashMap.put(module2, linkedHashSet2);
                VirtualFile virtualFile2 = projectFileIndex.getSourceRootForFile(virtualFile);
                object = null;
                for (Module module3 = virtualFile.getParent(); module3 != null; module3 = module3.getParent()) {
                    linkedHashSet = (Charset)map.get(module3);
                    if (linkedHashSet != null) {
                        object = linkedHashSet;
                    }
                    if (module3.equals(virtualFile2)) break;
                }
                if (object != null) {
                    linkedHashSet2.add((Charset)object);
                }
            }
            linkedHashSet2.add(charset);
        }
        for (Module module4 : ModuleManager.getInstance((Project)this.a).getModules()) {
            for (Module module3 : ModuleRootManager.getInstance((Module)module4).getSourceRoots(true)) {
                object = EncodingProjectManager.getInstance((Project)this.a).getEncoding((VirtualFile)module3, true);
                if (object == null) continue;
                linkedHashSet = (LinkedHashSet<Charset>)tHashMap.get(module4);
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<Charset>();
                    tHashMap.put(module4, linkedHashSet);
                }
                linkedHashSet.add((Charset)object);
            }
        }
        THashMap tHashMap2 = tHashMap;
        if (tHashMap2 == null) {
            CompilerEncodingServiceImpl.a(1);
        }
        return tHashMap2;
    }

    @Nullable
    public Charset getPreferredModuleEncoding(@NotNull Module module2) {
        if (module2 == null) {
            CompilerEncodingServiceImpl.a(2);
        }
        Set set = (Set)((Map)this.b.getValue()).get(module2);
        return (Charset)ContainerUtil.getFirstItem((Collection)set, (Object)EncodingProjectManager.getInstance((Project)this.a).getDefaultCharset());
    }

    @NotNull
    public Collection<Charset> getAllModuleEncodings(@NotNull Module module2) {
        Set set;
        if (module2 == null) {
            CompilerEncodingServiceImpl.a(3);
        }
        if ((set = (Set)((Map)this.b.getValue()).get(module2)) != null) {
            Set set2 = set;
            if (set2 == null) {
                CompilerEncodingServiceImpl.a(4);
            }
            return set2;
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)EncodingProjectManager.getInstance((Project)this.a).getDefaultCharset());
        if (list2 == null) {
            CompilerEncodingServiceImpl.a(5);
        }
        return list2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/CompilerEncodingServiceImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/CompilerEncodingServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeModuleCharsetMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModuleEncodings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredModuleEncoding";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllModuleEncodings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

