/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressForClassFix;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompilerPropertiesAction;
import com.intellij.compiler.impl.ExcludeFromCompileAction;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CompilerErrorTreeView
extends NewErrorTreeViewPanel {
    public CompilerErrorTreeView(Project project2, Runnable runnable) {
        super(project2, null, true, true, runnable);
    }

    protected void fillRightToolbarGroup(DefaultActionGroup defaultActionGroup) {
        super.fillRightToolbarGroup(defaultActionGroup);
        defaultActionGroup.add((AnAction)new CompilerPropertiesAction());
    }

    protected void addExtraPopupMenuActions(DefaultActionGroup defaultActionGroup) {
        defaultActionGroup.add((AnAction)new ExcludeFromCompileAction(this.myProject, this));
        defaultActionGroup.addSeparator();
        defaultActionGroup.add((AnAction)new SuppressJavacWarningsAction());
        defaultActionGroup.add((AnAction)new SuppressJavacWarningForClassAction());
        defaultActionGroup.addSeparator();
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("CompilerErrorViewPopupMenu");
        if (actionGroup != null) {
            for (AnAction anAction : actionGroup.getChildren(null)) {
                defaultActionGroup.add(anAction);
            }
        }
    }

    protected boolean shouldShowFirstErrorInEditor() {
        return CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).AUTO_SHOW_ERRORS_IN_EDITOR;
    }

    private class SuppressJavacWarningForClassAction
    extends SuppressJavacWarningsAction {
        private SuppressJavacWarningForClassAction() {
        }

        @Override
        protected SuppressFix getSuppressAction(@NotNull String string) {
            if (string == null) {
                SuppressJavacWarningForClassAction.b(0);
            }
            return new SuppressForClassFix(string){

                protected boolean use15Suppressions(@NotNull PsiJavaDocumentedElement psiJavaDocumentedElement) {
                    if (psiJavaDocumentedElement == null) {
                        1.a(0);
                    }
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningForClassAction$1", "use15Suppressions"));
                }
            };
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningForClassAction", "getSuppressAction"));
        }
    }

    private class SuppressJavacWarningsAction
    extends AnAction {
        private SuppressJavacWarningsAction() {
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            NavigatableMessageElement navigatableMessageElement = (NavigatableMessageElement)CompilerErrorTreeView.this.getSelectedErrorTreeElement();
            String[] stringArray = navigatableMessageElement.getText();
            String string = stringArray[0].substring(1, stringArray[0].indexOf("]"));
            SuppressFix suppressFix = this.getSuppressAction(string);
            Project project2 = anActionEvent.getProject();
            assert (project2 != null);
            OpenFileDescriptor openFileDescriptor = (OpenFileDescriptor)navigatableMessageElement.getNavigatable();
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(openFileDescriptor.getFile());
            assert (psiFile != null);
            CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    suppressFix.invoke(project2, psiFile.findElementAt(openFileDescriptor.getOffset()));
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    LOG.error((Throwable)incorrectOperationException);
                }
            }), suppressFix.getText(), null);
        }

        public void update(AnActionEvent anActionEvent) {
            Navigatable navigatable;
            NavigatableMessageElement navigatableMessageElement;
            String[] stringArray;
            Presentation presentation = anActionEvent.getPresentation();
            presentation.setVisible(false);
            presentation.setEnabled(false);
            Project project2 = anActionEvent.getProject();
            if (project2 == null) {
                return;
            }
            ErrorTreeElement errorTreeElement = CompilerErrorTreeView.this.getSelectedErrorTreeElement();
            if (errorTreeElement instanceof NavigatableMessageElement && (stringArray = (navigatableMessageElement = (NavigatableMessageElement)errorTreeElement).getText()).length > 0 && stringArray[0].startsWith("[") && stringArray[0].indexOf("]") != -1 && (navigatable = navigatableMessageElement.getNavigatable()) instanceof OpenFileDescriptor) {
                OpenFileDescriptor openFileDescriptor = (OpenFileDescriptor)navigatable;
                VirtualFile virtualFile = openFileDescriptor.getFile();
                Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project2);
                if (module2 == null) {
                    return;
                }
                Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                if (sdk == null) {
                    return;
                }
                boolean bl2 = JavaSdk.getInstance().isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_1_5);
                if (!bl2) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                if (psiFile == null) {
                    return;
                }
                if (LanguageLevelUtil.getEffectiveLanguageLevel((Module)module2).compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
                    return;
                }
                PsiElement psiElement = psiFile.findElementAt(openFileDescriptor.getOffset());
                if (psiElement == null) {
                    return;
                }
                String string = stringArray[0].substring(1, stringArray[0].indexOf("]"));
                SuppressFix suppressFix = this.getSuppressAction(string);
                boolean bl3 = suppressFix.isAvailable(project2, psiElement);
                presentation.setEnabled(bl3);
                presentation.setVisible(bl3);
                if (bl3) {
                    presentation.setText(suppressFix.getText());
                }
            }
        }

        protected SuppressFix getSuppressAction(@NotNull String string) {
            if (string == null) {
                SuppressJavacWarningsAction.a(0);
            }
            return new SuppressFix(string){

                public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement psiElement) {
                    if (project2 == null) {
                        1.a(0);
                    }
                    if (psiElement == null) {
                        1.a(1);
                    }
                    if (this.getContainer(psiElement) instanceof PsiClass) {
                        return false;
                    }
                    return super.isAvailable(project2, psiElement);
                }

                protected boolean use15Suppressions(@NotNull PsiJavaDocumentedElement psiJavaDocumentedElement) {
                    if (psiJavaDocumentedElement == null) {
                        1.a(2);
                    }
                    return true;
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "container";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningsAction$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "use15Suppressions";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/compiler/impl/CompilerErrorTreeView$SuppressJavacWarningsAction", "getSuppressAction"));
        }
    }
}

