/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ExitException;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.generic.GenericCompilerCache;
import com.intellij.compiler.impl.generic.GenericCompilerPersistentData;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.generic.BuildTarget;
import com.intellij.openapi.compiler.generic.CompileItem;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.compiler.generic.GenericCompilerCacheState;
import com.intellij.openapi.compiler.generic.GenericCompilerInstance;
import com.intellij.openapi.compiler.generic.GenericCompilerProcessingItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.CommonProcessors;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GenericCompilerRunner {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.compiler.impl.GenericCompilerRunner");
    private static final Logger d = Logger.getInstance((String)"#com.intellij.full-generic-compiler-log");
    private final CompileContext g;
    private final boolean a;
    private final boolean f;
    private final GenericCompiler<?, ?, ?>[] e;
    private final Project c;

    public GenericCompilerRunner(CompileContext compileContext, boolean bl2, boolean bl3, GenericCompiler[] genericCompilerArray) {
        this.g = compileContext;
        this.a = bl2;
        this.f = bl3;
        this.e = genericCompilerArray;
        this.c = this.g.getProject();
    }

    public boolean invokeCompilers(GenericCompiler.CompileOrderPlace compileOrderPlace) throws ExitException {
        boolean bl2 = false;
        try {
            for (GenericCompiler<?, ?, ?> genericCompiler : this.e) {
                if (!genericCompiler.getOrderPlace().equals((Object)compileOrderPlace)) continue;
                bl2 |= this.a(genericCompiler);
            }
        }
        catch (IOException iOException) {
            b.info((Throwable)iOException);
            this.g.requestRebuildNextTime(iOException.getMessage());
            throw new ExitException(ExitStatus.ERRORS);
        }
        catch (ExitException | ProcessCanceledException throwable) {
            throw throwable;
        }
        catch (Exception exception) {
            b.info((Throwable)exception);
            this.g.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.exception", (Object[])new Object[]{exception.getMessage()}), null, -1, -1);
        }
        return bl2;
    }

    private <Key, SourceState, OutputState> boolean a(GenericCompiler<Key, SourceState, OutputState> genericCompiler) throws IOException, ExitException {
        return this.a(genericCompiler, genericCompiler.createInstance(this.g));
    }

    private <T extends BuildTarget, Item extends CompileItem<Key, SourceState, OutputState>, Key, SourceState, OutputState> boolean a(GenericCompiler<Key, SourceState, OutputState> genericCompiler, GenericCompilerInstance<T, Item, Key, SourceState, OutputState> genericCompilerInstance) throws IOException, ExitException {
        Object object;
        GenericCompilerCache genericCompilerCache = CompilerCacheManager.getInstance(this.c).getGenericCompilerCache(genericCompiler);
        GenericCompilerPersistentData genericCompilerPersistentData = new GenericCompilerPersistentData(GenericCompilerRunner.getGenericCompilerCacheDir(this.c, genericCompiler), genericCompiler.getVersion());
        if (genericCompilerPersistentData.isVersionChanged()) {
            b.info("Clearing cache for " + genericCompiler.getDescription());
            genericCompilerCache.wipe();
            genericCompilerPersistentData.save();
        }
        HashSet<String> hashSet = new HashSet<String>(genericCompilerPersistentData.getAllTargets());
        ReadAction.run(() -> {
            for (BuildTarget buildTarget : genericCompilerInstance.getAllTargets()) {
                hashSet.remove(buildTarget.getId());
            }
        });
        if (!this.f) {
            for (String string : hashSet) {
                int n2 = genericCompilerPersistentData.removeId(string);
                if (b.isDebugEnabled()) {
                    b.debug("Removing obsolete target '" + string + "' (id=" + n2 + ")");
                }
                object = new ArrayList();
                CompilerUtil.runInContext(this.g, "Processing obsolete targets...", () -> GenericCompilerRunner.a(genericCompilerCache, n2, (List)object, genericCompilerInstance, string));
                this.a();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    genericCompilerCache.remove(n2, e2);
                }
            }
        }
        List list2 = (List)ReadAction.compute(() -> genericCompilerInstance.getSelectedTargets());
        boolean bl2 = false;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (BuildTarget)iterator.next();
            int n3 = genericCompilerPersistentData.getId(((BuildTarget)object).getId());
            bl2 |= this.a(object, n3, genericCompiler, genericCompilerInstance, genericCompilerCache);
        }
        genericCompilerPersistentData.save();
        return bl2;
    }

    private void a() throws ExitException {
        if (this.g.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
            throw new ExitException(ExitStatus.ERRORS);
        }
        if (this.g.getProgressIndicator().isCanceled()) {
            throw new ExitException(ExitStatus.CANCELLED);
        }
    }

    public static File getGenericCompilerCacheDir(Project project2, GenericCompiler<?, ?, ?> genericCompiler) {
        return new File(CompilerPaths.getCacheStoreDirectory((Project)project2), genericCompiler.getId());
    }

    private <T extends BuildTarget, Item extends CompileItem<Key, SourceState, OutputState>, Key, SourceState, OutputState> boolean a(T t2, int n2, GenericCompiler<Key, SourceState, OutputState> genericCompiler, GenericCompilerInstance<T, Item, Key, SourceState, OutputState> genericCompilerInstance, GenericCompilerCache<Key, SourceState, OutputState> genericCompilerCache) throws IOException, ExitException {
        Object object2;
        Object object32;
        if (b.isDebugEnabled()) {
            b.debug("Processing target '" + t2 + "' (id=" + n2 + ") by " + genericCompiler);
        }
        List list2 = genericCompilerInstance.getItems(t2);
        this.a();
        ArrayList arrayList = new ArrayList();
        THashSet tHashSet = new THashSet(new SourceItemHashingStrategy<Key>(genericCompiler));
        Ref ref = Ref.create(null);
        HashMap hashMap = new HashMap();
        DumbService.getInstance((Project)this.c).runReadActionInSmartMode(() -> {
            try {
                for (CompileItem compileItem : list2) {
                    Object OutputState;
                    Object Key2 = compileItem.getKey();
                    tHashSet.add(Key2);
                    if (compileItem.isExcluded()) continue;
                    GenericCompilerCache.PersistentStateData persistentStateData = genericCompilerCache.getState(n2, Key2);
                    Object SourceState = persistentStateData != null ? (Object)persistentStateData.mySourceState : null;
                    Object OutputState2 = OutputState = persistentStateData != null ? (Object)persistentStateData.myOutputState : null;
                    if (!this.a && SourceState != null && compileItem.isSourceUpToDate(SourceState) && OutputState != null && compileItem.isOutputUpToDate(OutputState)) continue;
                    hashMap.put(compileItem, compileItem.computeSourceState());
                    arrayList.add(new GenericCompilerProcessingItem<CompileItem, Object, Object>(compileItem, SourceState, OutputState));
                }
            }
            catch (IOException iOException) {
                ref.set((Object)iOException);
            }
        });
        if (!ref.isNull()) {
            throw (IOException)ref.get();
        }
        ArrayList arrayList2 = new ArrayList();
        genericCompilerCache.processSources(n2, object -> {
            if (!tHashSet.contains(object)) {
                arrayList2.add(object);
            }
            return true;
        });
        if (b.isDebugEnabled()) {
            int n3;
            b.debug(arrayList.size() + " items will be processed, " + arrayList2.size() + " items will be removed");
            for (n3 = 0; n3 < GenericCompilerRunner.a(arrayList.size()); ++n3) {
                b.debug("to process:" + ((CompileItem)((GenericCompilerProcessingItem)arrayList.get(n3)).getItem()).getKey());
            }
            for (n3 = 0; n3 < GenericCompilerRunner.a(arrayList2.size()); ++n3) {
                b.debug("to delete:" + arrayList2.get(n3));
            }
        }
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            return false;
        }
        if (this.f) {
            throw new ExitException(ExitStatus.CANCELLED);
        }
        ArrayList arrayList3 = new ArrayList();
        for (Object object32 : arrayList2) {
            object2 = genericCompilerCache.getState(n2, object32);
            arrayList3.add(new GenericCompilerCacheState(object32, ((GenericCompilerCache.PersistentStateData)object2).mySourceState, ((GenericCompilerCache.PersistentStateData)object2).myOutputState));
        }
        ArrayList arrayList4 = new ArrayList();
        object32 = new ArrayList();
        object2 = new ArrayList();
        genericCompilerInstance.processItems(t2, arrayList, arrayList3, new GenericCompilerInstance.OutputConsumer<Item>((List)object32, (List)object2, arrayList4){
            final /* synthetic */ List val$filesToRefresh;
            final /* synthetic */ List val$dirsToRefresh;
            final /* synthetic */ List val$processedItems;
            {
                this.val$filesToRefresh = list2;
                this.val$dirsToRefresh = list3;
                this.val$processedItems = list4;
            }

            @Override
            public void addFileToRefresh(@NotNull File file) {
                if (file == null) {
                    1.a(0);
                }
                this.val$filesToRefresh.add(file);
            }

            @Override
            public void addDirectoryToRefresh(@NotNull File file) {
                if (file == null) {
                    1.a(1);
                }
                this.val$dirsToRefresh.add(file);
            }

            @Override
            public void addProcessedItem(@NotNull Item Item2) {
                if (Item2 == null) {
                    1.a(2);
                }
                this.val$processedItems.add(Item2);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dir";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceItem";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/compiler/impl/GenericCompilerRunner$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addFileToRefresh";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addDirectoryToRefresh";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addProcessedItem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.a();
        CompilerUtil.runInContext(this.g, CompilerBundle.message((String)"progress.updating.caches", (Object[])new Object[0]), () -> this.a(arrayList2, genericCompilerCache, n2, object32, (List)object2, arrayList4, hashMap));
        return true;
    }

    private static int a(int n2) {
        if (n2 > 100 && !d.isDebugEnabled()) {
            return 100;
        }
        return n2;
    }

    private /* synthetic */ void a(List list2, final GenericCompilerCache genericCompilerCache, final int n2, List list3, List list4, final List list5, final Map map) throws IOException {
        Object object;
        RunResult runResult = list2.iterator();
        while (runResult.hasNext()) {
            object = runResult.next();
            genericCompilerCache.remove(n2, object);
        }
        CompilerUtil.refreshIOFiles(list3);
        CompilerUtil.refreshIODirectories(list4);
        if (b.isDebugEnabled()) {
            int n3;
            b.debug("refreshed " + list3.size() + " files and " + list4.size() + " dirs");
            for (n3 = 0; n3 < GenericCompilerRunner.a(list3.size()); ++n3) {
                b.debug("file: " + list3.get(n3));
            }
            for (n3 = 0; n3 < GenericCompilerRunner.a(list4.size()); ++n3) {
                b.debug("dir: " + list4.get(n3));
            }
        }
        if ((object = (runResult = new ReadAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    2.a(0);
                }
                for (CompileItem compileItem : list5) {
                    Object object = map.get(compileItem);
                    if (object == null) {
                        object = compileItem.computeSourceState();
                    }
                    genericCompilerCache.putState(n2, compileItem.getKey(), object, compileItem.computeOutputState());
                }
            }

            private static /* synthetic */ void a(int n22) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/impl/GenericCompilerRunner$2", "run"));
            }
        }.executeSilently()).getThrowable()) instanceof IOException) {
            throw (IOException)object;
        }
        if (object != null) {
            throw new RuntimeException((Throwable)object);
        }
    }

    private static /* synthetic */ void a(GenericCompilerCache genericCompilerCache, int n2, List list2, GenericCompilerInstance genericCompilerInstance, String string) throws IOException {
        genericCompilerCache.processSources(n2, new CommonProcessors.CollectProcessor((Collection)list2));
        ArrayList arrayList = new ArrayList();
        for (Object e2 : list2) {
            GenericCompilerCache.PersistentStateData persistentStateData = genericCompilerCache.getState(n2, e2);
            arrayList.add(new GenericCompilerCacheState(e2, persistentStateData.mySourceState, persistentStateData.myOutputState));
        }
        genericCompilerInstance.processObsoleteTarget(string, arrayList);
    }

    private class SourceItemHashingStrategy<S>
    implements TObjectHashingStrategy<S> {
        private final KeyDescriptor<S> a;

        public SourceItemHashingStrategy(GenericCompiler<S, ?, ?> genericCompiler) {
            this.a = genericCompiler.getItemKeyDescriptor();
        }

        public int computeHashCode(S s2) {
            return this.a.getHashCode(s2);
        }

        public boolean equals(S s2, S s3) {
            return this.a.isEqual(s2, s3);
        }
    }
}

