/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.PlaceInDocument;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Nullable;

public class ToggleMethodBreakpointAction
extends AnAction {
    public void update(AnActionEvent anActionEvent) {
        boolean bl2;
        boolean bl3 = bl2 = ToggleMethodBreakpointAction.a(anActionEvent) != null;
        if (ActionPlaces.isPopupPlace((String)anActionEvent.getPlace())) {
            anActionEvent.getPresentation().setVisible(bl2);
        } else {
            anActionEvent.getPresentation().setEnabled(bl2);
        }
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx(project2);
        if (debuggerManagerEx == null) {
            return;
        }
        BreakpointManager breakpointManager = debuggerManagerEx.getBreakpointManager();
        PlaceInDocument placeInDocument = ToggleMethodBreakpointAction.a(anActionEvent);
        if (placeInDocument != null && DocumentUtil.isValidOffset((int)placeInDocument.getOffset(), (Document)placeInDocument.getDocument())) {
            MethodBreakpoint methodBreakpoint = breakpointManager.findBreakpoint(placeInDocument.getDocument(), placeInDocument.getOffset(), MethodBreakpoint.CATEGORY);
            if (methodBreakpoint == null) {
                breakpointManager.addMethodBreakpoint(placeInDocument.getDocument(), placeInDocument.getDocument().getLineNumber(placeInDocument.getOffset()));
            } else {
                breakpointManager.removeBreakpoint(methodBreakpoint);
            }
        }
    }

    @Nullable
    private static PlaceInDocument a(AnActionEvent anActionEvent) {
        Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return null;
        }
        PsiElement psiElement = null;
        Document document = null;
        if ("ProjectViewPopup".equals(anActionEvent.getPlace()) || "StructureViewPopup".equals(anActionEvent.getPlace()) || "FavoritesPopup".equals(anActionEvent.getPlace()) || "NavBar".equals(anActionEvent.getPlace())) {
            PsiFile psiFile;
            PsiElement psiElement2 = (PsiElement)anActionEvent.getData(CommonDataKeys.PSI_ELEMENT);
            if (psiElement2 instanceof PsiMethod && (psiFile = psiElement2.getContainingFile()) != null) {
                psiElement = psiElement2;
                document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
            }
        } else {
            Editor editor = (Editor)anActionEvent.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
            }
            if (editor != null) {
                document = editor.getDocument();
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
                if (psiFile != null) {
                    FileType fileType;
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    FileType fileType2 = fileType = virtualFile != null ? virtualFile.getFileType() : null;
                    if (StdFileTypes.JAVA == fileType || StdFileTypes.CLASS == fileType) {
                        psiElement = ToggleMethodBreakpointAction.a(project2, editor);
                    }
                }
            }
        }
        return psiElement != null ? new PlaceInDocument(document, psiElement.getTextOffset()) : null;
    }

    @Nullable
    private static PsiMethod a(Project project2, Editor editor) {
        if (editor == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        int n2 = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)editor.getCaretModel().getOffset(), (String)" \t");
        return DebuggerUtilsEx.findPsiMethod(psiFile, n2);
    }
}

