/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicStepMethodFilter
implements NamedMethodFilter {
    private static final Logger c = Logger.getInstance(BasicStepMethodFilter.class);
    @NotNull
    protected final JVMName myDeclaringClassName;
    @NotNull
    private final String a;
    @Nullable
    protected final JVMName myTargetMethodSignature;
    private final Range<Integer> b;

    public BasicStepMethodFilter(@NotNull PsiMethod psiMethod, Range<Integer> range) {
        if (psiMethod == null) {
            BasicStepMethodFilter.b(0);
        }
        this(JVMNameUtil.getJVMQualifiedName(psiMethod.getContainingClass()), JVMNameUtil.getJVMMethodName(psiMethod), JVMNameUtil.getJVMSignature(psiMethod), range);
    }

    protected BasicStepMethodFilter(@NotNull JVMName jVMName, @NotNull String string, @Nullable JVMName jVMName2, Range<Integer> range) {
        if (jVMName == null) {
            BasicStepMethodFilter.b(1);
        }
        if (string == null) {
            BasicStepMethodFilter.b(2);
        }
        this.myDeclaringClassName = jVMName;
        this.a = string;
        this.myTargetMethodSignature = jVMName2;
        this.b = range;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.a;
        if (string == null) {
            BasicStepMethodFilter.b(3);
        }
        return string;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl debugProcessImpl, Location location) throws EvaluateException {
        return this.locationMatches(debugProcessImpl, location, () -> null);
    }

    @Override
    public boolean locationMatches(DebugProcessImpl debugProcessImpl, Location location, @NotNull EvaluatingComputable<ObjectReference> evaluatingComputable) throws EvaluateException {
        ObjectReference objectReference;
        Method method;
        String string;
        if (evaluatingComputable == null) {
            BasicStepMethodFilter.b(4);
        }
        if (!this.a.equals(string = (method = location.method()).name())) {
            if (DebuggerUtilsEx.isLambdaName(string)) {
                SourcePosition sourcePosition = debugProcessImpl.getPositionManager().getSourcePosition(location);
                return (Boolean)ReadAction.compute(() -> {
                    PsiElement psiElement = DebuggerUtilsEx.getContainingMethod(sourcePosition);
                    if (psiElement instanceof PsiLambdaExpression) {
                        PsiType psiType = ((PsiLambdaExpression)psiElement).getFunctionalInterfaceType();
                        PsiMethod psiMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)psiType);
                        if (psiType != null && psiMethod != null && this.a.equals(psiMethod.getName())) {
                            try {
                                return InheritanceUtil.isInheritor((PsiType)psiType, (String)this.myDeclaringClassName.getName(debugProcessImpl).replace('$', '.'));
                            }
                            catch (EvaluateException evaluateException) {
                                c.info((Throwable)evaluateException);
                            }
                        }
                    }
                    return false;
                });
            }
            return false;
        }
        if (this.myTargetMethodSignature != null && !BasicStepMethodFilter.a(method, this.myTargetMethodSignature.getName(debugProcessImpl))) {
            return false;
        }
        if (method.isBridge()) {
            return false;
        }
        String string2 = this.myDeclaringClassName.getName(debugProcessImpl);
        boolean bl2 = DebuggerUtilsEx.isAssignableFrom(string2, location.declaringType());
        if (!bl2 && !method.isStatic() && (objectReference = evaluatingComputable.compute()) != null) {
            bl2 = DebuggerUtilsEx.isAssignableFrom(string2, objectReference.referenceType());
        }
        return bl2;
    }

    private static boolean a(Method method, String string) throws EvaluateException {
        if (string.equals(method.signature())) {
            return true;
        }
        for (Method method2 : method.declaringType().methodsByName(method.name())) {
            if (method2 == method || !method2.isBridge() || !string.equals(method2.signature())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.b;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/BasicStepMethodFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/BasicStepMethodFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "locationMatches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

