/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSourcePositionProvider
extends SourcePositionProvider {
    @Override
    @Nullable
    protected SourcePosition computeSourcePosition(@NotNull NodeDescriptor nodeDescriptor, @NotNull Project project2, @NotNull DebuggerContextImpl debuggerContextImpl, boolean bl2) {
        DebugProcessImpl debugProcessImpl;
        StackFrameProxyImpl stackFrameProxyImpl;
        if (nodeDescriptor == null) {
            DefaultSourcePositionProvider.b(0);
        }
        if (project2 == null) {
            DefaultSourcePositionProvider.b(1);
        }
        if (debuggerContextImpl == null) {
            DefaultSourcePositionProvider.b(2);
        }
        if ((stackFrameProxyImpl = debuggerContextImpl.getFrameProxy()) == null) {
            return null;
        }
        if (nodeDescriptor instanceof FieldDescriptor) {
            return DefaultSourcePositionProvider.a((FieldDescriptor)nodeDescriptor, project2, debuggerContextImpl, bl2);
        }
        if (nodeDescriptor instanceof LocalVariableDescriptor) {
            return DefaultSourcePositionProvider.a(nodeDescriptor.getName(), project2, debuggerContextImpl, bl2);
        }
        if (nodeDescriptor instanceof ArgumentValueDescriptorImpl) {
            Collection<String> collection = ((ArgumentValueDescriptorImpl)nodeDescriptor).getVariable().getMatchedNames();
            if (!collection.isEmpty()) {
                return DefaultSourcePositionProvider.a(collection.iterator().next(), project2, debuggerContextImpl, bl2);
            }
        } else if (nodeDescriptor instanceof MethodReturnValueDescriptorImpl && (debugProcessImpl = debuggerContextImpl.getDebugProcess()) != null) {
            return debugProcessImpl.getPositionManager().getSourcePosition(((MethodReturnValueDescriptorImpl)nodeDescriptor).getMethod().location());
        }
        return null;
    }

    @Nullable
    private static SourcePosition a(@NotNull FieldDescriptor fieldDescriptor, @NotNull Project project2, @NotNull DebuggerContextImpl debuggerContextImpl, boolean bl2) {
        Object object;
        if (fieldDescriptor == null) {
            DefaultSourcePositionProvider.b(3);
        }
        if (project2 == null) {
            DefaultSourcePositionProvider.b(4);
        }
        if (debuggerContextImpl == null) {
            DefaultSourcePositionProvider.b(5);
        }
        ReferenceType referenceType = fieldDescriptor.getField().declaringType();
        String string = fieldDescriptor.getField().name();
        if (string.startsWith("val$")) {
            String string2 = string.substring(string.lastIndexOf(36) + 1);
            PsiElement psiElement = PositionUtil.getContextElement((StackFrameContext)debuggerContextImpl);
            if (psiElement == null) {
                return null;
            }
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
            if (psiClass == null) {
                return null;
            }
            PsiElement psiElement2 = psiClass.getNavigationElement();
            if (!(psiElement2 instanceof PsiClass)) {
                return null;
            }
            psiClass = (PsiClass)psiElement2;
            PsiVariable psiVariable = JavaPsiFacade.getInstance((Project)project2).getResolveHelper().resolveReferencedVariable(string2, (PsiElement)psiClass);
            if (psiVariable == null) {
                return null;
            }
            if (bl2) {
                return DebuggerContextUtil.findNearest(debuggerContextImpl, (PsiElement)psiVariable, psiClass.getContainingFile());
            }
            return SourcePosition.createFromElement((PsiElement)psiVariable);
        }
        PsiClass psiClass = null;
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        if (debugProcessImpl != null) {
            try {
                object = referenceType.allLineLocations();
                if (!object.isEmpty()) {
                    psiClass = JVMNameUtil.getClassAt(debugProcessImpl.getPositionManager().getSourcePosition((Location)ContainerUtil.getLastItem((List)object)));
                }
            }
            catch (AbsentInformationException | ClassNotPreparedException exception) {
                // empty catch block
            }
        }
        if (psiClass == null) {
            object = debuggerContextImpl.getDebuggerSession();
            GlobalSearchScope globalSearchScope = object != null ? ((DebuggerSession)object).getSearchScope() : GlobalSearchScope.allScope((Project)project2);
            psiClass = DebuggerUtils.findClass((String)referenceType.name(), (Project)project2, (GlobalSearchScope)globalSearchScope);
        }
        if (psiClass != null) {
            object = psiClass.findFieldByName(string, false);
            if (object == null) {
                return null;
            }
            if (bl2) {
                return DebuggerContextUtil.findNearest(debuggerContextImpl, object.getNavigationElement(), psiClass.getContainingFile());
            }
            return SourcePosition.createFromElement((PsiElement)object);
        }
        return null;
    }

    @Nullable
    private static SourcePosition a(String string, @NotNull Project project2, @NotNull DebuggerContextImpl debuggerContextImpl, boolean bl2) {
        PsiElement psiElement;
        if (project2 == null) {
            DefaultSourcePositionProvider.b(6);
        }
        if (debuggerContextImpl == null) {
            DefaultSourcePositionProvider.b(7);
        }
        if ((psiElement = PositionUtil.getContextElement((StackFrameContext)debuggerContextImpl)) == null) {
            return null;
        }
        PsiVariable psiVariable = JavaPsiFacade.getInstance((Project)project2).getResolveHelper().resolveReferencedVariable(string, psiElement);
        if (psiVariable == null) {
            return null;
        }
        PsiFile psiFile = psiVariable.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        try {
            if (bl2) {
                return DebuggerContextUtil.findNearest(debuggerContextImpl, (PsiElement)psiVariable, psiFile);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return SourcePosition.createFromElement((PsiElement)psiVariable);
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/DefaultSourcePositionProvider";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeSourcePosition";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourcePositionForField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourcePositionForLocalVariable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

