/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FrameExtraVariablesProvider;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaDebuggerEvaluator;
import com.intellij.debugger.engine.JavaFramesListRenderer;
import com.intellij.debugger.engine.JavaStaticGroup;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStackFrame
extends XStackFrame
implements JVMStackFrameInfoProvider {
    private static final Logger d = Logger.getInstance(JavaStackFrame.class);
    public static final DummyMessageValueNode LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE = new DummyMessageValueNode(MessageDescriptor.LOCAL_VARIABLES_INFO_UNAVAILABLE.getLabel(), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
    private final DebugProcessImpl h;
    @Nullable
    private final XSourcePosition g;
    private final NodeManagerImpl f;
    @NotNull
    private final StackFrameDescriptorImpl c;
    private JavaDebuggerEvaluator e;
    private final String i;
    private CapturePoint a;
    private static final Pair<Set<String>, Set<TextWithImports>> b = Pair.create(Collections.emptySet(), Collections.emptySet());

    public JavaStackFrame(@NotNull StackFrameDescriptorImpl stackFrameDescriptorImpl, boolean bl2) {
        if (stackFrameDescriptorImpl == null) {
            JavaStackFrame.a(0);
        }
        this.e = null;
        this.c = stackFrameDescriptorImpl;
        if (bl2) {
            this.c.setContext(null);
            this.c.updateRepresentation(null, DescriptorLabelListener.DUMMY_LISTENER);
        }
        this.i = bl2 ? NodeManagerImpl.getContextKeyForFrame(this.c.getFrameProxy()) : null;
        this.h = (DebugProcessImpl)stackFrameDescriptorImpl.getDebugProcess();
        this.f = this.h.getXdebugProcess().getNodeManager();
        this.g = DebuggerUtilsEx.toXSourcePosition(this.c.getSourcePosition());
    }

    @NotNull
    public StackFrameDescriptorImpl getDescriptor() {
        StackFrameDescriptorImpl stackFrameDescriptorImpl = this.c;
        if (stackFrameDescriptorImpl == null) {
            JavaStackFrame.a(1);
        }
        return stackFrameDescriptorImpl;
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        if (this.e == null) {
            this.e = new JavaDebuggerEvaluator(this.h, this);
        }
        return this.e;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.g;
    }

    public void customizePresentation(@NotNull ColoredTextContainer coloredTextContainer) {
        XStackFrame xStackFrame;
        XDebugSession xDebugSession;
        if (coloredTextContainer == null) {
            JavaStackFrame.a(2);
        }
        StackFrameDescriptorImpl stackFrameDescriptorImpl = null;
        DebuggerSession debuggerSession = this.h.getSession();
        if (debuggerSession != null && (xDebugSession = debuggerSession.getXDebugSession()) != null && (xStackFrame = xDebugSession.getCurrentStackFrame()) instanceof JavaStackFrame) {
            stackFrameDescriptorImpl = ((JavaStackFrame)xStackFrame).getDescriptor();
        }
        JavaFramesListRenderer.customizePresentation(this.c, coloredTextContainer, stackFrameDescriptorImpl);
        if (this.a != null) {
            coloredTextContainer.setIcon(XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
        }
    }

    public void computeChildren(final @NotNull XCompositeNode xCompositeNode) {
        if (xCompositeNode == null) {
            JavaStackFrame.a(3);
        }
        if (xCompositeNode.isObsolete()) {
            return;
        }
        this.h.getManagerThread().schedule(new DebuggerContextCommandImpl(this.h.getDebuggerContext(), this.c.getFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                if (suspendContextImpl == null) {
                    1.c(0);
                }
                if (xCompositeNode.isObsolete()) {
                    return;
                }
                if (JavaStackFrame.this.a != null) {
                    xCompositeNode.setMessage("Async stacktrace from " + ((JavaStackFrame)JavaStackFrame.this).a.myClassName + "." + ((JavaStackFrame)JavaStackFrame.this).a.myMethodName + " could be available here, enable in", XDebuggerUIConstants.INFORMATION_MESSAGE_ICON, SimpleTextAttributes.REGULAR_ATTRIBUTES, StackFrameItem.CAPTURE_SETTINGS_OPENER);
                }
                XValueChildrenList xValueChildrenList = new XValueChildrenList();
                JavaStackFrame.this.a(JavaStackFrame.this.getFrameDebuggerContext(this.getDebuggerContext()), xValueChildrenList, xCompositeNode);
                xCompositeNode.addChildren(xValueChildrenList, true);
            }

            private static /* synthetic */ void c(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaStackFrame$1", "threadAction"));
            }
        });
    }

    DebuggerContextImpl getFrameDebuggerContext(@Nullable DebuggerContextImpl debuggerContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (debuggerContextImpl == null) {
            debuggerContextImpl = this.h.getDebuggerContext();
        }
        if (debuggerContextImpl.getFrameProxy() != this.getStackFrameProxy()) {
            SuspendContextImpl suspendContextImpl = SuspendManagerUtil.findContextByThread(this.h.getSuspendManager(), this.getStackFrameProxy().threadProxy());
            debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(this.h.mySession, suspendContextImpl, this.getStackFrameProxy().threadProxy(), this.getStackFrameProxy());
            debuggerContextImpl.setPositionCache(this.c.getSourcePosition());
            debuggerContextImpl.initCaches();
        }
        return debuggerContextImpl;
    }

    private void a(DebuggerContextImpl debuggerContextImpl, XValueChildrenList xValueChildrenList, XCompositeNode xCompositeNode) {
        try {
            Object object;
            Object object2;
            EvaluationContextImpl evaluationContextImpl = debuggerContextImpl.createEvaluationContext();
            if (evaluationContextImpl == null) {
                return;
            }
            if (!debuggerContextImpl.isEvaluationPossible()) {
                xCompositeNode.setErrorMessage(MessageDescriptor.EVALUATION_NOT_POSSIBLE.getLabel());
            }
            Location location = this.c.getLocation();
            ObjectReference objectReference2 = this.c.getThisObject();
            if (objectReference2 != null) {
                object2 = this.f.getThisDescriptor(null, objectReference2);
                xValueChildrenList.add((XNamedValue)JavaValue.create((ValueDescriptorImpl)object2, evaluationContextImpl, this.f));
            } else if (location != null && ((StaticDescriptorImpl)(object2 = this.f.getStaticDescriptor(this.c, location.declaringType()))).isExpandable()) {
                xValueChildrenList.addTopGroup((XValueGroup)new JavaStaticGroup((StaticDescriptorImpl)object2, evaluationContextImpl, this.f));
            }
            object2 = debuggerContextImpl.getDebugProcess();
            if (object2 == null) {
                return;
            }
            Pair<Method, Value> pair2 = ((DebugProcessImpl)((Object)object2)).getLastExecutedMethod();
            if (pair2 != null && this.c.getUiIndex() == 0) {
                object = this.f.getMethodReturnValueDescriptor(this.c, (Method)pair2.getFirst(), (Value)pair2.getSecond());
                xValueChildrenList.add((XNamedValue)JavaValue.create((ValueDescriptorImpl)object, evaluationContextImpl, this.f));
            }
            object = new HashSet();
            for (Pair<Breakpoint, Event> pair3 : DebuggerUtilsEx.getEventDescriptors(debuggerContextImpl.getSuspendContext())) {
                ObjectReference objectReference3;
                Event event = (Event)pair3.getSecond();
                if (!(event instanceof ExceptionEvent) || (objectReference3 = ((ExceptionEvent)event).exception()) == null) continue;
                object.add(objectReference3);
            }
            object.forEach(objectReference -> xValueChildrenList.add((XNamedValue)JavaValue.create(this.f.getThrownExceptionObjectDescriptor(this.c, (ObjectReference)objectReference), evaluationContextImpl, this.f)));
            try {
                this.a(debuggerContextImpl, evaluationContextImpl, (DebugProcessImpl)((Object)object2), xValueChildrenList, objectReference2, location);
            }
            catch (EvaluateException evaluateException) {
                xCompositeNode.setErrorMessage(evaluateException.getMessage());
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            d.info((Throwable)invalidStackFrameException);
        }
        catch (InternalException internalException) {
            if (internalException.errorCode() == 35) {
                xCompositeNode.setErrorMessage(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{internalException.getMessage()}));
            }
            throw internalException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(DebuggerContextImpl debuggerContextImpl, EvaluationContextImpl evaluationContextImpl, @NotNull DebugProcessImpl debugProcessImpl, XValueChildrenList xValueChildrenList, ObjectReference objectReference, Location location) throws EvaluateException {
        block17: {
            ReferenceType referenceType;
            if (debugProcessImpl == null) {
                JavaStackFrame.a(4);
            }
            HashSet<String> hashSet = new HashSet<String>();
            if (NodeRendererSettings.getInstance().getClassRenderer().SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES && objectReference != null && debugProcessImpl.getVirtualMachineProxy().canGetSyntheticAttribute() && (referenceType = objectReference.referenceType()) instanceof ClassType && location != null && referenceType.equals(location.declaringType()) && referenceType.name().contains("$")) {
                for (Field object2 : referenceType.fields()) {
                    if (!DebuggerUtils.isSynthetic((TypeComponent)object2) || !StringUtil.startsWith((CharSequence)object2.name(), (CharSequence)"val$")) continue;
                    FieldDescriptorImpl fieldDescriptorImpl = this.f.getFieldDescriptor(this.c, objectReference, object2);
                    xValueChildrenList.add((XNamedValue)JavaValue.create(fieldDescriptorImpl, evaluationContextImpl, this.f));
                    hashSet.add(fieldDescriptorImpl.calcValueName());
                }
            }
            boolean bl2 = DebuggerSettings.getInstance().AUTO_VARIABLES_MODE;
            if (evaluationContextImpl == null) {
                return;
            }
            try {
                if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions() && !bl2) {
                    this.superBuildVariables(evaluationContextImpl, xValueChildrenList);
                } else {
                    void var11_19;
                    SourcePosition sourcePosition = debuggerContextImpl.getSourcePosition();
                    Map exception = ContainerUtil.map2Map(this.getVisibleVariables(), localVariableProxyImpl -> Pair.create((Object)localVariableProxyImpl.name(), (Object)localVariableProxyImpl));
                    Pair<Set<String>, Set<TextWithImports>> pair2 = b;
                    if (sourcePosition != null) {
                        Pair pair3 = (Pair)ReadAction.compute(() -> JavaStackFrame.a(ContainerUtil.union(exception.keySet(), (Set)hashSet), sourcePosition));
                    }
                    if (bl2) {
                        for (Object object : (Set)var11_19.first) {
                            LocalVariableProxyImpl localVariableProxyImpl2 = (LocalVariableProxyImpl)exception.get(object);
                            if (localVariableProxyImpl2 == null) continue;
                            xValueChildrenList.add((XNamedValue)JavaValue.create(this.f.getLocalVariableDescriptor(null, localVariableProxyImpl2), evaluationContextImpl, this.f));
                        }
                    } else {
                        this.superBuildVariables(evaluationContextImpl, xValueChildrenList);
                    }
                    EvaluationContextImpl evaluationContextImpl2 = evaluationContextImpl.withAutoLoadClasses(false);
                    if (sourcePosition != null) {
                        Object object;
                        object = JavaStackFrame.a((Pair<Set<String>, Set<TextWithImports>>)var11_19, sourcePosition, evaluationContextImpl);
                        this.a((Set<TextWithImports>)object, xValueChildrenList, evaluationContextImpl);
                    }
                    this.a((Set)var11_19.second, xValueChildrenList, evaluationContextImpl2);
                }
            }
            catch (EvaluateException evaluateException) {
                if (evaluateException.getCause() instanceof AbsentInformationException) {
                    xValueChildrenList.add((XNamedValue)LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE);
                    try {
                        for (Map.Entry<DecompiledLocalVariable, Value> entry : LocalVariablesUtil.fetchValues(this.getStackFrameProxy(), debugProcessImpl, true).entrySet()) {
                            xValueChildrenList.add((XNamedValue)JavaValue.create(this.f.getArgumentValueDescriptor(null, entry.getKey(), entry.getValue()), evaluationContextImpl, this.f));
                        }
                    }
                    catch (Exception exception) {
                        d.info((Throwable)exception);
                        break block17;
                    }
                }
                throw evaluateException;
            }
        }
    }

    private static Set<TextWithImports> a(Pair<Set<String>, Set<TextWithImports>> pair2, @NotNull SourcePosition sourcePosition, @NotNull EvaluationContextImpl evaluationContextImpl) {
        if (sourcePosition == null) {
            JavaStackFrame.a(5);
        }
        if (evaluationContextImpl == null) {
            JavaStackFrame.a(6);
        }
        HashSet<String> hashSet = new HashSet<String>((Collection)pair2.first);
        ((Set)pair2.second).stream().map(TextWithImports::getText).forEach(hashSet::add);
        HashSet<TextWithImports> hashSet2 = new HashSet<TextWithImports>();
        for (FrameExtraVariablesProvider frameExtraVariablesProvider : (FrameExtraVariablesProvider[])FrameExtraVariablesProvider.EP_NAME.getExtensions()) {
            if (!frameExtraVariablesProvider.isAvailable(sourcePosition, evaluationContextImpl)) continue;
            hashSet2.addAll(frameExtraVariablesProvider.collectVariables(sourcePosition, evaluationContextImpl, hashSet));
        }
        return hashSet2;
    }

    private void a(Set<TextWithImports> set, XValueChildrenList xValueChildrenList, EvaluationContextImpl evaluationContextImpl) {
        for (TextWithImports textWithImports : set) {
            WatchItemDescriptor watchItemDescriptor = this.f.getWatchItemDescriptor(null, textWithImports, null);
            xValueChildrenList.add((XNamedValue)JavaValue.create(watchItemDescriptor, evaluationContextImpl, this.f));
        }
    }

    public static XNamedValue createMessageNode(String string, Icon icon) {
        return new DummyMessageValueNode(string, icon);
    }

    protected void superBuildVariables(EvaluationContextImpl evaluationContextImpl, XValueChildrenList xValueChildrenList) throws EvaluateException {
        for (LocalVariableProxyImpl localVariableProxyImpl : this.getVisibleVariables()) {
            xValueChildrenList.add((XNamedValue)JavaValue.create(this.f.getLocalVariableDescriptor(null, localVariableProxyImpl), evaluationContextImpl, this.f));
        }
    }

    @NotNull
    public StackFrameProxyImpl getStackFrameProxy() {
        StackFrameProxyImpl stackFrameProxyImpl = this.c.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            JavaStackFrame.a(7);
        }
        return stackFrameProxyImpl;
    }

    @Nullable
    public Object getEqualityObject() {
        return this.i;
    }

    public String toString() {
        if (this.g != null) {
            return "JavaFrame " + this.g.getFile().getName() + ":" + this.g.getLine();
        }
        return "JavaFrame position unknown";
    }

    protected List<LocalVariableProxyImpl> getVisibleVariables() throws EvaluateException {
        return this.getStackFrameProxy().visibleVariables();
    }

    private static boolean b(PsiFile psiFile, Document document, int n2) {
        int n3 = document.getLineStartOffset(n2);
        int n4 = document.getLineEndOffset(n2);
        int n5 = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)n3, (String)" \n\t");
        if (n5 >= n4) {
            return true;
        }
        TextRange textRange = null;
        for (PsiElement psiElement = psiFile.findElementAt(n5); !(psiElement == null || psiElement.getTextOffset() > n4 || textRange != null && textRange.contains(psiElement.getTextRange())); psiElement = psiElement.getNextSibling()) {
            PsiElement psiElement2 = psiElement;
            while (psiElement2.getTextOffset() >= n5) {
                PsiElement psiElement3;
                textRange = psiElement2.getTextRange();
                if (psiElement2 instanceof PsiDeclarationStatement) {
                    for (PsiElement psiElement4 : psiElement3 = ((PsiDeclarationStatement)psiElement2).getDeclaredElements()) {
                        if (!(psiElement4 instanceof PsiVariable)) continue;
                        return false;
                    }
                }
                if (psiElement2 instanceof PsiJavaCodeReferenceElement) {
                    try {
                        psiElement3 = ((PsiJavaCodeReferenceElement)psiElement2).resolve();
                        if (psiElement3 instanceof PsiVariable) {
                            return false;
                        }
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        return false;
                    }
                }
                psiElement2 = psiElement2.getParent();
            }
        }
        return true;
    }

    private static Pair<Set<String>, Set<TextWithImports>> a(Set<String> set, @NotNull SourcePosition sourcePosition) {
        int n2;
        PsiElement psiElement;
        int n3;
        Document document;
        int n4;
        if (sourcePosition == null) {
            JavaStackFrame.a(8);
        }
        if ((n4 = sourcePosition.getLine()) < 0) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        PsiFile psiFile = sourcePosition.getFile();
        if (!psiFile.isValid() || !psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return Pair.create(set, Collections.emptySet());
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Document document2 = document = virtualFile != null ? FileDocumentManager.getInstance().getDocument(virtualFile) : null;
        if (document == null || document.getLineCount() == 0 || n4 > document.getLineCount() - 1) {
            return Pair.create(Collections.emptySet(), Collections.emptySet());
        }
        TextRange textRange = JavaStackFrame.a(psiFile, document, n4);
        int n5 = Math.max(textRange.getStartOffset(), n4 - 1);
        for (n5 = Math.min(n5, textRange.getEndOffset()); n5 > textRange.getStartOffset() && JavaStackFrame.b(psiFile, document, n5); --n5) {
        }
        int n6 = document.getLineStartOffset(n5);
        for (n3 = Math.min(n4 + 2, textRange.getEndOffset()); n3 < textRange.getEndOffset() && JavaStackFrame.b(psiFile, document, n3); ++n3) {
        }
        int n7 = document.getLineEndOffset(n3);
        TextRange textRange2 = new TextRange(n6, n7);
        if (!textRange2.isEmpty() && (psiElement = psiFile.findElementAt(n2 = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)document.getLineStartOffset(n4), (String)" \t"))) != null) {
            Object object;
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiMethod.class});
            if (psiMethod != null) {
                psiElement = psiMethod;
            } else {
                object = (PsiField)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiField.class});
                if (object != null) {
                    psiElement = object;
                } else {
                    PsiClassInitializer psiClassInitializer = (PsiClassInitializer)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiClassInitializer.class});
                    if (psiClassInitializer != null) {
                        psiElement = psiClassInitializer;
                    }
                }
            }
            if (psiElement instanceof PsiCompiledElement) {
                return Pair.create(set, Collections.emptySet());
            }
            object = new VariablesCollector(set, JavaStackFrame.a(psiElement, textRange2));
            psiElement.accept((PsiElementVisitor)object);
            return Pair.create(((VariablesCollector)((Object)object)).getVars(), ((VariablesCollector)((Object)object)).getExpressions());
        }
        return Pair.create(Collections.emptySet(), Collections.emptySet());
    }

    private static TextRange a(PsiFile psiFile, Document document, int n2) {
        PsiMethod psiMethod;
        int n3 = document.getLineStartOffset(n2);
        if (n3 > 0 && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(n3), PsiMethod.class, (boolean)false)) != null) {
            TextRange textRange = psiMethod.getTextRange();
            return new TextRange(document.getLineNumber(textRange.getStartOffset()), document.getLineNumber(textRange.getEndOffset()));
        }
        return new TextRange(0, document.getLineCount() - 1);
    }

    private static TextRange a(PsiElement psiElement, final TextRange textRange) {
        final Ref ref = new Ref((Object)textRange);
        psiElement.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitExpressionStatement(PsiExpressionStatement psiExpressionStatement) {
                TextRange textRange3 = psiExpressionStatement.getTextRange();
                if (textRange.intersects(textRange3)) {
                    TextRange textRange2 = (TextRange)ref.get();
                    int n2 = Math.min(textRange2.getStartOffset(), textRange3.getStartOffset());
                    int n3 = Math.max(textRange2.getEndOffset(), textRange3.getEndOffset());
                    ref.set((Object)new TextRange(n2, n3));
                }
            }
        });
        return (TextRange)ref.get();
    }

    public void setInsertCapturePoint(CapturePoint capturePoint) {
        this.a = capturePoint;
    }

    @Override
    public boolean isSynthetic() {
        return this.c.isSynthetic();
    }

    @Override
    public boolean isInLibraryContent() {
        return this.c.isInLibraryContent();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JavaStackFrame javaStackFrame = (JavaStackFrame)object;
        return this.c.getFrameProxy().equals(javaStackFrame.c.getFrameProxy());
    }

    public int hashCode() {
        return this.c.getFrameProxy().hashCode();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaStackFrame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaStackFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackFrameProxy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVariables";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeExtraVars";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedVars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VariablesCollector
    extends JavaRecursiveElementVisitor {
        private final Set<String> b;
        private final TextRange c;
        private final Set<TextWithImports> a = new HashSet<TextWithImports>();
        private final Set<String> d = new HashSet<String>();
        private final boolean e = XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions();

        public VariablesCollector(Set<String> set, TextRange textRange) {
            this.b = set;
            this.c = textRange;
        }

        public Set<String> getVars() {
            return this.d;
        }

        public Set<TextWithImports> getExpressions() {
            return this.a;
        }

        public void visitElement(PsiElement psiElement) {
            if (this.c.intersects(psiElement.getTextRange())) {
                super.visitElement(psiElement);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression psiMethodCallExpression) {
            PsiMethod psiMethod;
            if (this.e && (psiMethod = psiMethodCallExpression.resolveMethod()) != null && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)psiMethodCallExpression, this.b)) {
                this.a.add(new TextWithImportsImpl((PsiElement)psiMethodCallExpression));
            }
            super.visitMethodCallExpression(psiMethodCallExpression);
        }

        public void visitReferenceExpression(PsiReferenceExpression psiReferenceExpression) {
            PsiElement psiElement;
            if (this.c.intersects(psiReferenceExpression.getTextRange()) && (psiElement = psiReferenceExpression.resolve()) instanceof PsiVariable) {
                PsiVariable psiVariable = (PsiVariable)psiElement;
                if (psiVariable instanceof PsiField) {
                    if (this.e && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)psiReferenceExpression, this.b)) {
                        boolean bl2;
                        PsiModifierList psiModifierList = psiVariable.getModifierList();
                        boolean bl3 = bl2 = psiVariable instanceof PsiEnumConstant || psiModifierList != null && psiModifierList.hasModifierProperty("static") && psiModifierList.hasModifierProperty("final");
                        if (!bl2) {
                            this.a.add(new TextWithImportsImpl((PsiElement)psiReferenceExpression));
                        }
                    }
                } else if (this.b.contains(psiVariable.getName())) {
                    this.d.add(psiVariable.getName());
                } else if (!Comparing.equal((Object)PsiTreeUtil.getParentOfType((PsiElement)psiReferenceExpression, PsiClass.class), (Object)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiClass.class))) {
                    this.a.add(new TextWithImportsImpl((PsiElement)psiReferenceExpression));
                }
            }
            super.visitReferenceExpression(psiReferenceExpression);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression psiArrayAccessExpression) {
            if (this.e && !DebuggerUtils.hasSideEffectsOrReferencesMissingVars((PsiElement)psiArrayAccessExpression, this.b)) {
                this.a.add(new TextWithImportsImpl((PsiElement)psiArrayAccessExpression));
            }
            super.visitArrayAccessExpression(psiArrayAccessExpression);
        }

        public void visitParameter(PsiParameter psiParameter) {
            this.a((PsiVariable)psiParameter);
            super.visitParameter(psiParameter);
        }

        public void visitLocalVariable(PsiLocalVariable psiLocalVariable) {
            this.a((PsiVariable)psiLocalVariable);
            super.visitLocalVariable(psiLocalVariable);
        }

        private void a(PsiVariable psiVariable) {
            if (this.c.intersects(psiVariable.getTextRange()) && this.b.contains(psiVariable.getName())) {
                this.d.add(psiVariable.getName());
            }
        }

        public void visitClass(PsiClass psiClass) {
        }
    }

    static class DummyMessageValueNode
    extends XNamedValue {
        private final String a;
        private final Icon b;

        public DummyMessageValueNode(String string, Icon icon) {
            super("");
            this.a = string;
            this.b = icon;
        }

        public void computePresentation(@NotNull XValueNode xValueNode, @NotNull XValuePlace xValuePlace) {
            if (xValueNode == null) {
                DummyMessageValueNode.a(0);
            }
            if (xValuePlace == null) {
                DummyMessageValueNode.a(1);
            }
            xValueNode.setPresentation(this.b, new XValuePresentation(){

                @NotNull
                public String getSeparator() {
                    if ("" == null) {
                        1.a(0);
                    }
                    return "";
                }

                public void renderValue(@NotNull XValuePresentation.XValueTextRenderer xValueTextRenderer) {
                    if (xValueTextRenderer == null) {
                        1.a(1);
                    }
                    xValueTextRenderer.renderValue(a);
                }

                private static /* synthetic */ void a(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    switch (n2) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 2;
                            break;
                        }
                        case 1: {
                            n3 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "renderer";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getSeparator";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode$1";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "renderValue";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }, false);
        }

        public String toString() {
            return this.a;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/JavaStackFrame$DummyMessageValueNode";
            objectArray[2] = "computePresentation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

