/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import org.jetbrains.annotations.Nullable;

public class LambdaMethodFilter
implements BreakpointStepMethodFilter {
    private final int c;
    @Nullable
    private final SourcePosition a;
    private final int b;
    private final Range<Integer> d;

    public LambdaMethodFilter(PsiLambdaExpression psiLambdaExpression, int n2, Range<Integer> range) {
        this.c = n2;
        this.d = range;
        SourcePosition sourcePosition = null;
        SourcePosition sourcePosition2 = null;
        PsiElement psiElement = psiLambdaExpression.getBody();
        if (psiElement instanceof PsiCodeBlock) {
            PsiStatement[] psiStatementArray = ((PsiCodeBlock)psiElement).getStatements();
            if (psiStatementArray.length > 0 && (sourcePosition = SourcePosition.createFromElement((PsiElement)psiStatementArray[0])) != null) {
                PsiStatement psiStatement = psiStatementArray[psiStatementArray.length - 1];
                sourcePosition2 = SourcePosition.createFromOffset((PsiFile)sourcePosition.getFile(), (int)psiStatement.getTextRange().getEndOffset());
            }
        } else if (psiElement != null) {
            sourcePosition = SourcePosition.createFromElement((PsiElement)psiElement);
        }
        this.a = sourcePosition;
        this.b = sourcePosition2 != null ? sourcePosition2.getLine() : -1;
    }

    public int getLambdaOrdinal() {
        return this.c;
    }

    @Override
    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.a;
    }

    @Override
    public int getLastStatementLine() {
        return this.b;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl debugProcessImpl, Location location) throws EvaluateException {
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
        Method method = location.method();
        return DebuggerUtilsEx.isLambda(method) && (!virtualMachineProxyImpl.canGetSyntheticAttribute() || method.isSynthetic());
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.d;
    }
}

