/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;

public class SuspendManagerImpl
implements SuspendManager {
    private static final Logger e = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendManager");
    private final Deque<SuspendContextImpl> a;
    private final Deque<SuspendContextImpl> c;
    private final Set<ThreadReferenceProxyImpl> b;
    private final DebugProcessImpl d;
    public int suspends;

    public SuspendManagerImpl(@NotNull DebugProcessImpl debugProcessImpl) {
        if (debugProcessImpl == null) {
            SuspendManagerImpl.a(0);
        }
        this.a = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.c = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.b = Collections.synchronizedSet(new HashSet());
        this.suspends = 0;
        this.d = debugProcessImpl;
        this.d.addDebugProcessListener(new DebugProcessAdapterImpl(){

            @Override
            public void processDetached(DebugProcessImpl debugProcessImpl, boolean bl2) {
                SuspendManagerImpl.this.a.clear();
                SuspendManagerImpl.this.c.clear();
                SuspendManagerImpl.this.b.clear();
            }
        });
    }

    @Override
    public SuspendContextImpl pushSuspendContext(int n2, int n3) {
        SuspendContextImpl suspendContextImpl = new SuspendContextImpl(this.d, n2, n3, null){

            @Override
            protected void resumeImpl() {
                e.debug("Start resuming...");
                SuspendManagerImpl.this.d.logThreads();
                switch (this.getSuspendPolicy()) {
                    case 2: {
                        int n2 = 5;
                        while (--n2 > 0) {
                            try {
                                SuspendManagerImpl.this.d.getVirtualMachineProxy().resume();
                            }
                            catch (InternalException internalException) {
                                if (internalException.errorCode() == 13) continue;
                                e.error((Throwable)internalException);
                            }
                            break;
                        }
                        e.debug("VM resumed ");
                        break;
                    }
                    case 1: {
                        SuspendManagerImpl.this.b.remove(this.getThread());
                        this.getThread().resume();
                        if (!e.isDebugEnabled()) break;
                        e.debug("Thread resumed : " + this.getThread().toString());
                        break;
                    }
                    case 0: {
                        e.debug("None resumed");
                    }
                }
                if (e.isDebugEnabled()) {
                    e.debug("Suspends = " + SuspendManagerImpl.this.suspends);
                }
                SuspendManagerImpl.this.d.logThreads();
            }
        };
        this.b(suspendContextImpl);
        return suspendContextImpl;
    }

    @Override
    public SuspendContextImpl pushSuspendContext(final EventSet eventSet) {
        SuspendContextImpl suspendContextImpl = new SuspendContextImpl(this.d, eventSet.suspendPolicy(), eventSet.size(), eventSet){

            @Override
            protected void resumeImpl() {
                if (e.isDebugEnabled()) {
                    e.debug("Start resuming eventSet " + eventSet.toString() + " suspendPolicy = " + eventSet.suspendPolicy() + ",size = " + eventSet.size());
                }
                SuspendManagerImpl.this.d.logThreads();
                int n2 = 5;
                while (--n2 > 0) {
                    try {
                        eventSet.resume();
                        break;
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        e.info((Throwable)objectCollectedException);
                    }
                    catch (InternalException internalException) {
                        if (internalException.errorCode() == 13 && eventSet.suspendPolicy() == 2) continue;
                        e.error((Throwable)internalException);
                        break;
                    }
                }
                e.debug("Set resumed ");
                SuspendManagerImpl.this.d.logThreads();
            }
        };
        this.b(suspendContextImpl);
        return suspendContextImpl;
    }

    private void b(SuspendContextImpl suspendContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.a.addFirst(suspendContextImpl);
        ++this.suspends;
        if (e.isDebugEnabled()) {
            e.debug("Push context : Suspends = " + this.suspends);
        }
    }

    @Override
    public void resume(SuspendContextImpl suspendContextImpl) {
        SuspendManagerUtil.prepareForResume(suspendContextImpl);
        this.d.logThreads();
        this.popContext(suspendContextImpl);
        suspendContextImpl.resume();
        this.d.clearCashes(suspendContextImpl.getSuspendPolicy());
    }

    @Override
    public void popFrame(SuspendContextImpl suspendContextImpl) {
        this.popContext(suspendContextImpl);
        SuspendContextImpl suspendContextImpl2 = this.pushSuspendContext(suspendContextImpl.getSuspendPolicy(), 0);
        suspendContextImpl2.setThread(suspendContextImpl.getThread().getThreadReference());
        this.notifyPaused(suspendContextImpl2);
    }

    @Override
    public SuspendContextImpl getPausedContext() {
        return this.c.peekFirst();
    }

    public void popContext(SuspendContextImpl suspendContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        --this.suspends;
        if (e.isDebugEnabled()) {
            e.debug("popContext, suspends = " + this.suspends);
        }
        this.a.remove((Object)suspendContextImpl);
        this.c.remove((Object)suspendContextImpl);
    }

    void pushPausedContext(SuspendContextImpl suspendContextImpl) {
        if (e.isDebugEnabled()) {
            e.assertTrue(this.a.contains((Object)suspendContextImpl));
        }
        this.c.addFirst(suspendContextImpl);
    }

    public boolean hasEventContext(SuspendContextImpl suspendContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.a.contains((Object)suspendContextImpl);
    }

    @Override
    public List<SuspendContextImpl> getEventContexts() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new ArrayList<SuspendContextImpl>(this.a);
    }

    @Override
    public boolean isFrozen(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        return this.b.contains(threadReferenceProxyImpl);
    }

    @Override
    public boolean isSuspended(ThreadReferenceProxyImpl threadReferenceProxyImpl) throws ObjectCollectedException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        boolean bl2 = this.isFrozen(threadReferenceProxyImpl) ? true : this.a.stream().anyMatch(suspendContextImpl -> suspendContextImpl.suspends(threadReferenceProxyImpl));
        return bl2 && (threadReferenceProxyImpl == null || threadReferenceProxyImpl.isSuspended());
    }

    @Override
    public void suspendThread(SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        e.assertTrue(threadReferenceProxyImpl != suspendContextImpl.getThread(), (Object)"Thread is already suspended at the breakpoint");
        if (suspendContextImpl.isExplicitlyResumed(threadReferenceProxyImpl)) {
            suspendContextImpl.myResumedThreads.remove(threadReferenceProxyImpl);
            threadReferenceProxyImpl.suspend();
        }
    }

    @Override
    public void resumeThread(SuspendContextImpl suspendContextImpl, @NotNull ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (threadReferenceProxyImpl == null) {
            SuspendManagerImpl.a(1);
        }
        e.assertTrue(!suspendContextImpl.isExplicitlyResumed(threadReferenceProxyImpl));
        if (suspendContextImpl.myResumedThreads == null) {
            suspendContextImpl.myResumedThreads = new HashSet<ThreadReferenceProxyImpl>();
        }
        suspendContextImpl.myResumedThreads.add(threadReferenceProxyImpl);
        threadReferenceProxyImpl.resume();
    }

    @Override
    public void freezeThread(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (this.b.add(threadReferenceProxyImpl)) {
            threadReferenceProxyImpl.suspend();
        }
    }

    @Override
    public void unfreezeThread(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (this.b.remove(threadReferenceProxyImpl)) {
            threadReferenceProxyImpl.resume();
        }
    }

    private void a(final SuspendContextImpl suspendContextImpl) {
        e.assertTrue(suspendContextImpl.myVotesToVote > 0);
        --suspendContextImpl.myVotesToVote;
        if (e.isDebugEnabled()) {
            e.debug("myVotesToVote = " + suspendContextImpl.myVotesToVote);
        }
        if (suspendContextImpl.myVotesToVote == 0) {
            if (suspendContextImpl.myIsVotedForResume) {
                this.d.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        SuspendManagerImpl.this.resume(suspendContextImpl);
                    }

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }
                });
            } else {
                e.debug("vote paused");
                this.d.logThreads();
                this.d.cancelRunToCursorBreakpoint();
                if (!Registry.is((String)"debugger.keep.step.requests")) {
                    ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
                    this.d.deleteStepRequests(threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null);
                }
                this.notifyPaused(suspendContextImpl);
            }
        }
    }

    public void notifyPaused(SuspendContextImpl suspendContextImpl) {
        this.pushPausedContext(suspendContextImpl);
        ((DebugProcessListener)this.d.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContextImpl);
    }

    @Override
    public void voteResume(SuspendContextImpl suspendContextImpl) {
        e.debug("Resume voted");
        this.a(suspendContextImpl);
    }

    @Override
    public void voteSuspend(SuspendContextImpl suspendContextImpl) {
        suspendContextImpl.myIsVotedForResume = false;
        this.a(suspendContextImpl);
    }

    public List<SuspendContextImpl> getPausedContexts() {
        return new ArrayList<SuspendContextImpl>(this.c);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/SuspendManagerImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resumeThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

