/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

class ArrayAccessEvaluator
implements Evaluator {
    private final Evaluator b;
    private final Evaluator c;
    private ArrayReference d;
    private int a;

    public ArrayAccessEvaluator(Evaluator evaluator, Evaluator evaluator2) {
        this.b = evaluator;
        this.c = evaluator2;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        this.a = 0;
        this.d = null;
        Value value = (Value)this.c.evaluate(evaluationContextImpl);
        Value value2 = (Value)this.b.evaluate(evaluationContextImpl);
        if (!(value2 instanceof ArrayReference)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.array.reference.expected", (Object[])new Object[0]));
        }
        this.d = (ArrayReference)value2;
        if (!DebuggerUtils.isInteger((Value)value)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.index.expression", (Object[])new Object[0]));
        }
        this.a = ((PrimitiveValue)value).intValue();
        try {
            return this.d.getValue(this.a);
        }
        catch (Exception exception) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = null;
        if (this.d != null) {
            modifier = new Modifier(){

                public boolean canInspect() {
                    return true;
                }

                public boolean canSetValue() {
                    return true;
                }

                public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
                    ArrayAccessEvaluator.this.d.setValue(ArrayAccessEvaluator.this.a, value);
                }

                public Type getExpectedType() throws EvaluateException {
                    try {
                        ArrayType arrayType = (ArrayType)ArrayAccessEvaluator.this.d.referenceType();
                        return arrayType.componentType();
                    }
                    catch (ClassNotLoadedException classNotLoadedException) {
                        throw EvaluateExceptionUtil.createEvaluateException((Throwable)classNotLoadedException);
                    }
                }

                public NodeDescriptorImpl getInspectItem(Project project2) {
                    return new ArrayElementDescriptorImpl(project2, ArrayAccessEvaluator.this.d, ArrayAccessEvaluator.this.a);
                }
            };
        }
        return modifier;
    }
}

