/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class AssignmentEvaluator
implements Evaluator {
    private final Evaluator a;
    private final Evaluator b;

    public AssignmentEvaluator(@NotNull Evaluator evaluator, @NotNull Evaluator evaluator2) {
        if (evaluator == null) {
            AssignmentEvaluator.a(0);
        }
        if (evaluator2 == null) {
            AssignmentEvaluator.a(1);
        }
        this.a = evaluator;
        this.b = DisableGC.create(evaluator2);
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        this.a.evaluate(evaluationContextImpl);
        Modifier modifier = this.a.getModifier();
        Object object = this.b.evaluate(evaluationContextImpl);
        if (object != null && !(object instanceof Value)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.not.rvalue", (Object[])new Object[0]));
        }
        AssignmentEvaluator.assign(modifier, object, evaluationContextImpl);
        return object;
    }

    static void assign(Modifier modifier, Object object, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        if (modifier == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.not.lvalue", (Object[])new Object[0]));
        }
        try {
            modifier.setValue((Value)object);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            if (!evaluationContextImpl.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)classNotLoadedException);
            }
            try {
                evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, classNotLoadedException.className(), evaluationContextImpl.getClassLoader());
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException exception) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
            }
        }
        catch (InvalidTypeException invalidTypeException) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)invalidTypeException);
        }
    }

    @Override
    public Modifier getModifier() {
        return this.a.getModifier();
    }

    public String toString() {
        return this.a + " = " + this.b;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "leftEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rightEvaluator";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/AssignmentEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

