/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.expression.BlockStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;

public class CodeFragmentEvaluator
extends BlockStatementEvaluator {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator");
    private final CodeFragmentEvaluator a;
    private final Map<String, Object> b = new HashMap<String, Object>();

    public CodeFragmentEvaluator(CodeFragmentEvaluator codeFragmentEvaluator) {
        super(null);
        this.a = codeFragmentEvaluator;
    }

    public void setStatements(Evaluator[] evaluatorArray) {
        this.myStatements = evaluatorArray;
    }

    public Value getValue(String string, VirtualMachineProxyImpl virtualMachineProxyImpl) throws EvaluateException {
        if (!this.b.containsKey(string)) {
            if (this.a != null) {
                return this.a.getValue(string, virtualMachineProxyImpl);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.variable.not.declared", (Object[])new Object[]{string}));
        }
        Object object = this.b.get(string);
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return virtualMachineProxyImpl.mirrorOf((Boolean)object);
        }
        if (object instanceof Byte) {
            return virtualMachineProxyImpl.mirrorOf((Byte)object);
        }
        if (object instanceof Character) {
            return virtualMachineProxyImpl.mirrorOf(((Character)object).charValue());
        }
        if (object instanceof Short) {
            return virtualMachineProxyImpl.mirrorOf((Short)object);
        }
        if (object instanceof Integer) {
            return virtualMachineProxyImpl.mirrorOf((Integer)object);
        }
        if (object instanceof Long) {
            return virtualMachineProxyImpl.mirrorOf((Long)object);
        }
        if (object instanceof Float) {
            return virtualMachineProxyImpl.mirrorOf(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return virtualMachineProxyImpl.mirrorOf((Double)object);
        }
        if (object instanceof String) {
            return virtualMachineProxyImpl.mirrorOf((String)object);
        }
        c.error("unknown default initializer type " + object.getClass().getName());
        return null;
    }

    private boolean a(String string) {
        if (!this.b.containsKey(string)) {
            if (this.a != null) {
                return this.a.a(string);
            }
            return false;
        }
        return true;
    }

    public void setInitialValue(String string, Object object) {
        c.assertTrue(!(object instanceof Value), (Object)"use setValue for jdi values");
        if (this.a(string)) {
            throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.variable.already.declared", (Object[])new Object[]{string})));
        }
        this.b.put(string, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String string, Value value) throws EvaluateException {
        if (!this.b.containsKey(string)) {
            if (this.a == null) throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.variable.not.declared", (Object[])new Object[]{string}));
            this.a.setValue(string, value);
            return;
        } else {
            this.b.put(string, value);
        }
    }
}

