/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.StringReference;
import java.util.Collections;

class LiteralEvaluator
implements Evaluator {
    private final Object b;
    private final String a;

    public LiteralEvaluator(Object object, String string) {
        this.b = object;
        this.a = string;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        if (this.b == null) {
            return null;
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl = evaluationContextImpl.getDebugProcess().getVirtualMachineProxy();
        if (this.b instanceof Boolean) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.a, (Boolean)this.b);
        }
        if (this.b instanceof Character) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.a, ((Character)this.b).charValue());
        }
        if (this.b instanceof Double) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.a, ((Number)this.b).doubleValue());
        }
        if (this.b instanceof Float) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.a, ((Number)this.b).floatValue());
        }
        if (this.b instanceof Number) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.a, ((Number)this.b).longValue());
        }
        if (this.b instanceof String) {
            return virtualMachineProxyImpl.mirrorOfStringLiteral((String)this.b, (ThrowableComputable<StringReference, EvaluateException>)((ThrowableComputable)() -> {
                Method method;
                StringReference stringReference = virtualMachineProxyImpl.mirrorOf((String)this.b);
                if (Registry.is((String)"debugger.intern.string.literals") && virtualMachineProxyImpl.versionHigher("1.7") && (method = ((ClassType)stringReference.referenceType()).concreteMethodByName("intern", "()Ljava/lang/String;")) != null) {
                    return (StringReference)evaluationContextImpl.getDebugProcess().invokeMethod((EvaluationContext)evaluationContextImpl, stringReference, method, Collections.emptyList());
                }
                return stringReference;
            }));
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{this.a}));
    }

    public String toString() {
        return this.b != null ? this.b.toString() : "null";
    }
}

