/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;

class NewArrayInstanceEvaluator
implements Evaluator {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.NewArrayInstanceEvaluator");
    private final Evaluator a;
    private Evaluator d = null;
    private Evaluator b = null;

    public NewArrayInstanceEvaluator(Evaluator evaluator, Evaluator evaluator2, Evaluator evaluator3) {
        this.a = evaluator;
        this.d = evaluator2;
        this.b = evaluator3;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        int n2;
        Object object;
        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
        Object object2 = this.a.evaluate(evaluationContextImpl);
        if (!(object2 instanceof ArrayType)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.array.type.expected", (Object[])new Object[0]));
        }
        ArrayType arrayType = (ArrayType)object2;
        Object[] objectArray = null;
        if (this.d != null) {
            object = this.d.evaluate(evaluationContextImpl);
            if (!(object instanceof Value) || !DebuggerUtils.isNumeric((Value)((Value)object))) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.array.dimention.numeric.value.expected", (Object[])new Object[0]));
            }
            PrimitiveValue primitiveValue = (PrimitiveValue)object;
            n2 = primitiveValue.intValue();
        } else {
            object = this.b.evaluate(evaluationContextImpl);
            if (!(object instanceof Object[])) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.array.initializer", (Object[])new Object[0]));
            }
            objectArray = (Object[])object;
            n2 = objectArray.length;
        }
        object = debugProcessImpl.newInstance(arrayType, n2);
        if (objectArray != null && objectArray.length > 0) {
            if (c.isDebugEnabled()) {
                c.debug("Setting initial values: dimension = " + n2 + "; array size is " + objectArray.length);
            }
            NewArrayInstanceEvaluator.a((ArrayReference)object, objectArray, evaluationContextImpl);
        }
        return object;
    }

    private static void a(ArrayReference arrayReference, Object[] objectArray, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        ArrayType arrayType = (ArrayType)arrayReference.referenceType();
        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
        try {
            if (arrayType.componentType() instanceof ArrayType) {
                ArrayType arrayType2 = (ArrayType)arrayType.componentType();
                int n2 = arrayReference.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    ArrayReference arrayReference2 = (ArrayReference)arrayReference.getValue(i2);
                    Object object = objectArray[i2];
                    if (object instanceof Value) {
                        arrayReference.setValue(i2, (Value)object);
                        continue;
                    }
                    Object[] objectArray2 = (Object[])object;
                    if (arrayReference2 == null) {
                        arrayReference2 = debugProcessImpl.newInstance(arrayType2, objectArray2.length);
                        arrayReference.setValue(i2, (Value)arrayReference2);
                    }
                    NewArrayInstanceEvaluator.a(arrayReference2, objectArray2, evaluationContextImpl);
                }
            } else if (objectArray.length > 0) {
                arrayReference.setValues(new ArrayList<Object>(Arrays.asList(objectArray)));
            }
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            ReferenceType referenceType;
            try {
                referenceType = evaluationContextImpl.isAutoLoadClasses() ? debugProcessImpl.loadClass(evaluationContextImpl, classNotLoadedException.className(), arrayType.classLoader()) : null;
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException exception) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
            }
            if (referenceType != null) {
                NewArrayInstanceEvaluator.a(arrayReference, objectArray, evaluationContextImpl);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{classNotLoadedException.className()}));
        }
        catch (InvalidTypeException invalidTypeException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.array.initializer.type", (Object[])new Object[0]));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.array.size", (Object[])new Object[0]));
        }
        catch (ClassCastException classCastException) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.initialize.array", (Object[])new Object[0]));
        }
    }
}

