/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnBoxingEvaluator
implements Evaluator {
    private static final Logger a = Logger.getInstance(UnBoxingEvaluator.class);
    private final Evaluator b;
    private static final Map<String, Couple<String>> c = new HashMap<String, Couple<String>>();

    public static boolean isTypeUnboxable(String string) {
        return c.containsKey(string);
    }

    public UnBoxingEvaluator(@NotNull Evaluator evaluator) {
        if (evaluator == null) {
            UnBoxingEvaluator.a(0);
        }
        this.b = DisableGC.create(evaluator);
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        return UnBoxingEvaluator.unbox(this.b.evaluate(evaluationContextImpl), evaluationContextImpl);
    }

    public static Object unbox(@Nullable Object object, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        String string;
        Couple<String> couple;
        if (object == null) {
            throw new EvaluateException("java.lang.NullPointerException: cannot unbox null value");
        }
        if (object instanceof ObjectReference && (couple = c.get(string = ((ObjectReference)object).type().name())) != null) {
            return UnBoxingEvaluator.a(evaluationContextImpl, (ObjectReference)object, (String)couple.getFirst(), (String)couple.getSecond());
        }
        return object;
    }

    private static Value a(EvaluationContextImpl evaluationContextImpl, ObjectReference objectReference, String string, String string2) throws EvaluateException {
        PrimitiveValue primitiveValue = UnBoxingEvaluator.getInnerPrimitiveValue(objectReference);
        if (primitiveValue != null) {
            return primitiveValue;
        }
        Method method = ((ClassType)objectReference.referenceType()).concreteMethodByName(string, string2);
        if (method == null) {
            throw new EvaluateException("Cannot convert to primitive value of type " + objectReference.type() + ": Unable to find method " + string + string2);
        }
        return evaluationContextImpl.getDebugProcess().invokeMethod((EvaluationContext)evaluationContextImpl, objectReference, method, Collections.emptyList());
    }

    @Nullable
    public static PrimitiveValue getInnerPrimitiveValue(@Nullable ObjectReference objectReference) {
        Value value;
        ReferenceType referenceType;
        Field field;
        if (objectReference != null && (field = (referenceType = objectReference.referenceType()).fieldByName("value")) != null && (value = objectReference.getValue(field)) instanceof PrimitiveValue) {
            a.assertTrue(referenceType.name().equals(PsiJavaParserFacadeImpl.getPrimitiveType((String)value.type().name()).getBoxedTypeName()));
            return (PrimitiveValue)value;
        }
        return null;
    }

    static {
        c.put("java.lang.Boolean", (Couple<String>)Couple.of((Object)"booleanValue", (Object)"()Z"));
        c.put("java.lang.Byte", (Couple<String>)Couple.of((Object)"byteValue", (Object)"()B"));
        c.put("java.lang.Character", (Couple<String>)Couple.of((Object)"charValue", (Object)"()C"));
        c.put("java.lang.Short", (Couple<String>)Couple.of((Object)"shortValue", (Object)"()S"));
        c.put("java.lang.Integer", (Couple<String>)Couple.of((Object)"intValue", (Object)"()I"));
        c.put("java.lang.Long", (Couple<String>)Couple.of((Object)"longValue", (Object)"()J"));
        c.put("java.lang.Float", (Couple<String>)Couple.of((Object)"floatValue", (Object)"()F"));
        c.put("java.lang.Double", (Couple<String>)Couple.of((Object)"doubleValue", (Object)"()D"));
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/debugger/engine/evaluation/expression/UnBoxingEvaluator", "<init>"));
    }
}

