/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;

class UnaryExpressionEvaluator
implements Evaluator {
    private final IElementType d;
    private final String b;
    private final Evaluator a;
    private final String c;

    public UnaryExpressionEvaluator(IElementType iElementType, String string, Evaluator evaluator, String string2) {
        this.d = iElementType;
        this.b = string;
        this.a = evaluator;
        this.c = string2;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Value value = (Value)this.a.evaluate(evaluationContextImpl);
        VirtualMachineProxyImpl virtualMachineProxyImpl = evaluationContextImpl.getDebugProcess().getVirtualMachineProxy();
        if (this.d == JavaTokenType.PLUS) {
            if (DebuggerUtils.isNumeric((Value)value)) {
                return value;
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.numeric.expected", (Object[])new Object[0]));
        }
        if (this.d == JavaTokenType.MINUS) {
            if (DebuggerUtils.isInteger((Value)value)) {
                long l2 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, -l2);
            }
            if (DebuggerUtils.isNumeric((Value)value)) {
                double d2 = ((PrimitiveValue)value).doubleValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, -d2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.numeric.expected", (Object[])new Object[0]));
        }
        if (this.d == JavaTokenType.TILDE) {
            if (DebuggerUtils.isInteger((Value)value)) {
                long l3 = ((PrimitiveValue)value).longValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, l3 ^ 0xFFFFFFFFFFFFFFFFL);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.integer.expected", (Object[])new Object[0]));
        }
        if (this.d == JavaTokenType.EXCL) {
            if (value instanceof BooleanValue) {
                boolean bl2 = ((BooleanValue)value).booleanValue();
                return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, !bl2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.operation.not.supported", (Object[])new Object[]{this.c}));
    }
}

