/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SimpleColoredComponent;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnValueWatcher
implements OverheadProducer {
    private static final Logger k = Logger.getInstance((String)"#com.intellij.debugger.engine.requests.MethodReturnValueWatcher");
    @Nullable
    private Method b;
    @Nullable
    private Value h;
    private ThreadReference f;
    @Nullable
    private MethodEntryRequest d;
    @Nullable
    private Method c;
    @Nullable
    private MethodExitRequest j;
    private volatile boolean i;
    private final EventRequestManager e;
    private final DebugProcess g;
    private static final String a = "WATCHER_REQUEST_KEY";

    public MethodReturnValueWatcher(EventRequestManager eventRequestManager, DebugProcess debugProcess) {
        this.e = eventRequestManager;
        this.g = debugProcess;
    }

    private void a(MethodExitEvent methodExitEvent) {
        if (k.isDebugEnabled()) {
            k.debug("<- " + methodExitEvent.method());
        }
        try {
            if (Registry.is((String)"debugger.watch.return.speedup") && Comparing.equal((Object)this.c, (Object)methodExitEvent.method())) {
                k.debug("Now watching all");
                this.a(true);
                this.b().enable();
            }
            Method method = methodExitEvent.method();
            Value value = methodExitEvent.returnValue();
            if (method == null || !DebuggerUtilsEx.isVoid(method)) {
                this.b = method;
                this.h = value;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            k.error((Throwable)unsupportedOperationException);
        }
    }

    private void a(MethodEntryEvent methodEntryEvent) {
        if (k.isDebugEnabled()) {
            k.debug("-> " + methodEntryEvent.method());
        }
        try {
            if (this.d != null && this.d.isEnabled()) {
                this.j = this.b();
                this.j.addClassFilter(methodEntryEvent.method().declaringType());
                this.c = methodEntryEvent.method();
                this.j.enable();
                if (k.isDebugEnabled()) {
                    k.debug("Now watching only " + methodEntryEvent.method());
                }
                this.a(false);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw vMDisconnectedException;
        }
        catch (Exception exception) {
            k.error((Throwable)exception);
        }
    }

    private void a(boolean bl2) {
        if (this.d != null) {
            this.d.setEnabled(bl2);
        }
    }

    @Nullable
    public Method getLastExecutedMethod() {
        return this.b;
    }

    @Nullable
    public Value getLastMethodReturnValue() {
        return this.h;
    }

    @Override
    public boolean isEnabled() {
        return DebuggerSettings.getInstance().WATCH_RETURN_VALUES;
    }

    @Override
    public void setEnabled(boolean bl2) {
        DebuggerSettings.getInstance().WATCH_RETURN_VALUES = bl2;
        this.clear();
    }

    public boolean isTrackingEnabled() {
        return this.i;
    }

    public void enable(ThreadReference threadReference) {
        this.a(true, threadReference);
    }

    public void disable() {
        this.a(false, null);
    }

    private void a(boolean bl2, ThreadReference threadReference) {
        this.i = bl2;
        this.b(bl2 && this.isEnabled(), threadReference);
    }

    public void clear() {
        this.b = null;
        this.h = null;
        this.f = null;
    }

    private void b(boolean bl2, @Nullable ThreadReference threadReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.d != null) {
                this.e.deleteEventRequest(this.d);
                this.d = null;
            }
            if (this.j != null) {
                this.e.deleteEventRequest(this.j);
                this.j = null;
            }
            if (bl2) {
                OverheadTimings.add(this.g, this, 1L, null);
                this.clear();
                this.f = threadReference;
                if (Registry.is((String)"debugger.watch.return.speedup")) {
                    this.a().enable();
                }
                this.b().enable();
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    private MethodEntryRequest a() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.d = this.a(this.e.createMethodEntryRequest());
        return this.d;
    }

    @NotNull
    private MethodExitRequest b() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.j != null) {
            this.e.deleteEventRequest(this.j);
        }
        MethodExitRequest methodExitRequest = this.j = this.a(this.e.createMethodExitRequest());
        if (methodExitRequest == null) {
            MethodReturnValueWatcher.a(0);
        }
        return methodExitRequest;
    }

    @NotNull
    private <T extends EventRequest> T a(T t2) {
        t2.setSuspendPolicy(Registry.is((String)"debugger.watch.return.speedup") ? 1 : 0);
        if (this.f != null) {
            if (t2 instanceof MethodEntryRequest) {
                ((MethodEntryRequest)t2).addThreadFilter(this.f);
            } else if (t2 instanceof MethodExitRequest) {
                ((MethodExitRequest)t2).addThreadFilter(this.f);
            }
        }
        t2.putProperty(a, true);
        T t3 = t2;
        if (t3 == null) {
            MethodReturnValueWatcher.a(1);
        }
        return t3;
    }

    public boolean processEvent(Event event) {
        EventRequest eventRequest = event.request();
        if (eventRequest == null || eventRequest.getProperty(a) == null) {
            return false;
        }
        if (event instanceof MethodEntryEvent) {
            this.a((MethodEntryEvent)event);
        } else if (event instanceof MethodExitEvent) {
            this.a((MethodExitEvent)event);
        }
        return true;
    }

    @Override
    public void customizeRenderer(SimpleColoredComponent simpleColoredComponent) {
        simpleColoredComponent.setIcon(AllIcons.Debugger.WatchLastReturnValue);
        simpleColoredComponent.append(DebuggerBundle.message((String)"action.watches.method.return.value.enable", (Object[])new Object[0]));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/engine/requests/MethodReturnValueWatcher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createExitRequest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareRequest";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

