/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.RequestManager;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class RequestManagerImpl
extends DebugProcessAdapterImpl
implements RequestManager {
    private static final Logger f = Logger.getInstance((String)"#com.intellij.debugger.RequestManagerImpl");
    private static final Key b = Key.create((String)"ClassName");
    private static final Key<Requestor> e = Key.create((String)"Requestor");
    private final DebugProcessImpl d;
    private final Map<Requestor, String> a = new HashMap<Requestor, String>();
    private final Map<Requestor, Set<EventRequest>> h = new HashMap<Requestor, Set<EventRequest>>();
    private EventRequestManager c;
    @Nullable
    private ThreadReference g;

    public RequestManagerImpl(DebugProcessImpl debugProcessImpl) {
        this.d = debugProcessImpl;
        this.d.addDebugProcessListener(this);
    }

    public EventRequestManager getVMRequestManager() {
        return this.c;
    }

    @Nullable
    public ThreadReference getFilterThread() {
        return this.g;
    }

    public void setFilterThread(@Nullable ThreadReference threadReference) {
        this.g = threadReference;
    }

    public Set<EventRequest> findRequests(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Set<EventRequest> set = this.h.get(requestor);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    @Nullable
    public Requestor findRequestor(EventRequest eventRequest) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return eventRequest != null ? (Requestor)eventRequest.getProperty(e) : null;
    }

    private static void b(EventRequest eventRequest, String string) {
        if (eventRequest instanceof AccessWatchpointRequest) {
            ((AccessWatchpointRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof ExceptionRequest) {
            ((ExceptionRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof MethodEntryRequest) {
            ((MethodEntryRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof MethodExitRequest) {
            ((MethodExitRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof ModificationWatchpointRequest) {
            ((ModificationWatchpointRequest)eventRequest).addClassFilter(string);
        } else if (eventRequest instanceof WatchpointRequest) {
            ((WatchpointRequest)eventRequest).addClassFilter(string);
        }
    }

    private static void a(EventRequest eventRequest, String string) {
        if (eventRequest instanceof AccessWatchpointRequest) {
            ((AccessWatchpointRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof ExceptionRequest) {
            ((ExceptionRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof MethodEntryRequest) {
            ((MethodEntryRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof MethodExitRequest) {
            ((MethodExitRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof ModificationWatchpointRequest) {
            ((ModificationWatchpointRequest)eventRequest).addClassExclusionFilter(string);
        } else if (eventRequest instanceof WatchpointRequest) {
            ((WatchpointRequest)eventRequest).addClassExclusionFilter(string);
        }
    }

    private void a(FilteredRequestor filteredRequestor, EventRequest eventRequest) {
        if ("SuspendAll".equals(filteredRequestor.getSuspendPolicy())) {
            eventRequest.setSuspendPolicy(2);
        } else {
            eventRequest.setSuspendPolicy(1);
        }
        if (filteredRequestor.isCountFilterEnabled() && !filteredRequestor.isConditionEnabled()) {
            eventRequest.addCountFilter(filteredRequestor.getCountFilter());
        }
        if (filteredRequestor.isClassFiltersEnabled() && !(eventRequest instanceof BreakpointRequest)) {
            ClassFilter[] classFilterArray = filteredRequestor.getClassFilters();
            if (DebuggerUtilsEx.getEnabledNumber(classFilterArray) == 1) {
                for (ClassFilter classFilter : classFilterArray) {
                    if (!classFilter.isEnabled()) continue;
                    JVMName jVMName = (JVMName)ReadAction.compute(() -> {
                        PsiClass psiClass = DebuggerUtils.findClass((String)classFilter.getPattern(), (Project)this.d.getProject(), (GlobalSearchScope)this.d.getSearchScope());
                        if (psiClass == null) {
                            return null;
                        }
                        return JVMNameUtil.getJVMQualifiedName(psiClass);
                    });
                    String string = classFilter.getPattern();
                    try {
                        if (jVMName != null) {
                            string = jVMName.getName(this.d);
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        // empty catch block
                    }
                    RequestManagerImpl.b(eventRequest, string);
                    break;
                }
            }
            for (ClassFilter classFilter : filteredRequestor.getClassExclusionFilters()) {
                if (!classFilter.isEnabled()) continue;
                RequestManagerImpl.a(eventRequest, classFilter.getPattern());
            }
        }
        this.registerRequestInternal(filteredRequestor, eventRequest);
    }

    public void registerRequestInternal(Requestor requestor, EventRequest eventRequest) {
        this.registerRequest(requestor, eventRequest);
        eventRequest.putProperty(e, requestor);
    }

    public void registerRequest(Requestor requestor2, EventRequest eventRequest) {
        this.h.computeIfAbsent(requestor2, requestor -> new HashSet()).add(eventRequest);
    }

    @Nullable
    public ClassPrepareRequest createClassPrepareRequest(ClassPrepareRequestor classPrepareRequestor, String string) {
        if (this.c == null) {
            return null;
        }
        ClassPrepareRequest classPrepareRequest = this.c.createClassPrepareRequest();
        classPrepareRequest.setSuspendPolicy(1);
        if (!StringUtil.isEmpty((String)string)) {
            classPrepareRequest.addClassFilter(string);
            classPrepareRequest.putProperty(b, string);
        }
        this.registerRequestInternal((Requestor)classPrepareRequestor, classPrepareRequest);
        return classPrepareRequest;
    }

    public ExceptionRequest createExceptionRequest(FilteredRequestor filteredRequestor, ReferenceType referenceType, boolean bl2, boolean bl3) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ExceptionRequest exceptionRequest = this.c.createExceptionRequest(referenceType, bl2, bl3);
        this.a(filteredRequestor, exceptionRequest);
        return exceptionRequest;
    }

    public MethodEntryRequest createMethodEntryRequest(FilteredRequestor filteredRequestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodEntryRequest methodEntryRequest = this.c.createMethodEntryRequest();
        this.a(filteredRequestor, methodEntryRequest);
        return methodEntryRequest;
    }

    public MethodExitRequest createMethodExitRequest(FilteredRequestor filteredRequestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodExitRequest methodExitRequest = this.c.createMethodExitRequest();
        this.a(filteredRequestor, methodExitRequest);
        return methodExitRequest;
    }

    public BreakpointRequest createBreakpointRequest(FilteredRequestor filteredRequestor, Location location) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        BreakpointRequest breakpointRequest = this.c.createBreakpointRequest(location);
        this.a(filteredRequestor, breakpointRequest);
        this.a.remove(filteredRequestor);
        return breakpointRequest;
    }

    public AccessWatchpointRequest createAccessWatchpointRequest(FilteredRequestor filteredRequestor, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        AccessWatchpointRequest accessWatchpointRequest = this.c.createAccessWatchpointRequest(field);
        this.a(filteredRequestor, accessWatchpointRequest);
        return accessWatchpointRequest;
    }

    public ModificationWatchpointRequest createModificationWatchpointRequest(FilteredRequestor filteredRequestor, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ModificationWatchpointRequest modificationWatchpointRequest = this.c.createModificationWatchpointRequest(field);
        this.a(filteredRequestor, modificationWatchpointRequest);
        return modificationWatchpointRequest;
    }

    public void deleteRequest(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.a.remove(requestor);
        if (!this.d.isAttached()) {
            return;
        }
        Set<EventRequest> set = this.h.remove(requestor);
        if (set == null) {
            return;
        }
        for (EventRequest eventRequest : set) {
            try {
                Set<EventRequest> set2;
                Requestor requestor2 = (Requestor)eventRequest.getProperty(e);
                if (requestor2 != requestor && (set2 = this.h.get(requestor2)) != null) {
                    set2.remove(eventRequest);
                    if (set2.isEmpty()) {
                        this.h.remove(requestor2);
                    }
                }
                try {
                    this.c.deleteEventRequest(eventRequest);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    f.error("Exception in EventRequestManager.deleteEventRequest", (Throwable)arrayIndexOutOfBoundsException, new String[]{ThreadDumper.dumpThreadsToString()});
                }
            }
            catch (InvalidRequestStateException invalidRequestStateException) {
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 41) continue;
                f.info((Throwable)internalException);
            }
        }
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor classPrepareRequestor, SourcePosition sourcePosition) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List<ClassPrepareRequest> list2 = this.d.getPositionManager().createPrepareRequests(classPrepareRequestor, sourcePosition);
        if (list2.isEmpty()) {
            this.setInvalid((Requestor)classPrepareRequestor, DebuggerBundle.message((String)"status.invalid.breakpoint.out.of.class", (Object[])new Object[0]));
            return;
        }
        for (ClassPrepareRequest classPrepareRequest : list2) {
            if (classPrepareRequest == null) continue;
            this.registerRequest((Requestor)classPrepareRequestor, classPrepareRequest);
            classPrepareRequest.enable();
        }
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor classPrepareRequestor, String string) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ClassPrepareRequest classPrepareRequest = this.createClassPrepareRequest(classPrepareRequestor, string);
        if (classPrepareRequest != null) {
            this.registerRequest((Requestor)classPrepareRequestor, classPrepareRequest);
            classPrepareRequest.enable();
            if (f.isDebugEnabled()) {
                f.debug("classOrPatternToBeLoaded = " + string);
            }
        }
    }

    public void enableRequest(EventRequest eventRequest) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        f.assertTrue(this.findRequestor(eventRequest) != null);
        try {
            ThreadReference threadReference = this.g;
            if (threadReference != null) {
                if (eventRequest instanceof BreakpointRequest) {
                    ((BreakpointRequest)eventRequest).addThreadFilter(threadReference);
                } else if (eventRequest instanceof MethodEntryRequest) {
                    ((MethodEntryRequest)eventRequest).addThreadFilter(threadReference);
                } else if (eventRequest instanceof MethodExitRequest) {
                    ((MethodExitRequest)eventRequest).addThreadFilter(threadReference);
                }
            }
            eventRequest.enable();
        }
        catch (InternalException internalException) {
            switch (internalException.errorCode()) {
                case 40: {
                    f.info((Throwable)internalException);
                    break;
                }
                case 41: {
                    break;
                }
                default: {
                    f.error((Throwable)internalException);
                }
            }
        }
    }

    public void setInvalid(Requestor requestor, String string) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isVerified(requestor)) {
            this.a.put(requestor, string);
        }
    }

    @Nullable
    public String getWarning(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.a.get(requestor);
    }

    public boolean isVerified(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.findRequests(requestor).stream().anyMatch(eventRequest -> !(eventRequest instanceof ClassPrepareRequest));
    }

    @Override
    public void processDetached(DebugProcessImpl debugProcessImpl, boolean bl2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.c = null;
        this.a.clear();
        this.h.clear();
    }

    @Override
    public void processAttached(DebugProcessImpl debugProcessImpl) {
        this.c = this.d.getVirtualMachineProxy().eventRequestManager();
    }

    public void processClassPrepared(ClassPrepareEvent classPrepareEvent) {
        if (!this.d.isAttached()) {
            return;
        }
        ReferenceType referenceType = classPrepareEvent.referenceType();
        if (referenceType instanceof ClassType || referenceType instanceof InterfaceType) {
            ClassPrepareRequestor classPrepareRequestor;
            if (f.isDebugEnabled()) {
                f.debug("signature = " + referenceType.signature());
            }
            if ((classPrepareRequestor = (ClassPrepareRequestor)classPrepareEvent.request().getProperty(e)) != null) {
                if (f.isDebugEnabled()) {
                    f.debug("requestor found " + referenceType.signature());
                }
                classPrepareRequestor.processClassPrepare((DebugProcess)this.d, referenceType);
            }
        }
    }

    public void clearWarnings() {
        this.a.clear();
    }
}

