/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerContextImpl
implements DebuggerContext {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerContextImpl");
    public static final DebuggerContextImpl EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(null, null, null, null);
    private boolean b;
    @Nullable
    private final DebuggerSession f;
    private final SuspendContextImpl e;
    private final ThreadReferenceProxyImpl h;
    private StackFrameProxyImpl g;
    private SourcePosition d;
    private PsiElement c;

    private DebuggerContextImpl(@Nullable DebuggerSession debuggerSession, @Nullable SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, StackFrameProxyImpl stackFrameProxyImpl, SourcePosition sourcePosition, PsiElement psiElement, boolean bl2) {
        a.assertTrue(stackFrameProxyImpl == null || threadReferenceProxyImpl == null || threadReferenceProxyImpl == stackFrameProxyImpl.threadProxy());
        this.f = debuggerSession;
        this.h = threadReferenceProxyImpl;
        this.g = stackFrameProxyImpl;
        this.d = sourcePosition;
        this.e = suspendContextImpl;
        this.c = psiElement;
        this.b = bl2;
    }

    @Nullable
    public DebuggerSession getDebuggerSession() {
        return this.f;
    }

    @Nullable
    public DebugProcessImpl getDebugProcess() {
        return this.f != null ? this.f.getProcess() : null;
    }

    @Nullable
    public ThreadReferenceProxyImpl getThreadProxy() {
        return this.h;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.e;
    }

    public Project getProject() {
        return this.f != null ? this.f.getProject() : null;
    }

    @Nullable
    public StackFrameProxyImpl getFrameProxy() {
        a.assertTrue(this.b);
        return this.g;
    }

    public SourcePosition getSourcePosition() {
        a.assertTrue(this.b);
        return this.d;
    }

    public PsiElement getContextElement() {
        a.assertTrue(this.b);
        PsiElement psiElement = this.c;
        if (psiElement != null && !psiElement.isValid()) {
            this.c = ContextUtil.getContextElement(this.d);
        }
        return this.c;
    }

    public EvaluationContextImpl createEvaluationContext(Value value) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value);
    }

    @Nullable
    public EvaluationContextImpl createEvaluationContext() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        SuspendContextImpl suspendContextImpl = this.getSuspendContext();
        return suspendContextImpl != null ? new EvaluationContextImpl(suspendContextImpl, this.getFrameProxy()) : null;
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@Nullable DebuggerSession debuggerSession, @Nullable SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, StackFrameProxyImpl stackFrameProxyImpl) {
        a.assertTrue(stackFrameProxyImpl == null || threadReferenceProxyImpl == null || threadReferenceProxyImpl == stackFrameProxyImpl.threadProxy());
        DebuggerContextImpl debuggerContextImpl = new DebuggerContextImpl(debuggerSession, suspendContextImpl, threadReferenceProxyImpl, stackFrameProxyImpl, null, null, suspendContextImpl == null);
        if (debuggerContextImpl == null) {
            DebuggerContextImpl.a(0);
        }
        return debuggerContextImpl;
    }

    public void initCaches() {
        if (this.b) {
            return;
        }
        this.b = true;
        if (this.g == null && this.h != null) {
            try {
                this.g = this.h.frameCount() > 0 ? this.h.frame(0) : null;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (this.g != null) {
            if (this.d == null) {
                this.d = ContextUtil.getSourcePosition((StackFrameContext)this);
            }
            this.c = ContextUtil.getContextElement(this.d);
        }
    }

    public void setPositionCache(SourcePosition sourcePosition) {
        this.d = sourcePosition;
    }

    public boolean isInitialised() {
        return this.b;
    }

    public boolean isEvaluationPossible() {
        DebugProcessImpl debugProcessImpl = this.getDebugProcess();
        return debugProcessImpl != null && debugProcessImpl.getSuspendManager().getPausedContext() != null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerContextImpl", "createDebuggerContext"));
    }
}

