/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerSession
implements AbstractDebuggerSession {
    private static final Logger m = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerSession");
    private final MyDebuggerStateManager a;
    private volatile boolean e;
    private volatile int j;
    private DebuggerSessionState i;
    private final String d;
    private final DebugProcessImpl f;
    private final GlobalSearchScope l;
    private Sdk h;
    private final Sdk b;
    private final DebuggerContextImpl g;
    private final AtomicReference<ThreadReferenceProxyImpl> c;
    protected final Alarm myUpdateAlarm;
    private boolean k;

    public boolean isSteppingThrough(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        return Comparing.equal((Object)this.c.get(), (Object)threadReferenceProxyImpl);
    }

    public void setSteppingThrough(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        this.c.set(threadReferenceProxyImpl);
    }

    public void clearSteppingThrough() {
        this.c.set(null);
        this.resetIgnoreStepFiltersFlag();
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.l;
        if (globalSearchScope == null) {
            DebuggerSession.a(0);
        }
        return globalSearchScope;
    }

    public Sdk getAlternativeJre() {
        return this.h;
    }

    public void setAlternativeJre(Sdk sdk) {
        this.h = sdk;
        ((AlternativeJreClassFinder)((Object)Extensions.findExtension((ExtensionPointName)PsiElementFinder.EP_NAME, (AreaInstance)this.getProject(), AlternativeJreClassFinder.class))).clearCache();
    }

    public Sdk getRunJre() {
        return this.b;
    }

    public boolean isModifiedClassesScanRequired() {
        return this.k;
    }

    public void setModifiedClassesScanRequired(boolean bl2) {
        this.k = bl2;
    }

    static DebuggerSession create(String string, @NotNull DebugProcessImpl debugProcessImpl, DebugEnvironment debugEnvironment) throws ExecutionException {
        if (debugProcessImpl == null) {
            DebuggerSession.a(1);
        }
        DebuggerSession debuggerSession = new DebuggerSession(string, debugProcessImpl, debugEnvironment);
        try {
            debuggerSession.a(debugEnvironment);
        }
        catch (ExecutionException executionException) {
            debuggerSession.dispose();
            throw executionException;
        }
        return debuggerSession;
    }

    private DebuggerSession(String string, @NotNull DebugProcessImpl debugProcessImpl, DebugEnvironment debugEnvironment) {
        if (debugProcessImpl == null) {
            DebuggerSession.a(2);
        }
        this.j = 0;
        this.i = null;
        this.c = new AtomicReference();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.k = false;
        this.d = string;
        this.f = debugProcessImpl;
        this.g = DebuggerContextImpl.createDebuggerContext(this, null, null, null);
        this.a = new MyDebuggerStateManager();
        this.i = new DebuggerSessionState(State.STOPPED, null);
        this.f.addDebugProcessListener(new MyDebugProcessListener(debugProcessImpl));
        this.f.addEvaluationListener(new MyEvaluationListener());
        this.f.setAgentInsertPoints(CaptureSettingsProvider.getIdeInsertPoints());
        ValueLookupManager.getInstance((Project)this.getProject()).startListening();
        this.l = debugEnvironment.getSearchScope();
        this.h = debugEnvironment.getAlternativeJre();
        this.b = debugEnvironment.getRunJre();
    }

    @NotNull
    public DebuggerStateManager getContextManager() {
        MyDebuggerStateManager myDebuggerStateManager = this.a;
        if (myDebuggerStateManager == null) {
            DebuggerSession.a(3);
        }
        return myDebuggerStateManager;
    }

    public Project getProject() {
        return this.getProcess().getProject();
    }

    public String getSessionName() {
        return this.d;
    }

    @NotNull
    public DebugProcessImpl getProcess() {
        DebugProcessImpl debugProcessImpl = this.f;
        if (debugProcessImpl == null) {
            DebuggerSession.a(4);
        }
        return debugProcessImpl;
    }

    public State getState() {
        return this.i.myState;
    }

    public String getStateDescription() {
        if (this.i.myDescription != null) {
            return this.i.myDescription;
        }
        switch (this.i.myState) {
            case STOPPED: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
            case RUNNING: {
                return DebuggerBundle.message((String)"status.app.running", (Object[])new Object[0]);
            }
            case WAITING_ATTACH: {
                RemoteConnection remoteConnection = this.getProcess().getConnection();
                String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
                String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
                return remoteConnection.isServerMode() ? DebuggerBundle.message((String)"status.listening", (Object[])new Object[]{string, string2}) : DebuggerBundle.message((String)"status.connecting", (Object[])new Object[]{string, string2});
            }
            case PAUSED: {
                return DebuggerBundle.message((String)"status.paused", (Object[])new Object[0]);
            }
            case WAIT_EVALUATION: {
                return DebuggerBundle.message((String)"status.waiting.evaluation.result", (Object[])new Object[0]);
            }
            case DISPOSED: {
                return DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void a(DebugProcessImpl.ResumeCommand resumeCommand, Event event) {
        this.getContextManager().setState(this.g, State.WAIT_EVALUATION, event, null);
        this.f.getManagerThread().schedule(resumeCommand);
    }

    public void stepOut(int n2) {
        JvmSteppingCommandProvider jvmSteppingCommandProvider;
        SuspendContextImpl suspendContextImpl = this.a();
        DebugProcessImpl.ResumeCommand resumeCommand = null;
        JvmSteppingCommandProvider[] jvmSteppingCommandProviderArray = (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions();
        int n3 = jvmSteppingCommandProviderArray.length;
        for (int i2 = 0; i2 < n3 && (resumeCommand = (jvmSteppingCommandProvider = jvmSteppingCommandProviderArray[i2]).getStepOutCommand(suspendContextImpl, n2)) == null; ++i2) {
        }
        if (resumeCommand == null) {
            resumeCommand = this.f.createStepOutCommand(suspendContextImpl, n2);
        }
        this.setSteppingThrough(resumeCommand.getContextThread());
        this.a(resumeCommand, Event.STEP);
    }

    public void stepOut() {
        this.stepOut(-2);
    }

    public void stepOver(boolean bl2, int n2) {
        JvmSteppingCommandProvider jvmSteppingCommandProvider;
        SuspendContextImpl suspendContextImpl = this.a();
        DebugProcessImpl.ResumeCommand resumeCommand = null;
        JvmSteppingCommandProvider[] jvmSteppingCommandProviderArray = (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions();
        int n3 = jvmSteppingCommandProviderArray.length;
        for (int i2 = 0; i2 < n3 && (resumeCommand = (jvmSteppingCommandProvider = jvmSteppingCommandProviderArray[i2]).getStepOverCommand(suspendContextImpl, bl2, n2)) == null; ++i2) {
        }
        if (resumeCommand == null) {
            resumeCommand = this.f.createStepOverCommand(suspendContextImpl, bl2, n2);
        }
        this.setSteppingThrough(resumeCommand.getContextThread());
        this.a(resumeCommand, Event.STEP);
    }

    public void stepOver(boolean bl2) {
        this.stepOver(bl2, -2);
    }

    public void stepInto(boolean bl2, @Nullable MethodFilter methodFilter, int n2) {
        JvmSteppingCommandProvider jvmSteppingCommandProvider;
        SuspendContextImpl suspendContextImpl = this.a();
        DebugProcessImpl.ResumeCommand resumeCommand = null;
        JvmSteppingCommandProvider[] jvmSteppingCommandProviderArray = (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions();
        int n3 = jvmSteppingCommandProviderArray.length;
        for (int i2 = 0; i2 < n3 && (resumeCommand = (jvmSteppingCommandProvider = jvmSteppingCommandProviderArray[i2]).getStepIntoCommand(suspendContextImpl, bl2, methodFilter, n2)) == null; ++i2) {
        }
        if (resumeCommand == null) {
            resumeCommand = this.f.createStepIntoCommand(suspendContextImpl, bl2, methodFilter, n2);
        }
        this.setSteppingThrough(resumeCommand.getContextThread());
        this.a(resumeCommand, Event.STEP);
    }

    public void stepInto(boolean bl2, @Nullable MethodFilter methodFilter) {
        this.stepInto(bl2, methodFilter, -2);
    }

    public void runToCursor(@NotNull XSourcePosition xSourcePosition, boolean bl2) {
        if (xSourcePosition == null) {
            DebuggerSession.a(5);
        }
        try {
            DebugProcessImpl.ResumeCommand resumeCommand = this.f.createRunToCursorCommand(this.a(), xSourcePosition, bl2);
            this.setSteppingThrough(resumeCommand.getContextThread());
            this.a(resumeCommand, Event.STEP);
        }
        catch (EvaluateException evaluateException) {
            Messages.showErrorDialog((String)evaluateException.getMessage(), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
        }
    }

    public void resume() {
        SuspendContextImpl suspendContextImpl = this.a();
        if (suspendContextImpl != null) {
            this.clearSteppingThrough();
            this.a(this.f.createResumeCommand(suspendContextImpl), Event.RESUME);
        }
    }

    public void resetIgnoreStepFiltersFlag() {
        this.j = 0;
    }

    public void setIgnoreStepFiltersFlag(int n2) {
        this.j = this.j <= 0 ? n2 : Math.min(this.j, n2);
    }

    public boolean shouldIgnoreSteppingFilters() {
        return this.j > 0;
    }

    public void pause() {
        this.f.getManagerThread().schedule(this.f.createPauseCommand());
    }

    public void showExecutionPoint() {
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(this, this.a()), State.PAUSED, Event.REFRESH, null);
    }

    public void refresh(boolean bl2) {
        State state = this.getState();
        DebuggerContextImpl debuggerContextImpl = this.a.getContext();
        DebuggerContextImpl debuggerContextImpl2 = DebuggerContextImpl.createDebuggerContext(this, debuggerContextImpl.getSuspendContext(), debuggerContextImpl.getThreadProxy(), debuggerContextImpl.getFrameProxy());
        this.a.setState(debuggerContextImpl2, state, bl2 ? Event.REFRESH_WITH_STACK : Event.REFRESH, null);
    }

    public void dispose() {
        this.getProcess().dispose();
        Disposer.dispose((Disposable)this.myUpdateAlarm);
        DebuggerInvocationUtil.swingInvokeLater(this.getProject(), () -> {
            this.a.setState(this.g, State.DISPOSED, Event.DISPOSE, null);
            this.a.dispose();
        });
    }

    public boolean isStopped() {
        return this.getState() == State.STOPPED;
    }

    public boolean isAttached() {
        return !this.isStopped() && this.getState() != State.WAITING_ATTACH;
    }

    public boolean isPaused() {
        return this.getState() == State.PAUSED;
    }

    public boolean isConnecting() {
        return this.getState() == State.WAITING_ATTACH;
    }

    public boolean isEvaluating() {
        return this.e;
    }

    public boolean isRunning() {
        return this.getState() == State.RUNNING && !this.getProcess().getProcessHandler().isProcessTerminated();
    }

    private SuspendContextImpl a() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getContextManager().getContext().getSuspendContext();
    }

    @Nullable
    private ExecutionResult a(DebugEnvironment debugEnvironment) throws ExecutionException {
        RemoteConnection remoteConnection = debugEnvironment.getRemoteConnection();
        String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
        String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
        ExecutionResult executionResult = this.f.attachVirtualMachine(debugEnvironment, this);
        this.getContextManager().setState(this.g, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, DebuggerBundle.message((String)"status.waiting.attach", (Object[])new Object[]{string, string2}));
        return executionResult;
    }

    public void switchContext(SuspendContextImpl suspendContextImpl) {
        this.getProcess().getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextImpl){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) {
                if (suspendContextImpl == null) {
                    1.b(0);
                }
                DebuggerContextImpl debuggerContextImpl = DebuggerContextUtil.createDebuggerContext(DebuggerSession.this, suspendContextImpl);
                DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(debuggerContextImpl, State.PAUSED, Event.PAUSE, null));
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$1", "contextAction"));
            }
        });
    }

    private static String a(DebuggerContextImpl debuggerContextImpl) {
        SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
        if (suspendContextImpl != null && debuggerContextImpl.getThreadProxy() != suspendContextImpl.getThread()) {
            return DebuggerBundle.message((String)"status.paused.in.another.thread", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean enableBreakpointsDuringEvaluation() {
        return Registry.is((String)"debugger.enable.breakpoints.during.evaluation");
    }

    public void sessionResumed() {
        XDebugSession xDebugSession = this.getXDebugSession();
        if (xDebugSession != null) {
            xDebugSession.sessionResumed();
        }
    }

    @Nullable
    public XDebugSession getXDebugSession() {
        JavaDebugProcess javaDebugProcess = this.f.getXdebugProcess();
        return javaDebugProcess != null ? javaDebugProcess.getSession() : null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerSession";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runToCursor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEvaluationListener
    implements EvaluationListener {
        private MyEvaluationListener() {
        }

        @Override
        public void evaluationStarted(SuspendContextImpl suspendContextImpl) {
            DebuggerSession.this.e = true;
        }

        @Override
        public void evaluationFinished(SuspendContextImpl suspendContextImpl) {
            DebuggerSession.this.e = false;
        }
    }

    private class MyDebugProcessListener
    extends DebugProcessAdapterImpl {
        private final DebugProcessImpl a;

        public MyDebugProcessListener(DebugProcessImpl debugProcessImpl) {
            this.a = debugProcessImpl;
        }

        public void connectorIsReady() {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                RemoteConnection remoteConnection = this.a.getConnection();
                String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
                String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
                String string3 = remoteConnection.isServerMode() ? DebuggerBundle.message((String)"status.listening", (Object[])new Object[]{string, string2}) : DebuggerBundle.message((String)"status.connecting", (Object[])new Object[]{string, string2});
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, string3);
            });
        }

        @Override
        public void paused(final SuspendContextImpl suspendContextImpl) {
            SourcePosition sourcePosition;
            Iterator<ThreadReferenceProxyImpl> iterator;
            Collection<ThreadReferenceProxyImpl> collection;
            Object object2;
            Object object3;
            m.debug("paused");
            ThreadReferenceProxyImpl object4 = suspendContextImpl.getThread();
            if (!this.a(suspendContextImpl)) {
                DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().fireStateChanged(DebuggerSession.this.getContextManager().getContext(), Event.THREADS_REFRESH));
                object3 = suspendContextImpl.getThread();
                if (object3 != null && !(object2 = DebuggerUtilsEx.getEventDescriptors(suspendContextImpl)).isEmpty()) {
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.breakpoint.reached.in.thread", (Object[])new Object[]{((ThreadReferenceProxyImpl)object3).name()}), DebuggerBundle.message((String)"status.breakpoint.reached.in.thread.switch", (Object[])new Object[0]), NotificationType.INFORMATION, new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent hyperlinkEvent) {
                            if (notification == null) {
                                1.a(0);
                            }
                            if (hyperlinkEvent == null) {
                                1.a(1);
                            }
                            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                notification.expire();
                                DebuggerSession.this.switchContext(suspendContextImpl);
                            }
                        }

                        private static /* synthetic */ void a(int n2) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n2) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/debugger/impl/DebuggerSession$MyDebugProcessListener$1";
                            objectArray[2] = "hyperlinkUpdate";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }).notify(DebuggerSession.this.getProject());
                }
                if (((SuspendManagerImpl)this.a.getSuspendManager()).getPausedContexts().size() > 1) {
                    return;
                }
                object4 = (ThreadReferenceProxyImpl)DebuggerSession.this.c.get();
            } else {
                DebuggerSession.this.setSteppingThrough(object4);
            }
            if (object4 == null) {
                m.assertTrue(suspendContextImpl.getSuspendPolicy() == 2);
                object2 = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
                if (object2 != null) {
                    object4 = ((SuspendContextImpl)((Object)object2)).getThread();
                }
                if (object4 == null) {
                    collection = DebuggerSession.this.getProcess().getVirtualMachineProxy().allThreads();
                    for (ThreadReferenceProxyImpl object5 : collection) {
                        if (!ThreadState.isEDT((String)object5.name())) continue;
                        object4 = object5;
                        break;
                    }
                    if (object4 == null) {
                        ThreadReferenceProxyImpl threadReferenceProxyImpl;
                        iterator = collection.iterator();
                        while (iterator.hasNext() && (object4 = (threadReferenceProxyImpl = iterator.next())).status() != 1) {
                        }
                    }
                }
                collection = null;
                if (object4 != null) {
                    try {
                        while (!object4.isSuspended()) {
                            TimeoutUtil.sleep((long)10L);
                        }
                        collection = object4.frameCount() > 0 ? object4.frame(0) : null;
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        collection = null;
                    }
                    catch (EvaluateException evaluateException) {
                        collection = null;
                        m.error((Throwable)evaluateException);
                    }
                }
                object3 = new SimpleStackFrameContext((StackFrameProxy)collection, this.a);
            } else {
                object3 = suspendContextImpl;
            }
            if (object4 != null) {
                try {
                    int n2 = object4.frameCount();
                    if (n2 == 0 || n2 <= DebuggerSession.this.j) {
                        DebuggerSession.this.resetIgnoreStepFiltersFlag();
                    }
                }
                catch (EvaluateException evaluateException) {
                    m.info((Throwable)evaluateException);
                    DebuggerSession.this.resetIgnoreStepFiltersFlag();
                }
            }
            if ((sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)object3)) != null) {
                collection = DebuggerUtilsEx.getEventDescriptors(suspendContextImpl);
                iterator = suspendContextImpl.getDebugProcess().getRequestsManager();
                PsiFile psiFile = sourcePosition.getFile();
                boolean bl2 = psiFile instanceof PsiCompiledElement;
                for (Pair pair2 : collection) {
                    String string;
                    Breakpoint breakpoint = (Breakpoint)pair2.getFirst();
                    if (!(breakpoint instanceof LineBreakpoint)) continue;
                    SourcePosition sourcePosition2 = ((BreakpointWithHighlighter)breakpoint).getSourcePosition();
                    if (sourcePosition2 == null || !bl2 && sourcePosition2.getLine() != sourcePosition.getLine()) {
                        ((RequestManagerImpl)((Object)iterator)).deleteRequest(breakpoint);
                        ((RequestManagerImpl)((Object)iterator)).setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.changed", (Object[])new Object[0]));
                        breakpoint.updateUI();
                        continue;
                    }
                    if (!bl2) continue;
                    sourcePosition = sourcePosition2;
                    StackFrameProxy stackFrameProxy = object3.getFrameProxy();
                    try {
                        string = stackFrameProxy != null ? stackFrameProxy.location().declaringType().name() : "";
                    }
                    catch (EvaluateException evaluateException) {
                        string = "";
                    }
                    ((RequestManagerImpl)((Object)iterator)).setInvalid(breakpoint, DebuggerBundle.message((String)"error.invalid.breakpoint.source.not.found", (Object[])new Object[]{string}));
                    breakpoint.updateUI();
                }
            }
            collection = DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, suspendContextImpl, object4, null);
            if (suspendContextImpl.getThread() == object4) {
                ((DebuggerContextImpl)((Object)collection)).setPositionCache(sourcePosition);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState((DebuggerContextImpl)((Object)collection), State.PAUSED, Event.PAUSE, DebuggerSession.a(collection)));
        }

        private boolean a(SuspendContextImpl suspendContextImpl) {
            ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
            if (threadReferenceProxyImpl == null || suspendContextImpl.getSuspendPolicy() == 2 || DebuggerSession.this.isSteppingThrough(threadReferenceProxyImpl)) {
                return true;
            }
            SuspendContextImpl suspendContextImpl2 = DebuggerSession.this.getContextManager().getContext().getSuspendContext();
            if (suspendContextImpl2 == null) {
                return DebuggerSession.this.c.get() == null;
            }
            if (DebuggerSession.enableBreakpointsDuringEvaluation()) {
                ThreadReferenceProxyImpl threadReferenceProxyImpl2 = suspendContextImpl2.getThread();
                return threadReferenceProxyImpl2 == null || Comparing.equal((Object)threadReferenceProxyImpl2.getThreadReference(), (Object)threadReferenceProxyImpl.getThreadReference());
            }
            return false;
        }

        @Override
        public void resumed(SuspendContextImpl suspendContextImpl) {
            SuspendContextImpl suspendContextImpl2 = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = null;
            if (suspendContextImpl2 != null && suspendContextImpl != null && suspendContextImpl.getSuspendPolicy() == 1 && DebuggerSession.this.isSteppingThrough(suspendContextImpl.getThread())) {
                threadReferenceProxyImpl = suspendContextImpl.getThread();
            }
            DebuggerContextImpl debuggerContextImpl = suspendContextImpl2 != null ? DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, suspendContextImpl2, threadReferenceProxyImpl != null ? threadReferenceProxyImpl : suspendContextImpl2.getThread(), null) : null;
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                if (debuggerContextImpl != null) {
                    DebuggerSession.this.getContextManager().setState(debuggerContextImpl, State.PAUSED, Event.CONTEXT, DebuggerSession.a(debuggerContextImpl));
                } else {
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.RUNNING, Event.CONTEXT, null);
                }
            });
        }

        @Override
        public void processAttached(DebugProcessImpl debugProcessImpl) {
            RemoteConnection remoteConnection = DebuggerSession.this.getProcess().getConnection();
            String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
            String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
            String string3 = DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{string, string2});
            debugProcessImpl.printToConsole(string3 + "\n");
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.RUNNING, Event.ATTACHED, string3));
        }

        public void attachException(RunProfileState runProfileState, ExecutionException executionException, RemoteConnection remoteConnection) {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                String string = "";
                if (runProfileState instanceof RemoteState) {
                    string = DebuggerBundle.message((String)"status.connect.failed", (Object[])new Object[]{DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection), DebuggerBundle.getTransportName((RemoteConnection)remoteConnection)});
                }
                string = string + executionException.getMessage();
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.STOPPED, Event.DETACHED, string);
            });
        }

        @Override
        public void processDetached(DebugProcessImpl debugProcessImpl, boolean bl2) {
            ProcessHandler processHandler;
            if (!bl2 && (processHandler = debugProcessImpl.getProcessHandler()) != null) {
                RemoteConnection remoteConnection = DebuggerSession.this.getProcess().getConnection();
                String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
                String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
                processHandler.notifyTextAvailable(DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{string, string2}) + "\n", ProcessOutputTypes.SYSTEM);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                RemoteConnection remoteConnection = DebuggerSession.this.getProcess().getConnection();
                String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
                String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.g, State.STOPPED, Event.DETACHED, DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{string, string2}));
            });
            DebuggerSession.this.clearSteppingThrough();
        }

        public void threadStarted(DebugProcess debugProcess, ThreadReference threadReference) {
            this.d();
        }

        public void threadStopped(DebugProcess debugProcess, ThreadReference threadReference) {
            DebugProcessImpl debugProcessImpl;
            this.d();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = (ThreadReferenceProxyImpl)DebuggerSession.this.c.get();
            if (threadReferenceProxyImpl != null && threadReferenceProxyImpl.getThreadReference() == threadReference) {
                DebuggerSession.this.clearSteppingThrough();
            }
            if ((debugProcessImpl = (DebugProcessImpl)debugProcess).getRequestsManager().getFilterThread() == threadReference) {
                DebuggerManagerEx.getInstanceEx(debugProcess.getProject()).getBreakpointManager().applyThreadFilter(debugProcessImpl, null);
            }
        }

        private void d() {
            if (!DebuggerSession.this.myUpdateAlarm.isDisposed()) {
                DebuggerSession.this.myUpdateAlarm.cancelAllRequests();
                DebuggerSession.this.myUpdateAlarm.addRequest(() -> {
                    DebuggerStateManager debuggerStateManager = DebuggerSession.this.getContextManager();
                    debuggerStateManager.fireStateChanged(debuggerStateManager.getContext(), Event.THREADS_REFRESH);
                }, 100, ModalityState.NON_MODAL);
            }
        }
    }

    private static class DebuggerSessionState {
        final State myState;
        final String myDescription;

        public DebuggerSessionState(State state, String string) {
            this.myState = state;
            this.myDescription = string;
        }
    }

    private class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerContextImpl b;

        MyDebuggerStateManager() {
            this.b = DebuggerSession.this.g;
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            DebuggerContextImpl debuggerContextImpl = this.b;
            if (debuggerContextImpl == null) {
                MyDebuggerStateManager.b(0);
            }
            return debuggerContextImpl;
        }

        @Override
        public void setState(final @NotNull DebuggerContextImpl debuggerContextImpl, State state, Event event, String string) {
            if (debuggerContextImpl == null) {
                MyDebuggerStateManager.b(1);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
            m.assertTrue(debuggerSession == DebuggerSession.this || debuggerSession == null);
            final Runnable runnable = () -> {
                if (debuggerContextImpl == null) {
                    MyDebuggerStateManager.b(2);
                }
                m.assertTrue(this.b.isInitialised());
                this.b = debuggerContextImpl;
                if (m.isDebugEnabled()) {
                    m.debug("DebuggerSession state = " + (Object)((Object)state) + ", event = " + (Object)((Object)event));
                }
                DebuggerSession.this.e = false;
                DebuggerSession.this.i = new DebuggerSessionState(state, string);
                this.fireStateChanged(debuggerContextImpl, event);
            };
            if (debuggerContextImpl.getSuspendContext() == null) {
                runnable.run();
            } else {
                DebuggerSession.this.getProcess().getManagerThread().schedule(new SuspendContextCommandImpl(debuggerContextImpl.getSuspendContext()){

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }

                    @Override
                    public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                        if (suspendContextImpl == null) {
                            1.b(0);
                        }
                        debuggerContextImpl.initCaches();
                        DebuggerInvocationUtil.swingInvokeLater(DebuggerSession.this.getProject(), runnable);
                    }

                    private static /* synthetic */ void b(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager$1", "contextAction"));
                    }
                });
            }
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$setState$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Event {
        ATTACHED,
        DETACHED,
        RESUME,
        STEP,
        PAUSE,
        REFRESH,
        CONTEXT,
        START_WAIT_ATTACH,
        DISPOSE,
        REFRESH_WITH_STACK,
        THREADS_REFRESH;

    }

    public static enum State {
        STOPPED,
        RUNNING,
        WAITING_ATTACH,
        PAUSED,
        WAIT_EVALUATION,
        DISPOSED;

    }
}

