/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.EventQueue;
import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.sun.jdi.VMDisconnectedException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

public abstract class InvokeThread<E extends PrioritizedTask> {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.impl.InvokeThread");
    private static final ThreadLocal<WorkerThreadRequest> a = new ThreadLocal();
    protected final Project myProject;
    protected final EventQueue<E> myEvents;
    private volatile WorkerThreadRequest b = null;

    public InvokeThread(Project project2) {
        this.myProject = project2;
        this.myEvents = new EventQueue(PrioritizedTask.Priority.values().length);
        this.startNewWorkerThread();
    }

    protected abstract void processEvent(E var1);

    protected void startNewWorkerThread() {
        WorkerThreadRequest workerThreadRequest;
        this.b = workerThreadRequest = new WorkerThreadRequest(this);
        workerThreadRequest.setRequestFuture(ApplicationManager.getApplication().executeOnPooledThread(workerThreadRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(@NotNull WorkerThreadRequest workerThreadRequest) {
        block21: {
            if (workerThreadRequest == null) {
                InvokeThread.a(0);
            }
            String string = Thread.currentThread().getName();
            Thread.currentThread().setName("DebuggerManagerThread");
            try {
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(true);
                while (true) {
                    try {
                        while (true) {
                            if (workerThreadRequest.isStopRequested()) {
                                break block21;
                            }
                            WorkerThreadRequest workerThreadRequest2 = this.getCurrentRequest();
                            if (workerThreadRequest2 != workerThreadRequest) {
                                c.error("Expected " + workerThreadRequest + " instead of " + workerThreadRequest2);
                                if (workerThreadRequest2 != null && !workerThreadRequest2.isDone()) continue;
                            }
                            this.processEvent((PrioritizedTask)this.myEvents.get());
                        }
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                    }
                    catch (EventQueueClosedException eventQueueClosedException) {
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        if (runtimeException.getCause() instanceof InterruptedException) {
                            break;
                        }
                        c.error((Throwable)runtimeException);
                        continue;
                    }
                    catch (Throwable throwable) {
                        c.error(throwable);
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (workerThreadRequest == this.getCurrentRequest()) {
                    for (PrioritizedTask prioritizedTask : this.myEvents.clearQueue()) {
                        try {
                            this.processEvent(prioritizedTask);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                c.debug("Request " + this.toString() + " exited");
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(false);
                Thread.currentThread().setName(string);
            }
        }
    }

    protected static InvokeThread currentThread() {
        WorkerThreadRequest workerThreadRequest = InvokeThread.getCurrentThreadRequest();
        return workerThreadRequest != null ? workerThreadRequest.getOwner() : null;
    }

    public boolean schedule(@Async.Schedule E e2) {
        if (c.isDebugEnabled()) {
            c.debug("schedule " + e2 + " in " + this);
        }
        return this.myEvents.put(e2, e2.getPriority().ordinal());
    }

    public boolean pushBack(E e2) {
        if (c.isDebugEnabled()) {
            c.debug("pushBack " + e2 + " in " + this);
        }
        return this.myEvents.pushBack(e2, e2.getPriority().ordinal());
    }

    protected void switchToRequest(WorkerThreadRequest workerThreadRequest) {
        WorkerThreadRequest workerThreadRequest2 = InvokeThread.getCurrentThreadRequest();
        c.assertTrue(workerThreadRequest2 != null);
        this.b = workerThreadRequest;
        if (c.isDebugEnabled()) {
            c.debug("Closing " + workerThreadRequest2 + " new request = " + workerThreadRequest);
        }
        workerThreadRequest2.requestStop();
    }

    public WorkerThreadRequest getCurrentRequest() {
        return this.b;
    }

    public static WorkerThreadRequest getCurrentThreadRequest() {
        return a.get();
    }

    public void close() {
        this.myEvents.close();
        c.debug("Closing evaluation");
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadRequest", "com/intellij/debugger/impl/InvokeThread", "run"));
    }

    public static final class WorkerThreadRequest<E extends PrioritizedTask>
    implements Runnable {
        private final InvokeThread<E> c;
        private volatile Future<?> b;
        private volatile boolean a = false;

        WorkerThreadRequest(InvokeThread<E> invokeThread) {
            this.c = invokeThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                while (this.b == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            a.set(this);
            try {
                ((InvokeThread)this.c).a(this);
            }
            finally {
                a.set(null);
                boolean bl2 = Thread.interrupted();
            }
        }

        public void requestStop() {
            Future<?> future = this.b;
            assert (future != null);
            this.a = true;
            future.cancel(true);
        }

        public boolean isStopRequested() {
            Future<?> future = this.b;
            assert (future != null);
            return this.a || future.isCancelled() || future.isDone();
        }

        public void join() throws InterruptedException, ExecutionException {
            assert (this.b != null);
            try {
                this.b.get();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        public void join(long l2) throws InterruptedException, ExecutionException {
            assert (this.b != null);
            try {
                this.b.get(l2, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException | TimeoutException exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setRequestFuture(Future<?> future) {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                this.b = future;
                this.notifyAll();
            }
        }

        public InvokeThread<E> getOwner() {
            return this.c;
        }

        public boolean isDone() {
            assert (this.b != null);
            return this.b.isDone() && a.get() == null;
        }
    }
}

