/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.LocalVariableProxy;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.util.Comparing;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Type;

public class LocalVariableProxyImpl
extends JdiProxy
implements LocalVariableProxy {
    private final StackFrameProxyImpl f;
    private final String d;
    private final String b;
    private LocalVariable c;
    private Type e;

    public LocalVariableProxyImpl(StackFrameProxyImpl stackFrameProxyImpl, LocalVariable localVariable) {
        super(stackFrameProxyImpl.myTimer);
        this.f = stackFrameProxyImpl;
        this.d = localVariable.name();
        this.b = localVariable.typeName();
        this.c = localVariable;
    }

    @Override
    protected void clearCaches() {
        this.c = null;
        this.e = null;
    }

    public LocalVariable getVariable() throws EvaluateException {
        this.checkValid();
        if (this.c == null) {
            this.c = this.f.visibleVariableByNameInt(this.d);
            if (this.c == null) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
        }
        return this.c;
    }

    public Type getType() throws EvaluateException, ClassNotLoadedException {
        if (this.e == null) {
            this.e = this.getVariable().type();
        }
        return this.e;
    }

    public StackFrameProxyImpl getFrame() {
        return this.f;
    }

    public int hashCode() {
        return 31 * this.f.hashCode() + this.d.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LocalVariableProxyImpl) {
            LocalVariableProxyImpl localVariableProxyImpl = (LocalVariableProxyImpl)object;
            return Comparing.equal((Object)localVariableProxyImpl.f, (Object)this.f) && this.d.equals(localVariableProxyImpl.d);
        }
        return false;
    }

    public String name() {
        return this.d;
    }

    public String typeName() {
        return this.b;
    }

    public String toString() {
        return this.d;
    }
}

