/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.util.ThreeState;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ObjectReferenceProxyImpl
extends JdiProxy {
    private final ObjectReference b;
    private ReferenceType e;
    private Type d;
    private ThreeState c;

    public ObjectReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxyImpl, @NotNull ObjectReference objectReference) {
        if (objectReference == null) {
            ObjectReferenceProxyImpl.b(0);
        }
        super(virtualMachineProxyImpl);
        this.c = ThreeState.UNSURE;
        this.b = objectReference;
    }

    public ObjectReference getObjectReference() {
        this.checkValid();
        return this.b;
    }

    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    public ReferenceType referenceType() {
        this.checkValid();
        if (this.e == null) {
            this.e = this.getObjectReference().referenceType();
        }
        return this.e;
    }

    public Type type() {
        this.checkValid();
        if (this.d == null) {
            this.d = this.getObjectReference().type();
        }
        return this.d;
    }

    @NonNls
    public String toString() {
        ObjectReference objectReference = this.getObjectReference();
        String string = objectReference != null ? objectReference.toString() : "[referenced object collected]";
        return "ObjectReferenceProxyImpl: " + string + " " + super.toString();
    }

    public Map<Field, Value> getValues(List<? extends Field> list2) {
        return this.getObjectReference().getValues(list2);
    }

    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.getObjectReference().setValue(field, value);
    }

    public boolean isCollected() {
        this.checkValid();
        if (this.c != ThreeState.YES) {
            try {
                this.c = ThreeState.fromBoolean((boolean)VirtualMachineProxyImpl.isCollected(this.b));
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                this.c = ThreeState.YES;
            }
        }
        return this.c.toBoolean();
    }

    public long uniqueID() {
        return this.getObjectReference().uniqueID();
    }

    public List<ThreadReferenceProxyImpl> waitingThreads() throws IncompatibleThreadStateException {
        return StreamEx.of(this.getObjectReference().waitingThreads()).map(this.getVirtualMachineProxy()::getThreadReferenceProxy).toList();
    }

    public ThreadReferenceProxyImpl owningThread() throws IncompatibleThreadStateException {
        return this.getVirtualMachineProxy().getThreadReferenceProxy(this.getObjectReference().owningThread());
    }

    public int entryCount() throws IncompatibleThreadStateException {
        return this.getObjectReference().entryCount();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectReferenceProxyImpl)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ObjectReference objectReference = this.b;
        return objectReference.equals(((ObjectReferenceProxyImpl)object).b);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    @Override
    protected void clearCaches() {
        if (this.c == ThreeState.NO) {
            this.c = ThreeState.UNSURE;
        }
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/intellij/debugger/jdi/ObjectReferenceProxyImpl", "<init>"));
    }
}

