/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.tracking;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.tracking.BackgroundTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorInstancesTracker
implements TrackerForNewInstances,
Disposable,
BackgroundTracker {
    private static final int h = 2000;
    private final String g;
    private final Project d;
    private final MyConstructorBreakpoints c;
    @Nullable
    private HashSet<ObjectReference> e;
    @NotNull
    private HashSet<ObjectReference> b;
    private volatile boolean f;
    private volatile boolean a;

    public ConstructorInstancesTracker(@NotNull ReferenceType referenceType, @NotNull XDebugSession xDebugSession, @NotNull InstancesTracker instancesTracker) {
        if (referenceType == null) {
            ConstructorInstancesTracker.a(0);
        }
        if (xDebugSession == null) {
            ConstructorInstancesTracker.a(1);
        }
        if (instancesTracker == null) {
            ConstructorInstancesTracker.a(2);
        }
        this.e = null;
        this.b = new HashSet();
        this.d = xDebugSession.getProject();
        this.a = instancesTracker.isBackgroundTrackingEnabled();
        this.g = referenceType.name();
        final DebugProcessImpl debugProcessImpl = (DebugProcessImpl)DebuggerManager.getInstance((Project)this.d).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler());
        instancesTracker.addTrackerListener(new InstancesTrackerListener(){

            @Override
            public void backgroundTrackingValueChanged(final boolean bl2) {
                if (ConstructorInstancesTracker.this.a != bl2) {
                    ConstructorInstancesTracker.this.a = bl2;
                    debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() throws Exception {
                            if (bl2) {
                                ConstructorInstancesTracker.this.c.enable();
                            } else {
                                ConstructorInstancesTracker.this.c.disable();
                            }
                        }
                    });
                }
            }
        }, this);
        this.c = new MyConstructorBreakpoints(this.d);
        this.c.createRequestForPreparedClass(debugProcessImpl, referenceType);
    }

    public void obsolete() {
        DebugProcess debugProcess;
        MemoryViewDebugProcessData memoryViewDebugProcessData;
        XDebugSession xDebugSession;
        if (this.e != null) {
            this.e.forEach(ObjectReference::enableCollection);
        }
        this.e = null;
        if (!this.f || this.a) {
            this.c.enable();
        }
        if ((xDebugSession = XDebuggerManager.getInstance((Project)this.d).getCurrentSession()) != null && (memoryViewDebugProcessData = (MemoryViewDebugProcessData)(debugProcess = DebuggerManager.getInstance((Project)this.d).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler())).getUserData(MemoryViewDebugProcessData.KEY)) != null) {
            memoryViewDebugProcessData.getTrackedStacks().release();
        }
    }

    public void commitTracked() {
        this.e = this.b;
        this.b = new HashSet();
    }

    @Override
    @NotNull
    public List<ObjectReference> getNewInstances() {
        List<Object> list2 = this.e == null ? Collections.EMPTY_LIST : new ArrayList<ObjectReference>(this.e);
        if (list2 == null) {
            ConstructorInstancesTracker.a(3);
        }
        return list2;
    }

    @Override
    public int getCount() {
        return this.e == null ? 0 : this.e.size();
    }

    public void enable() {
        this.c.enable();
    }

    public void disable() {
        this.c.disable();
    }

    @Override
    public boolean isReady() {
        return this.e != null;
    }

    public void dispose() {
        this.c.delete();
        this.b.clear();
        this.e = null;
    }

    @Override
    public void setBackgroundMode(boolean bl2) {
        if (this.f == bl2) {
            return;
        }
        this.f = bl2;
        if (bl2) {
            this.b();
        } else {
            this.a();
        }
    }

    private void a() {
        this.c.enable();
    }

    private void b() {
        if (!this.a) {
            this.c.disable();
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instancesTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewInstances";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyConstructorBreakpointBase
    extends SyntheticLineBreakpoint {
        protected MyConstructorBreakpointBase(@NotNull Project project2) {
            if (project2 == null) {
                MyConstructorBreakpointBase.e(0);
            }
            super(project2);
            this.setSuspendPolicy("SuspendThread");
        }

        @Override
        @Nullable
        public SourcePosition getSourcePosition() {
            return null;
        }

        @Override
        public int getLineIndex() {
            return -1;
        }

        @Override
        public String getEventMessage(LocatableEvent locatableEvent) {
            return "";
        }

        @Override
        @Nullable
        protected JavaLineBreakpointType getXBreakpointType() {
            return null;
        }

        private static /* synthetic */ void e(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker$MyConstructorBreakpointBase", "<init>"));
        }
    }

    private final class MyConstructorBreakpoints
    extends MyConstructorBreakpointBase {
        private final List<BreakpointRequest> o;
        private final String p;
        private volatile boolean n;
        private volatile boolean q;

        MyConstructorBreakpoints(Project project2) {
            super(project2);
            this.o = new ArrayList<BreakpointRequest>();
            this.p = "MemoryViewConstructorTracker:" + ConstructorInstancesTracker.this.g;
            this.n = false;
            this.q = false;
            this.setVisible(false);
        }

        @Override
        protected void createRequestForPreparedClass(DebugProcessImpl debugProcessImpl, ReferenceType referenceType) {
            referenceType.methods().stream().filter(Method::isConstructor).forEach(method -> {
                Location location = method.location();
                BreakpointRequest breakpointRequest = debugProcessImpl.getRequestsManager().createBreakpointRequest(this, location);
                this.o.add(breakpointRequest);
            });
            if (!ConstructorInstancesTracker.this.f || ConstructorInstancesTracker.this.a) {
                this.enable();
            }
        }

        @Override
        public String getDisplayName() {
            return this.p;
        }

        @Override
        public boolean isEnabled() {
            return this.n;
        }

        void delete() {
            this.o.clear();
            this.q = true;
        }

        @Override
        public boolean processLocatableEvent(SuspendContextCommandImpl suspendContextCommandImpl, LocatableEvent locatableEvent) throws LocatableEventRequestor.EventProcessingException {
            if (this.q) {
                locatableEvent.request().disable();
            } else {
                this.a(suspendContextCommandImpl, locatableEvent);
            }
            return false;
        }

        void enable() {
            if (!this.n && !this.q) {
                this.o.forEach(EventRequest::enable);
                this.n = true;
            }
        }

        void disable() {
            if (this.n && !this.q) {
                this.o.forEach(EventRequest::disable);
                this.n = false;
            }
        }

        private void a(@NotNull SuspendContextCommandImpl suspendContextCommandImpl, @NotNull LocatableEvent locatableEvent) {
            if (suspendContextCommandImpl == null) {
                MyConstructorBreakpoints.f(0);
            }
            if (locatableEvent == null) {
                MyConstructorBreakpoints.f(1);
            }
            try {
                SuspendContextImpl suspendContextImpl = suspendContextCommandImpl.getSuspendContext();
                if (suspendContextImpl != null) {
                    MemoryViewDebugProcessData memoryViewDebugProcessData = (MemoryViewDebugProcessData)suspendContextImpl.getDebugProcess().getUserData(MemoryViewDebugProcessData.KEY);
                    ObjectReference objectReference = this.getThisObject(suspendContextImpl, locatableEvent);
                    if (objectReference != null && objectReference.referenceType().name().equals(ConstructorInstancesTracker.this.g) && memoryViewDebugProcessData != null) {
                        objectReference.disableCollection();
                        ConstructorInstancesTracker.this.b.add(objectReference);
                        memoryViewDebugProcessData.getTrackedStacks().addStack(objectReference, StackFrameItem.createFrames(suspendContextImpl, false));
                    }
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
            if (ConstructorInstancesTracker.this.b.size() >= 2000) {
                this.disable();
            }
        }

        private static /* synthetic */ void f(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker$MyConstructorBreakpoints";
            objectArray[2] = "handleEvent";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

