/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.ClassesFilteredView;
import com.intellij.debugger.memory.utils.AbstractTableColumnDescriptor;
import com.intellij.debugger.memory.utils.AbstractTableModelWithColumns;
import com.intellij.debugger.memory.utils.InstancesProvider;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesTable
extends JBTable
implements DataProvider,
Disposable {
    public static final DataKey<ReferenceType> SELECTED_CLASS_KEY = DataKey.create((String)"ClassesTable.SelectedClass");
    public static final DataKey<InstancesProvider> NEW_INSTANCES_PROVIDER_KEY = DataKey.create((String)"ClassesTable.NewInstances");
    public static final DataKey<ReferenceCountProvider> REF_COUNT_PROVIDER_KEY = DataKey.create((String)"ClassesTable.ReferenceCountProvider");
    private static final Border q = BorderFactory.createEmptyBorder();
    private static final JBColor i = new JBColor(new Color(250, 251, 252), new Color(62, 66, 69));
    private static final String l = "Nothing to show";
    private static final int n = 250;
    private static final int j = 80;
    private static final int a = 80;
    private static final UnknownDiffValue f = new UnknownDiffValue();
    private final DiffViewTableModel k;
    private final Map<ReferenceType, DiffValue> c;
    private final InstancesTracker t;
    private final ClassesFilteredView o;
    private final ReferenceCountProvider m;
    private boolean p;
    private boolean h;
    private boolean d;
    private MinusculeMatcher b;
    private String s;
    private volatile List<ReferenceType> e;
    private boolean g;
    private MouseListener r;

    public ClassesTable(@NotNull InstancesTracker instancesTracker, @NotNull ClassesFilteredView classesFilteredView, boolean bl2, boolean bl3, boolean bl4) {
        if (instancesTracker == null) {
            ClassesTable.b(0);
        }
        if (classesFilteredView == null) {
            ClassesTable.b(1);
        }
        this.k = new DiffViewTableModel();
        this.c = new ConcurrentHashMap<ReferenceType, DiffValue>();
        this.b = NameUtil.buildMatcher((String)"*").build();
        this.s = "";
        this.e = Collections.unmodifiableList(new ArrayList());
        this.g = true;
        this.r = null;
        this.setModel(this.k);
        this.p = bl2;
        this.d = bl3;
        this.h = bl4;
        this.t = instancesTracker;
        this.o = classesFilteredView;
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        TableColumn tableColumn3 = tableColumnModel.getColumn(2);
        this.setAutoResizeMode(2);
        tableColumn.setPreferredWidth(JBUI.scale((int)250));
        tableColumn2.setMinWidth(JBUI.scale((int)80));
        tableColumn3.setMinWidth(JBUI.scale((int)80));
        this.setShowGrid(false);
        this.setIntercellSpacing((Dimension)new JBDimension(0, 0));
        this.setDefaultRenderer(ReferenceType.class, (TableCellRenderer)((Object)new MyClassColumnRenderer()));
        this.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)new MyCountColumnRenderer()));
        this.setDefaultRenderer(DiffValue.class, (TableCellRenderer)((Object)new MyDiffColumnRenderer()));
        TableRowSorter<DiffViewTableModel> tableRowSorter = new TableRowSorter<DiffViewTableModel>(this.k);
        tableRowSorter.setRowFilter(new RowFilter<DiffViewTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends DiffViewTableModel, ? extends Integer> entry) {
                int n2 = entry.getIdentifier();
                ReferenceType referenceType = (ReferenceType)ClassesTable.this.e.get(n2);
                DiffValue diffValue = ClassesTable.this.c.getOrDefault(referenceType, f);
                boolean bl2 = ClassesTable.this.p && diffValue.diff() == 0L || ClassesTable.this.d && !diffValue.hasInstance() || ClassesTable.this.h && ClassesTable.this.o.getStrategy(referenceType) == null;
                return !bl2 && ClassesTable.this.b.matches(referenceType.name());
            }
        });
        List<RowSorter.SortKey> list2 = Arrays.asList(new RowSorter.SortKey(2, SortOrder.DESCENDING), new RowSorter.SortKey(1, SortOrder.DESCENDING), new RowSorter.SortKey(0, SortOrder.ASCENDING));
        tableRowSorter.setSortKeys(list2);
        this.setRowSorter(tableRowSorter);
        this.setSelectionMode(0);
        this.m = new ReferenceCountProvider(){

            @Override
            public int getTotalCount(@NotNull ReferenceType referenceType) {
                if (referenceType == null) {
                    2.a(0);
                }
                return (int)((DiffValue)ClassesTable.this.c.get(referenceType)).b;
            }

            @Override
            public int getDiffCount(@NotNull ReferenceType referenceType) {
                if (referenceType == null) {
                    2.a(1);
                }
                return (int)((DiffValue)ClassesTable.this.c.get(referenceType)).diff();
            }

            @Override
            public int getNewInstancesCount(@NotNull ReferenceType referenceType) {
                TrackerForNewInstances trackerForNewInstances;
                if (referenceType == null) {
                    2.a(2);
                }
                return (trackerForNewInstances = ClassesTable.this.o.getStrategy(referenceType)) == null || !trackerForNewInstances.isReady() ? -1 : trackerForNewInstances.getCount();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ref";
                objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesTable$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTotalCount";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDiffCount";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getNewInstancesCount";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    ReferenceType getSelectedClass() {
        int n2 = this.getSelectedRow();
        if (n2 != -1) {
            int n3 = this.convertRowIndexToModel(n2);
            return this.e.get(n3);
        }
        return null;
    }

    @Nullable
    ReferenceType getClassByName(@NotNull String string) {
        if (string == null) {
            ClassesTable.b(2);
        }
        for (ReferenceType referenceType : this.e) {
            if (!string.equals(referenceType.name())) continue;
            return referenceType;
        }
        return null;
    }

    boolean isInClickableMode() {
        return this.r != null;
    }

    void makeClickable(@NotNull String string, final @NotNull Runnable runnable) {
        if (string == null) {
            ClassesTable.b(3);
        }
        if (runnable == null) {
            ClassesTable.b(4);
        }
        this.b();
        this.getEmptyText().setText(string);
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.getMousePosition() != null) {
            this.setBackground((Color)i);
        }
        this.r = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                runnable.run();
                ClassesTable.this.b();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ClassesTable.this.setBackground((Color)i);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ClassesTable.this.setBackground(JBColor.background());
            }
        };
        this.addMouseListener(this.r);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    void exitClickableMode() {
        this.b();
        this.getEmptyText().setText(l);
    }

    private void b() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isInClickableMode()) {
            this.removeMouseListener(this.r);
            this.r = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setBackground(JBColor.background());
        }
    }

    void setBusy(boolean bl2) {
        this.setPaintBusy(bl2);
    }

    void setFilterPattern(String string) {
        if (!this.s.equals(string)) {
            this.s = string;
            this.b = NameUtil.buildMatcher((String)("*" + string)).build();
            this.a();
            if (this.getSelectedClass() == null && this.getRowCount() > 0) {
                this.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    void setFilteringByInstanceExists(boolean bl2) {
        if (bl2 != this.d) {
            this.d = bl2;
            this.a();
        }
    }

    void setFilteringByDiffNonZero(boolean bl2) {
        if (this.p != bl2) {
            this.p = bl2;
            this.a();
        }
    }

    void setFilteringByTrackingState(boolean bl2) {
        if (this.h != bl2) {
            this.h = bl2;
            this.a();
        }
    }

    public void updateClassesOnly(@NotNull List<ReferenceType> list2) {
        if (list2 == null) {
            ClassesTable.b(5);
        }
        this.g = false;
        LinkedHashMap<ReferenceType, Long> linkedHashMap = new LinkedHashMap<ReferenceType, Long>();
        list2.forEach(referenceType -> linkedHashMap.put((ReferenceType)referenceType, 0L));
        this.a(linkedHashMap);
    }

    public void updateContent(@NotNull Map<ReferenceType, Long> map) {
        if (map == null) {
            ClassesTable.b(6);
        }
        this.g = true;
        this.a(map);
    }

    void hideContent(@NotNull String string) {
        if (string == null) {
            ClassesTable.b(7);
        }
        this.b();
        this.getEmptyText().setText(string);
        this.k.hide();
    }

    private void d() {
        this.k.show();
    }

    private void a(@NotNull Map<ReferenceType, Long> map) {
        if (map == null) {
            ClassesTable.b(8);
        }
        this.b();
        this.getEmptyText().setText(l);
        ReferenceType referenceType = this.k.getSelectedClassBeforeHide();
        int n2 = -1;
        boolean bl2 = !this.e.isEmpty();
        this.e = Collections.unmodifiableList(new ArrayList<ReferenceType>(map.keySet()));
        int n3 = 0;
        for (ReferenceType referenceType2 : map.keySet()) {
            if (referenceType2.equals(referenceType)) {
                n2 = n3;
            }
            DiffValue diffValue = bl2 && !this.c.containsKey(referenceType2) ? new DiffValue(0L, 0L) : this.c.getOrDefault(referenceType2, f);
            this.c.put(referenceType2, diffValue.update(map.get(referenceType2)));
            ++n3;
        }
        this.d();
        if (n2 != -1 && !this.k.isHidden()) {
            int n4 = this.convertRowIndexToView(n2);
            this.changeSelection(n4, 0, false, false);
        }
        this.a();
    }

    @Nullable
    public Object getData(@NonNls String string) {
        TrackerForNewInstances trackerForNewInstances;
        ReferenceType referenceType;
        if (SELECTED_CLASS_KEY.is(string)) {
            return this.getSelectedClass();
        }
        if (NEW_INSTANCES_PROVIDER_KEY.is(string) && (referenceType = this.getSelectedClass()) != null && (trackerForNewInstances = this.o.getStrategy(referenceType)) != null && trackerForNewInstances.isReady()) {
            List<ObjectReference> list2 = trackerForNewInstances.getNewInstances();
            return n2 -> list2;
        }
        if (REF_COUNT_PROVIDER_KEY.is(string)) {
            return this.m;
        }
        return null;
    }

    public void clean(@NotNull String string) {
        if (string == null) {
            ClassesTable.b(9);
        }
        this.clearSelection();
        this.b();
        this.getEmptyText().setText(string);
        this.e = Collections.emptyList();
        this.c.clear();
        this.k.c = null;
        this.a();
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> this.clean(""));
    }

    @Nullable
    private TrackingType a(int n2) {
        ReferenceType referenceType = (ReferenceType)this.getValueAt(n2, this.convertColumnIndexToView(0));
        return this.t.getTrackingType(referenceType.name());
    }

    private void a() {
        this.k.fireTableDataChanged();
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClick";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "class2Count";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesTable";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassByName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "makeClickable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateClassesOnly";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateContent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hideContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCountsInternal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "clean";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDiffColumnRenderer
    extends MyNumericRenderer {
        private final SimpleTextAttributes a;

        private MyDiffColumnRenderer() {
            this.a = new SimpleTextAttributes(16, (Color)JBColor.BLUE);
        }

        @Override
        void appendText(@NotNull Object object, int n2) {
            TrackingType trackingType;
            if (object == null) {
                MyDiffColumnRenderer.b(0);
            }
            if ((trackingType = ClassesTable.this.a(n2)) != null) {
                this.setIcon(AllIcons.Debugger.MemoryView.ClassTracked);
                this.setTransparentIconBackground(true);
            }
            ReferenceType referenceType = (ReferenceType)ClassesTable.this.e.get(ClassesTable.this.convertRowIndexToModel(n2));
            long l2 = ClassesTable.this.m.getDiffCount(referenceType);
            String string = String.format("%s%d", l2 > 0L ? "+" : "", l2);
            int n3 = ClassesTable.this.m.getNewInstancesCount(referenceType);
            if (n3 >= 0) {
                if ((long)n3 == l2) {
                    this.append(string, l2 == 0L ? SimpleTextAttributes.REGULAR_ATTRIBUTES : this.a);
                } else {
                    this.append(string, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (n3 != 0) {
                        this.append(String.format(" (%d)", n3), this.a);
                    }
                }
            } else {
                this.append(string, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyDiffColumnRenderer", "appendText"));
        }
    }

    private class MyCountColumnRenderer
    extends MyNumericRenderer {
        private MyCountColumnRenderer() {
        }

        @Override
        void appendText(@NotNull Object object, int n2) {
            if (object == null) {
                MyCountColumnRenderer.b(0);
            }
            this.append(object.toString());
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyCountColumnRenderer", "appendText"));
        }
    }

    private abstract class MyNumericRenderer
    extends MyTableCellRenderer {
        private MyNumericRenderer() {
        }

        @Override
        protected void addText(@NotNull Object object, boolean bl2, int n2) {
            if (object == null) {
                MyNumericRenderer.a(0);
            }
            if (ClassesTable.this.g) {
                this.setTextAlign(4);
                this.appendText(object, n2);
            }
        }

        abstract void appendText(@NotNull Object var1, int var2);

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyNumericRenderer", "addText"));
        }
    }

    private class MyClassColumnRenderer
    extends MyTableCellRenderer {
        private MyClassColumnRenderer() {
        }

        @Override
        protected void addText(@NotNull Object object, boolean bl2, int n2) {
            if (object == null) {
                MyClassColumnRenderer.a(0);
            }
            String string = ((ReferenceType)object).name();
            this.append(" ");
            if (bl2) {
                FList fList = ClassesTable.this.b.matchingFragments(string);
                if (fList != null) {
                    SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(this.getBackground(), this.getForeground(), null, 64);
                    SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)this, (String)string, (Iterable)fList, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (SimpleTextAttributes)simpleTextAttributes);
                }
            } else {
                this.append(String.format("%s", string), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/debugger/memory/ui/ClassesTable$MyClassColumnRenderer", "addText"));
        }
    }

    private static abstract class MyTableCellRenderer
    extends ColoredTableCellRenderer {
        private MyTableCellRenderer() {
        }

        protected void customizeCellRenderer(JTable jTable, @Nullable Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (bl3) {
                this.setBorder(q);
            }
            if (object != null) {
                this.addText(object, bl2, n2);
            }
        }

        protected abstract void addText(@NotNull Object var1, boolean var2, int var3);
    }

    private static class DiffValue
    implements Comparable<DiffValue> {
        private long a;
        private long b;

        DiffValue(long l2) {
            this(l2, l2);
        }

        DiffValue(long l2, long l3) {
            this.b = l3;
            this.a = l2;
        }

        DiffValue update(long l2) {
            this.a = this.b;
            this.b = l2;
            return this;
        }

        boolean hasInstance() {
            return this.b > 0L;
        }

        long diff() {
            return this.b - this.a;
        }

        @Override
        public int compareTo(@NotNull DiffValue diffValue) {
            if (diffValue == null) {
                DiffValue.a(0);
            }
            return Long.compare(this.diff(), diffValue.diff());
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/debugger/memory/ui/ClassesTable$DiffValue", "compareTo"));
        }
    }

    private static class UnknownDiffValue
    extends DiffValue {
        UnknownDiffValue() {
            super(-1L);
        }

        @Override
        boolean hasInstance() {
            return true;
        }

        @Override
        DiffValue update(long l2) {
            return new DiffValue(l2);
        }
    }

    class DiffViewTableModel
    extends AbstractTableModelWithColumns {
        static final int CLASSNAME_COLUMN_INDEX = 0;
        static final int COUNT_COLUMN_INDEX = 1;
        static final int DIFF_COLUMN_INDEX = 2;
        private ReferenceType c;
        private boolean b;

        DiffViewTableModel() {
            super(new AbstractTableColumnDescriptor[]{new AbstractTableColumnDescriptor("Class", ReferenceType.class){

                @Override
                public Object getValue(int n2) {
                    return ClassesTable.this.e.get(n2);
                }
            }, new AbstractTableColumnDescriptor("Count", Long.class){

                @Override
                public Object getValue(int n2) {
                    return ((DiffValue)ClassesTable.this.c.getOrDefault(ClassesTable.this.e.get(n2), f)).b;
                }
            }, new AbstractTableColumnDescriptor("Diff", DiffValue.class){

                @Override
                public Object getValue(int n2) {
                    return ClassesTable.this.c.getOrDefault(ClassesTable.this.e.get(n2), f);
                }
            }});
            this.c = null;
            this.b = false;
        }

        ReferenceType getSelectedClassBeforeHide() {
            return this.c;
        }

        void hide() {
            if (this.b) {
                this.c = ClassesTable.this.getSelectedClass();
                this.b = false;
                ClassesTable.this.clearSelection();
                this.fireTableDataChanged();
            }
        }

        void show() {
            if (!this.b) {
                this.b = true;
                this.fireTableDataChanged();
            }
        }

        boolean isHidden() {
            return !this.b;
        }

        @Override
        public int getRowCount() {
            return this.b ? ClassesTable.this.e.size() : 0;
        }
    }

    public static interface ReferenceCountProvider {
        public int getTotalCount(@NotNull ReferenceType var1);

        public int getDiffCount(@NotNull ReferenceType var1);

        public int getNewInstancesCount(@NotNull ReferenceType var1);
    }
}

