/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.InternalIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;

public class RendererConfiguration
implements Cloneable,
JDOMExternalizable {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.settings.NodeRendererSettings");
    private static final int c = 8;
    private List<NodeRenderer> a = new CopyOnWriteArrayList<NodeRenderer>();
    private final NodeRendererSettings d;

    protected RendererConfiguration(NodeRendererSettings nodeRendererSettings) {
        this.d = nodeRendererSettings;
    }

    public RendererConfiguration clone() {
        RendererConfiguration rendererConfiguration = null;
        try {
            rendererConfiguration = (RendererConfiguration)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            b.error((Throwable)cloneNotSupportedException);
        }
        rendererConfiguration.a = new CopyOnWriteArrayList<NodeRenderer>();
        ArrayList<NodeRenderer> arrayList = new ArrayList<NodeRenderer>();
        for (NodeRenderer nodeRenderer : this.a) {
            arrayList.add((NodeRenderer)nodeRenderer.clone());
        }
        rendererConfiguration.setRenderers(arrayList);
        return rendererConfiguration;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RendererConfiguration)) {
            return false;
        }
        return DebuggerUtilsEx.externalizableEqual(this, (RendererConfiguration)object);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (NodeRenderer nodeRenderer : this.a) {
            element.addContent(this.d.writeRenderer(nodeRenderer));
        }
        element.setAttribute("VERSION", String.valueOf(8));
    }

    public void readExternal(Element element) {
        String string = element.getAttributeValue("VERSION");
        int n2 = -1;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
        }
        if (n2 != 8) {
            return;
        }
        List list2 = element.getChildren("Renderer");
        ArrayList<NodeRenderer> arrayList = new ArrayList<NodeRenderer>(list2.size());
        for (Element element2 : list2) {
            try {
                arrayList.add((NodeRenderer)this.d.readRenderer(element2));
            }
            catch (Exception exception) {
                b.debug((Throwable)exception);
            }
        }
        this.setRenderers(arrayList);
    }

    public void addRenderer(NodeRenderer nodeRenderer) {
        this.a.add(0, nodeRenderer);
    }

    public void removeRenderer(NodeRenderer nodeRenderer) {
        this.a.remove(nodeRenderer);
    }

    public void setRenderers(Collection<NodeRenderer> collection) {
        this.a.clear();
        this.a.addAll(collection);
    }

    public void iterateRenderers(InternalIterator<NodeRenderer> internalIterator) {
        NodeRenderer nodeRenderer;
        boolean bl2;
        Iterator<NodeRenderer> iterator = this.a.iterator();
        while (iterator.hasNext() && (bl2 = internalIterator.visit((Object)(nodeRenderer = iterator.next())))) {
        }
    }

    public int getRendererCount() {
        return this.a.size();
    }

    public boolean contains(NodeRenderer nodeRenderer) {
        return this.a.contains(nodeRenderer);
    }
}

