/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlternativeSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> c = Key.create((String)"AlternativeSource");
    private static final Key<Boolean> b = Key.create((String)"AlternativeSourceCheckDone");
    private final Project a;

    public AlternativeSourceNotificationProvider(Project project2) {
        this.a = project2;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = c;
        if (key == null) {
            AlternativeSourceNotificationProvider.a(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile virtualFile, @NotNull FileEditor fileEditor) {
        if (virtualFile == null) {
            AlternativeSourceNotificationProvider.a(1);
        }
        if (fileEditor == null) {
            AlternativeSourceNotificationProvider.a(2);
        }
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.a).getCurrentSession();
        if (xDebugSession == null) {
            AlternativeSourceNotificationProvider.setFileProcessed(virtualFile, false);
            return null;
        }
        XSourcePosition xSourcePosition = xDebugSession.getCurrentPosition();
        if (xSourcePosition == null || !virtualFile.equals(xSourcePosition.getFile())) {
            AlternativeSourceNotificationProvider.setFileProcessed(virtualFile, false);
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.a).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] psiClassArray = ((PsiJavaFile)psiFile).getClasses();
        if (psiClassArray.length == 0) {
            return null;
        }
        PsiClass psiClass2 = psiClassArray[0];
        String string = psiClass2.getQualifiedName();
        if (string == null) {
            return null;
        }
        if (DumbService.getInstance((Project)this.a).isDumb()) {
            return null;
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])JavaPsiFacade.getInstance((Project)this.a).findClasses(string, GlobalSearchScope.allScope((Project)this.a)));
        ContainerUtil.removeDuplicates((Collection)arrayList);
        AlternativeSourceNotificationProvider.setFileProcessed(virtualFile, true);
        if (arrayList.size() > 1) {
            Location location;
            Object object2;
            for (Object object2 : arrayList) {
                if (!object2.equals(psiClass2) && !object2.getNavigationElement().equals(psiClass2)) continue;
                arrayList.remove(object2);
                break;
            }
            arrayList.add(0, psiClass2);
            ComboBoxClassElement[] comboBoxClassElementArray = (ComboBoxClassElement[])ContainerUtil.map2Array((Collection)arrayList, ComboBoxClassElement.class, psiClass -> new ComboBoxClassElement((PsiClass)psiClass.getNavigationElement()));
            object2 = null;
            XStackFrame xStackFrame = xDebugSession.getCurrentStackFrame();
            if (xStackFrame instanceof JavaStackFrame && (location = ((JavaStackFrame)xStackFrame).getDescriptor().getLocation()) != null) {
                object2 = location.declaringType().name();
            }
            return new AlternativeSourceNotificationPanel(comboBoxClassElementArray, psiClass2, this.a, virtualFile, (String)object2);
        }
        return null;
    }

    public static boolean isFileProcessed(VirtualFile virtualFile) {
        return b.get((UserDataHolder)virtualFile) != null;
    }

    public static void setFileProcessed(VirtualFile virtualFile, boolean bl2) {
        b.set((UserDataHolder)virtualFile, (Object)(bl2 ? Boolean.TRUE : null));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/AlternativeSourceNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/AlternativeSourceNotificationProvider";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AlternativeSourceNotificationPanel
    extends EditorNotificationPanel {
        public AlternativeSourceNotificationPanel(ComboBoxClassElement[] comboBoxClassElementArray, PsiClass psiClass, final Project project2, final VirtualFile virtualFile, final String string) {
            this.setText(DebuggerBundle.message((String)"editor.notification.alternative.source", (Object[])new Object[]{psiClass.getQualifiedName()}));
            final ComboBox comboBox = new ComboBox((Object[])comboBoxClassElementArray);
            comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
                    final DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
                    PsiClass psiClass = ((ComboBoxClassElement)comboBox.getSelectedItem()).b;
                    final VirtualFile virtualFile2 = psiClass.getContainingFile().getVirtualFile();
                    if (debuggerSession != null && virtualFile2 != null) {
                        debuggerSession.getProcess().getManagerThread().schedule(new DebuggerCommandImpl(){

                            @Override
                            protected void action() throws Exception {
                                if (!StringUtil.isEmpty((String)string)) {
                                    DebuggerUtilsEx.setAlternativeSourceUrl(string, virtualFile2.getUrl(), project2);
                                }
                                DebuggerUIUtil.invokeLater(() -> {
                                    FileEditorManager.getInstance((Project)project2).closeFile(virtualFile);
                                    debuggerSession.refresh(true);
                                });
                            }
                        });
                    } else {
                        FileEditorManager.getInstance((Project)project2).closeFile(virtualFile);
                        psiClass.navigate(true);
                    }
                }
            });
            this.myLinksPanel.add((Component)comboBox);
            this.createActionLabel(DebuggerBundle.message((String)"action.disable.text", (Object[])new Object[0]), () -> {
                DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE = false;
                AlternativeSourceNotificationProvider.setFileProcessed(virtualFile, false);
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
                FileEditor fileEditor = fileEditorManager.getSelectedEditor(virtualFile);
                if (fileEditor != null) {
                    fileEditorManager.removeTopComponent(fileEditor, (JComponent)((Object)this));
                }
            });
        }
    }

    private static class ComboBoxClassElement {
        private final PsiClass b;
        private String a;
        private static final JList c = new JBList();

        public ComboBoxClassElement(PsiClass psiClass) {
            this.b = psiClass;
        }

        public String toString() {
            if (this.a == null) {
                ModuleRendererFactory moduleRendererFactory = ModuleRendererFactory.findInstance((Object)this.b);
                DefaultListCellRenderer defaultListCellRenderer = moduleRendererFactory.getModuleRenderer();
                defaultListCellRenderer.getListCellRendererComponent((JList<?>)c, this.b, 1, false, false);
                this.a = defaultListCellRenderer.getText();
            }
            return this.a;
        }
    }
}

