/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.reference.SoftReference;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import gnu.trove.TIntObjectHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class HotSwapProgressImpl
extends HotSwapProgress {
    static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"HotSwap", (String)ToolWindowId.DEBUG);
    private final TIntObjectHashMap<List<String>> i = new TIntObjectHashMap();
    private final ProgressWindow d;
    private String g = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]);
    private final MergingUpdateQueue h;
    private WeakReference<XDebugSession> e = null;
    private final List<HotSwapProgressListener> f = ContainerUtil.newSmartList();

    public HotSwapProgressImpl(Project project2) {
        super(project2);
        this.d = new BackgroundableProcessIndicator(this.getProject(), this.g, new PerformInBackgroundOption(){

            public boolean shouldStartInBackground() {
                return DebuggerSettings.getInstance().HOTSWAP_IN_BACKGROUND;
            }
        }, null, null, true);
        this.d.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

            public void cancel() {
                super.cancel();
                HotSwapProgressImpl.this.cancel();
            }
        });
        this.h = new MergingUpdateQueue("HotSwapProgress update queue", 100, true, null, (Disposable)this.d);
    }

    @Override
    public void cancel() {
        super.cancel();
        for (HotSwapProgressListener hotSwapProgressListener : this.f) {
            hotSwapProgressListener.onCancel();
        }
    }

    @Override
    public void finished() {
        super.finished();
        for (HotSwapProgressListener object2 : this.f) {
            object2.onFinish();
        }
        List<String> list2 = this.getMessages(4);
        List<String> list3 = this.getMessages(5);
        if (!list2.isEmpty()) {
            this.a(DebuggerBundle.message((String)"status.hot.swap.completed.with.errors", (Object[])new Object[0]), this.a(list2, true), NotificationType.ERROR);
        } else if (!list3.isEmpty()) {
            this.a(DebuggerBundle.message((String)"status.hot.swap.completed.with.warnings", (Object[])new Object[0]), this.a(list3, true), NotificationType.WARNING);
        } else if (!this.i.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int n2 : this.i.keys()) {
                arrayList.addAll(this.getMessages(n2));
            }
            this.a("", this.a(arrayList, false), NotificationType.INFORMATION);
        }
    }

    private void a(String string, String string2, NotificationType notificationType) {
        HotSwapNotificationListener hotSwapNotificationListener = null;
        if (SoftReference.dereference(this.e) != null) {
            hotSwapNotificationListener = new HotSwapNotificationListener(this.e);
        }
        NOTIFICATION_GROUP.createNotification(string, string2, notificationType, (NotificationListener)hotSwapNotificationListener).setImportant(false).notify(this.getProject());
    }

    public void setSessionForActions(@NotNull DebuggerSession debuggerSession) {
        if (debuggerSession == null) {
            HotSwapProgressImpl.a(0);
        }
        this.e = new WeakReference<XDebugSession>(debuggerSession.getXDebugSession());
    }

    List<String> getMessages(int n2) {
        return ContainerUtil.notNullize((List)((List)this.i.get(n2)));
    }

    private String a(List<String> list2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(StreamEx.of(list2).map(string -> StringUtil.trimEnd((String)string, (char)';')).joining((CharSequence)"\n"));
        if (SoftReference.dereference(this.e) != null) {
            stringBuilder.append("\n").append(DebuggerBundle.message((String)"status.hot.swap.completed.stop", (Object[])new Object[0]));
            if (bl2) {
                stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;").append(DebuggerBundle.message((String)"status.hot.swap.completed.restart", (Object[])new Object[0]));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void addMessage(DebuggerSession debuggerSession, int n2, String string) {
        List list2 = (List)this.i.get(n2);
        if (list2 == null) {
            list2 = new SmartList();
            this.i.put(n2, (Object)list2);
        }
        list2.add(debuggerSession.getSessionName() + ": " + string + ";");
    }

    @Override
    public void setText(final String string) {
        this.h.queue(new Update("Text"){

            public void run() {
                DebuggerInvocationUtil.invokeLater(HotSwapProgressImpl.this.getProject(), () -> {
                    if (!HotSwapProgressImpl.this.d.isCanceled() && HotSwapProgressImpl.this.d.isRunning()) {
                        HotSwapProgressImpl.this.d.setText(string);
                    }
                }, HotSwapProgressImpl.this.d.getModalityState());
            }
        });
    }

    @Override
    public void setTitle(String string) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.d.isCanceled() && this.d.isRunning()) {
                this.d.setTitle(string);
            }
        }, this.d.getModalityState());
    }

    @Override
    public void setFraction(double d2) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            if (!this.d.isCanceled() && this.d.isRunning()) {
                this.d.setFraction(d2);
            }
        }, this.d.getModalityState());
    }

    @Override
    public boolean isCancelled() {
        return this.d.isCanceled();
    }

    public ProgressIndicator getProgressIndicator() {
        return this.d;
    }

    @Override
    public void setDebuggerSession(DebuggerSession debuggerSession) {
        this.g = DebuggerBundle.message((String)"progress.hot.swap.title", (Object[])new Object[0]) + " : " + debuggerSession.getSessionName();
        this.d.setTitle(this.g);
    }

    void addProgressListener(@NotNull HotSwapProgressListener hotSwapProgressListener) {
        if (hotSwapProgressListener == null) {
            HotSwapProgressImpl.a(1);
        }
        this.f.add(hotSwapProgressListener);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/HotSwapProgressImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSessionForActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addProgressListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface HotSwapProgressListener {
        default public void onCancel() {
        }

        default public void onFinish() {
        }
    }

    private static class HotSwapNotificationListener
    implements NotificationListener {
        final WeakReference<XDebugSession> mySessionRef;

        public HotSwapNotificationListener(WeakReference<XDebugSession> weakReference) {
            this.mySessionRef = weakReference;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent hyperlinkEvent) {
            if (notification == null) {
                HotSwapNotificationListener.a(0);
            }
            if (hyperlinkEvent == null) {
                HotSwapNotificationListener.a(1);
            }
            if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            XDebugSession xDebugSession = (XDebugSession)SoftReference.dereference(this.mySessionRef);
            if (xDebugSession == null) {
                return;
            }
            notification.expire();
            switch (hyperlinkEvent.getDescription()) {
                case "stop": {
                    xDebugSession.stop();
                    break;
                }
                case "restart": {
                    ExecutionEnvironment executionEnvironment = ((XDebugSessionImpl)xDebugSession).getExecutionEnvironment();
                    if (executionEnvironment == null) break;
                    ExecutionUtil.restart((ExecutionEnvironment)executionEnvironment);
                }
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/ui/HotSwapProgressImpl$HotSwapNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

