/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapManager;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapProgressImpl;
import com.intellij.debugger.ui.HotSwapStatusListener;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapVetoableListener;
import com.intellij.debugger.ui.RunHotswapDialog;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

public class HotSwapUIImpl
extends HotSwapUI {
    private static final Key<HotSwapStatusListener> e = Key.create((String)"hot_swap_callback");
    private final List<HotSwapVetoableListener> c = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean a = true;
    private final Project b;
    private boolean d = true;

    public HotSwapUIImpl(Project project2, final MessageBus messageBus, DebuggerManager debuggerManager) {
        this.b = project2;
        ((DebuggerManagerEx)debuggerManager).addDebuggerManagerListener(new DebuggerManagerListener(){
            private MessageBusConnection a = null;

            @Override
            public void sessionAttached(DebuggerSession debuggerSession) {
                if (this.a == null) {
                    this.a = messageBus.connect();
                    this.a.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new MyCompilationStatusListener());
                }
            }

            @Override
            public void sessionDetached(DebuggerSession debuggerSession) {
                if (!HotSwapUIImpl.this.a().isEmpty()) {
                    return;
                }
                MessageBusConnection messageBusConnection = this.a;
                if (messageBusConnection != null) {
                    Disposer.dispose((Disposable)messageBusConnection);
                    this.a = null;
                }
            }
        });
    }

    @Override
    public void addListener(HotSwapVetoableListener hotSwapVetoableListener) {
        this.c.add(hotSwapVetoableListener);
    }

    @Override
    public void removeListener(HotSwapVetoableListener hotSwapVetoableListener) {
        this.c.remove(hotSwapVetoableListener);
    }

    private static boolean a(DebuggerSettings debuggerSettings, List<DebuggerSession> list2) {
        if (!debuggerSettings.HOTSWAP_HANG_WARNING_ENABLED) {
            return false;
        }
        return list2.stream().anyMatch(DebuggerSession::isPaused);
    }

    private void a(final List<DebuggerSession> list2, @Nullable Map<String, List<String>> map, final @Nullable HotSwapStatusListener hotSwapStatusListener) {
        HotSwapProgressImpl hotSwapProgressImpl;
        boolean bl2;
        boolean bl3 = this.a;
        this.a = true;
        DebuggerSettings debuggerSettings = DebuggerSettings.getInstance();
        String string = debuggerSettings.RUN_HOTSWAP_AFTER_COMPILE;
        boolean bl4 = HotSwapUIImpl.a(debuggerSettings, list2);
        final HotSwapStatusListener hotSwapStatusListener2 = new HotSwapStatusListener(){

            @Override
            public void onCancel(List<DebuggerSession> list2) {
                if (hotSwapStatusListener != null) {
                    hotSwapStatusListener.onCancel(list2);
                }
            }

            @Override
            public void onSuccess(List<DebuggerSession> list2) {
                if (hotSwapStatusListener != null) {
                    hotSwapStatusListener.onSuccess(list2);
                }
            }

            @Override
            public void onFailure(List<DebuggerSession> list2) {
                if (hotSwapStatusListener != null) {
                    hotSwapStatusListener.onFailure(list2);
                }
            }
        };
        if (bl3 && "RunHotswapNever".equals(string)) {
            hotSwapStatusListener2.onCancel(list2);
            return;
        }
        boolean bl5 = bl2 = map == null;
        if (bl2) {
            hotSwapProgressImpl = new HotSwapProgressImpl(this.b);
        } else {
            boolean bl6 = list2.stream().anyMatch(DebuggerSession::isModifiedClassesScanRequired);
            HotSwapProgressImpl hotSwapProgressImpl2 = hotSwapProgressImpl = bl6 ? new HotSwapProgressImpl(this.b) : null;
        }
        if (hotSwapProgressImpl != null) {
            hotSwapProgressImpl.addProgressListener(new HotSwapProgressImpl.HotSwapProgressListener(){

                @Override
                public void onCancel() {
                    hotSwapStatusListener2.onCancel(list2);
                }
            });
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Object object;
            Application application;
            Map<DebuggerSession, Map<String, HotSwapFile>> map2;
            if (bl2) {
                map2 = HotSwapUIImpl.a(list2, hotSwapProgressImpl);
            } else {
                application = new ArrayList();
                object = new ArrayList();
                for (DebuggerSession debuggerSession : list2) {
                    (debuggerSession.isModifiedClassesScanRequired() ? application : object).add(debuggerSession);
                    debuggerSession.setModifiedClassesScanRequired(false);
                }
                map2 = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
                if (!object.isEmpty()) {
                    map2.putAll(HotSwapManager.findModifiedClasses((List<DebuggerSession>)object, map));
                }
                if (!application.isEmpty()) {
                    map2.putAll(HotSwapUIImpl.a((List<DebuggerSession>)application, hotSwapProgressImpl));
                }
            }
            application = ApplicationManager.getApplication();
            if (map2.isEmpty()) {
                object = DebuggerBundle.message((String)"status.hotswap.uptodate", (Object[])new Object[0]);
                HotSwapProgressImpl.NOTIFICATION_GROUP.createNotification((String)object, NotificationType.INFORMATION).notify(this.b);
                hotSwapStatusListener2.onSuccess(list2);
                return;
            }
            application.invokeLater(() -> {
                int n3;
                Object object;
                if (bl3 && !"RunHotswapAlways".equals(string)) {
                    object = new RunHotswapDialog(this.b, list2, bl4);
                    if (!object.showAndGet()) {
                        for (DebuggerSession debuggerSession : map2.keySet()) {
                            debuggerSession.setModifiedClassesScanRequired(true);
                        }
                        hotSwapStatusListener2.onCancel(list2);
                        return;
                    }
                    HashSet<DebuggerSession> hashSet = new HashSet<DebuggerSession>(((RunHotswapDialog)((Object)((Object)((Object)object)))).getSessionsToReload());
                    for (DebuggerSession debuggerSession : map2.keySet()) {
                        if (hashSet.contains(debuggerSession)) continue;
                        debuggerSession.setModifiedClassesScanRequired(true);
                    }
                    map2.keySet().retainAll(hashSet);
                } else if (bl4 && (n3 = Messages.showCheckboxMessageDialog((String)DebuggerBundle.message((String)"hotswap.dialog.hang.warning", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"hotswap.dialog.title", (Object[])new Object[0]), (String[])new String[]{"Perform &Reload Classes", "&Skip Reload Classes"}, (String)CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]), (boolean)false, (int)1, (int)1, (Icon)Messages.getWarningIcon(), (n2, jCheckBox) -> {
                    debuggerSettings.HOTSWAP_HANG_WARNING_ENABLED = !jCheckBox.isSelected();
                    return n2 == 0 ? n2 : 1;
                })) == 1) {
                    for (DebuggerSession debuggerSession : map2.keySet()) {
                        debuggerSession.setModifiedClassesScanRequired(true);
                    }
                    hotSwapStatusListener2.onCancel(list2);
                    return;
                }
                if (!map2.isEmpty()) {
                    object = new HotSwapProgressImpl(this.b);
                    if (map2.keySet().size() == 1) {
                        object.setSessionForActions((DebuggerSession)ContainerUtil.getFirstItem(map2.keySet()));
                    }
                    object.addProgressListener(new HotSwapProgressImpl.HotSwapProgressListener((HotSwapProgressImpl)object){
                        final /* synthetic */ HotSwapProgressImpl val$progress;
                        {
                            this.val$progress = hotSwapProgressImpl;
                        }

                        @Override
                        public void onCancel() {
                            hotSwapStatusListener2.onCancel(list2);
                        }

                        @Override
                        public void onFinish() {
                            if (this.val$progress.getMessages(4).isEmpty()) {
                                hotSwapStatusListener2.onSuccess(list2);
                            } else {
                                hotSwapStatusListener2.onFailure(list2);
                            }
                        }
                    });
                    application.executeOnPooledThread(() -> HotSwapUIImpl.b(map2, (HotSwapProgressImpl)object));
                }
            }, ModalityState.NON_MODAL);
        });
    }

    private static Map<DebuggerSession, Map<String, HotSwapFile>> a(List<DebuggerSession> list2, HotSwapProgressImpl hotSwapProgressImpl) {
        Ref ref = Ref.create(null);
        ProgressManager.getInstance().runProcess(() -> {
            try {
                ref.set(HotSwapManager.scanForModifiedClasses(list2, hotSwapProgressImpl));
            }
            finally {
                hotSwapProgressImpl.finished();
            }
        }, hotSwapProgressImpl.getProgressIndicator());
        return (Map)ref.get();
    }

    private static void a(Map<DebuggerSession, Map<String, HotSwapFile>> map, HotSwapProgressImpl hotSwapProgressImpl) {
        UsageTrigger.trigger((String)"debugger.reload.classes");
        ProgressManager.getInstance().runProcess(() -> {
            HotSwapManager.reloadModifiedClasses(map, hotSwapProgressImpl);
            hotSwapProgressImpl.finished();
        }, hotSwapProgressImpl.getProgressIndicator());
    }

    @Override
    public void reloadChangedClasses(@NotNull DebuggerSession debuggerSession, boolean bl2) {
        if (debuggerSession == null) {
            HotSwapUIImpl.a(0);
        }
        this.reloadChangedClasses(debuggerSession, bl2, null);
    }

    @Override
    public void reloadChangedClasses(@NotNull DebuggerSession debuggerSession, boolean bl2, @Nullable HotSwapStatusListener hotSwapStatusListener) {
        if (debuggerSession == null) {
            HotSwapUIImpl.a(1);
        }
        this.dontAskHotswapAfterThisCompilation();
        if (bl2) {
            CompilerManager compilerManager = CompilerManager.getInstance((Project)debuggerSession.getProject());
            if (hotSwapStatusListener == null) {
                compilerManager.make(null);
            } else {
                CompileScope compileScope = compilerManager.createProjectCompileScope(debuggerSession.getProject());
                compileScope.putUserData(e, (Object)hotSwapStatusListener);
                compilerManager.make(compileScope, null);
            }
        } else if (debuggerSession.isAttached()) {
            this.a(Collections.singletonList(debuggerSession), null, hotSwapStatusListener);
        } else if (hotSwapStatusListener != null) {
            hotSwapStatusListener.onFailure(ContainerUtil.newSmartList((Object)debuggerSession));
        }
    }

    @Override
    public void dontPerformHotswapAfterThisCompilation() {
        this.d = false;
    }

    public void dontAskHotswapAfterThisCompilation() {
        this.a = false;
    }

    public static boolean canHotSwap(@NotNull DebuggerSession debuggerSession) {
        if (debuggerSession == null) {
            HotSwapUIImpl.a(2);
        }
        return debuggerSession.isAttached() && debuggerSession.getProcess().canRedefineClasses();
    }

    @NotNull
    private List<DebuggerSession> a() {
        List list2 = (List)DebuggerManagerEx.getInstanceEx(this.b).getSessions().stream().filter(HotSwapUIImpl::canHotSwap).collect(Collectors.toCollection(SmartList::new));
        if (list2 == null) {
            HotSwapUIImpl.a(3);
        }
        return list2;
    }

    private static /* synthetic */ void b(Map map, HotSwapProgressImpl hotSwapProgressImpl) {
        HotSwapUIImpl.a(map, hotSwapProgressImpl);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerSession";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/HotSwapUIImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/HotSwapUIImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHotSwappableDebugSessions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reloadChangedClasses";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canHotSwap";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCompilationStatusListener
    implements CompilationStatusListener {
        private final AtomicReference<Map<String, List<String>>> b = new AtomicReference(new HashMap());
        private final THashSet<File> a = new THashSet(FileUtil.FILE_HASHING_STRATEGY);

        private MyCompilationStatusListener() {
            for (String string : CompilerPathsEx.getOutputPaths((Module[])ModuleManager.getInstance((Project)HotSwapUIImpl.this.b).getModules())) {
                this.a.add((Object)new File(string));
            }
        }

        public void fileGenerated(String string2, String string3) {
            if (StringUtil.endsWith((CharSequence)string3, (CharSequence)".class") && JpsPathUtil.isUnder(this.a, (File)new File(string2))) {
                this.b.get().computeIfAbsent(string2, string -> new ArrayList()).add(string3);
            }
        }

        public void compilationFinished(boolean bl2, int n2, int n3, CompileContext compileContext) {
            Map map = this.b.getAndSet(new HashMap());
            if (HotSwapUIImpl.this.b.isDisposed()) {
                return;
            }
            if (n2 == 0 && !bl2 && HotSwapUIImpl.this.d) {
                for (HotSwapVetoableListener hotSwapVetoableListener : HotSwapUIImpl.this.c) {
                    if (hotSwapVetoableListener.shouldHotSwap(compileContext)) continue;
                    return;
                }
                List list2 = HotSwapUIImpl.this.a();
                if (!list2.isEmpty()) {
                    HotSwapVetoableListener hotSwapVetoableListener;
                    hotSwapVetoableListener = compileContext.getCompileScope();
                    HotSwapStatusListener hotSwapStatusListener = hotSwapVetoableListener != null ? (HotSwapStatusListener)hotSwapVetoableListener.getUserData(e) : null;
                    HotSwapUIImpl.this.a(list2, map, hotSwapStatusListener);
                }
            }
            HotSwapUIImpl.this.d = true;
        }
    }
}

