/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PatternUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class WildcardMethodBreakpoint
extends Breakpoint<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint");

    public WildcardMethodBreakpoint(Project project2, XBreakpoint<JavaMethodBreakpointProperties> xBreakpoint) {
        super(project2, xBreakpoint);
    }

    @Override
    public Key<MethodBreakpoint> getCategory() {
        return MethodBreakpoint.CATEGORY;
    }

    protected WildcardMethodBreakpoint(Project project2, @NotNull String string, @NotNull String string2, XBreakpoint<JavaMethodBreakpointProperties> xBreakpoint) {
        if (string == null) {
            WildcardMethodBreakpoint.b(0);
        }
        if (string2 == null) {
            WildcardMethodBreakpoint.b(1);
        }
        super(project2, xBreakpoint);
        this.a(string);
        this.b(string2);
    }

    @Override
    public String getClassName() {
        return this.b();
    }

    @Override
    @Nullable
    public String getShortClassName() {
        return this.getClassName();
    }

    public String getMethodName() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    @Override
    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation(this);
    }

    @Override
    public PsiClass getPsiClass() {
        return (PsiClass)ReadAction.compute(() -> this.getClassName() != null ? DebuggerUtils.findClass((String)this.getClassName(), (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)) : null);
    }

    @Override
    public String getDisplayName() {
        if (!this.isValid()) {
            return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            stringBuilder.append(this.b());
            stringBuilder.append(".");
            stringBuilder.append(this.getMethodName());
            stringBuilder.append("()");
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    @Override
    public Icon getIcon() {
        if (!this.isEnabled()) {
            Breakpoint breakpoint = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
            return breakpoint == null ? AllIcons.Debugger.Db_disabled_method_breakpoint : AllIcons.Debugger.Db_dep_method_breakpoint;
        }
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl evaluationContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
        return (this.isEmulated() || this.a(locatableEvent.location().method())) && super.evaluateCondition(evaluationContextImpl, locatableEvent);
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcessImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.shouldCreateRequest(debugProcessImpl)) {
            return;
        }
        if (this.isEmulated()) {
            debugProcessImpl.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, this.b());
            Pattern pattern = PatternUtil.fromMask((String)this.b());
            debugProcessImpl.getVirtualMachineProxy().allClasses().stream().filter(referenceType -> pattern.matcher(referenceType.name()).matches()).filter(ReferenceType::isPrepared).forEach(referenceType -> this.processClassPrepare(debugProcessImpl, (ReferenceType)referenceType));
        } else {
            try {
                EventRequest eventRequest;
                RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
                if (this.isWatchEntry()) {
                    eventRequest = MethodBreakpoint.findRequest(debugProcessImpl, MethodEntryRequest.class, this);
                    if (eventRequest == null) {
                        eventRequest = requestManagerImpl.createMethodEntryRequest(this);
                    } else {
                        eventRequest.disable();
                    }
                    eventRequest.addClassFilter(this.b());
                    debugProcessImpl.getRequestsManager().enableRequest(eventRequest);
                }
                if (this.isWatchExit()) {
                    eventRequest = MethodBreakpoint.findRequest(debugProcessImpl, MethodExitRequest.class, this);
                    if (eventRequest == null) {
                        eventRequest = requestManagerImpl.createMethodExitRequest(this);
                    } else {
                        eventRequest.disable();
                    }
                    eventRequest.addClassFilter(this.b());
                    debugProcessImpl.getRequestsManager().enableRequest(eventRequest);
                }
            }
            catch (Exception exception) {
                c.debug((Throwable)exception);
            }
        }
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType referenceType) {
        if (this.isEmulated()) {
            MethodBreakpoint.createRequestForPreparedClassEmulated(this, (DebugProcessImpl)debugProcess, referenceType, true);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent locatableEvent) {
        if (locatableEvent == null) {
            WildcardMethodBreakpoint.b(2);
        }
        return MethodBreakpoint.getEventMessage(locatableEvent, "");
    }

    @Override
    public boolean isValid() {
        return !StringUtil.isEmpty((String)this.b()) && !StringUtil.isEmpty((String)this.getMethodName());
    }

    @Override
    public PsiElement getEvaluationElement() {
        return null;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        String string = element.getAttributeValue("class_name");
        this.a(string);
        String string2 = element.getAttributeValue("method_name");
        this.b(string2);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null || string2 == null) {
            throw new InvalidDataException();
        }
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> streamEx, DebugProcessImpl debugProcessImpl) {
        return (StreamEx)streamEx.filter(this::a);
    }

    private boolean a(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : StringUtil.split((String)this.getMethodName(), (String)",")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append('(').append(PatternUtil.convertToRegex((String)string)).append(')');
        }
        try {
            return method != null && Pattern.compile(stringBuilder.toString()).matcher(method.name()).matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            c.warn((Throwable)patternSyntaxException);
            return false;
        }
    }

    public static WildcardMethodBreakpoint create(Project project2, String string, String string2, XBreakpoint<JavaMethodBreakpointProperties> xBreakpoint) {
        return new WildcardMethodBreakpoint(project2, string, string2, xBreakpoint);
    }

    public boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).EMULATED;
    }

    @Override
    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    @Override
    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    private String b() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern;
    }

    private void a(String string) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = string;
    }

    private void b(String string) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = string;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/WildcardMethodBreakpoint";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

