/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationDescriptor
extends ValueDescriptorImpl {
    private Modifier p;
    protected TextWithImports myText;

    protected EvaluationDescriptor(TextWithImports textWithImports, Project project2, Value value) {
        super(project2, value);
        this.myText = textWithImports;
    }

    protected EvaluationDescriptor(TextWithImports textWithImports, Project project2) {
        super(project2);
        this.setLvalue(false);
        this.myText = textWithImports;
    }

    protected abstract EvaluationContextImpl getEvaluationContext(EvaluationContextImpl var1);

    protected abstract PsiCodeFragment getEvaluationCode(StackFrameContext var1) throws EvaluateException;

    public PsiCodeFragment createCodeFragment(PsiElement psiElement) {
        TextWithImports textWithImports = this.getEvaluationText();
        return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImports, psiElement).createCodeFragment(textWithImports, psiElement, this.myProject);
    }

    @Override
    public final Value calcValue(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAndRunReadAction(() -> {});
            EvaluationContextImpl evaluationContextImpl2 = this.getEvaluationContext(evaluationContextImpl);
            SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)evaluationContextImpl);
            PsiElement psiElement = ContextUtil.getContextElement((StackFrameContext)evaluationContextImpl, sourcePosition);
            ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)ReadAction.compute(() -> {
                PsiCodeFragment psiCodeFragment = this.getEvaluationCode((StackFrameContext)evaluationContextImpl2);
                try {
                    return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(this.getEvaluationText(), psiElement).getEvaluatorBuilder().build((PsiElement)psiCodeFragment, sourcePosition);
                }
                catch (UnsupportedExpressionException unsupportedExpressionException) {
                    ExpressionEvaluator expressionEvaluator = CompilingEvaluatorImpl.create(this.myProject, psiCodeFragment.getContext(), psiElement -> psiCodeFragment);
                    if (expressionEvaluator != null) {
                        return expressionEvaluator;
                    }
                    throw unsupportedExpressionException;
                }
            });
            if (!evaluationContextImpl2.getDebugProcess().isAttached()) {
                throw EvaluateExceptionUtil.PROCESS_EXITED;
            }
            StackFrameProxyImpl stackFrameProxyImpl = evaluationContextImpl2.getFrameProxy();
            if (stackFrameProxyImpl == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
            Value value = expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl2);
            DebuggerUtilsEx.keep(value, evaluationContextImpl2);
            this.p = expressionEvaluator.getModifier();
            this.setLvalue(this.p != null);
            return value;
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw new EvaluateException("Evaluation is not possible during indexing", (Throwable)indexNotReadyException);
        }
        catch (EvaluateException evaluateException) {
            throw new EvaluateException(evaluateException.getLocalizedMessage(), (Throwable)evaluateException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        PsiCodeFragment psiCodeFragment = this.getEvaluationCode((StackFrameContext)debuggerContext);
        if (psiCodeFragment instanceof PsiExpressionCodeFragment) {
            return ((PsiExpressionCodeFragment)psiCodeFragment).getExpression();
        }
        throw new EvaluateException(DebuggerBundle.message((String)"error.cannot.create.expression.from.code.fragment", (Object[])new Object[0]), null);
    }

    @Override
    protected boolean isPrintExceptionToConsole() {
        return false;
    }

    @Nullable
    public Modifier getModifier() {
        return this.p;
    }

    @Override
    public boolean canSetValue() {
        return super.canSetValue() && this.p != null && this.p.canSetValue();
    }

    public TextWithImports getEvaluationText() {
        return this.myText;
    }

    @Override
    public XValueModifier getModifier(JavaValue javaValue) {
        return new JavaValueModifier(javaValue){

            @Override
            protected void setValueImpl(@NotNull XExpression xExpression, @NotNull XValueModifier.XModificationCallback xModificationCallback) {
                EvaluationDescriptor evaluationDescriptor;
                if (xExpression == null) {
                    1.b(0);
                }
                if (xModificationCallback == null) {
                    1.b(1);
                }
                if ((evaluationDescriptor = EvaluationDescriptor.this).canSetValue()) {
                    final DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(EvaluationDescriptor.this.getProject()).getContext();
                    this.set(xExpression, xModificationCallback, debuggerContextImpl, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContextImpl, Value value) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            Modifier modifier = evaluationDescriptor.getModifier();
                            modifier.setValue(1.preprocessValue(evaluationContextImpl, value, modifier.getExpectedType()));
                            1.update(debuggerContextImpl);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContextImpl.getDebugProcess().loadClass(evaluationContextImpl, string, evaluationContextImpl.getClassLoader());
                        }
                    });
                }
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/impl/watch/EvaluationDescriptor$1";
                objectArray[2] = "setValueImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }
}

