/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ThreadDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.sun.jdi.ObjectCollectedException;
import javax.swing.Icon;

public class ThreadDescriptorImpl
extends NodeDescriptorImpl
implements ThreadDescriptor {
    private final ThreadReferenceProxyImpl e;
    private String i = null;
    private boolean g = true;
    private boolean h = false;
    private boolean l;
    private boolean j;
    private boolean f;
    private SuspendContextImpl k;

    public ThreadDescriptorImpl(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        this.e = threadReferenceProxyImpl;
    }

    @Override
    public String getName() {
        return this.i;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl evaluationContextImpl, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getThreadReference();
        try {
            this.i = threadReferenceProxyImpl.name();
            ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = this.getThreadReference().threadGroupProxy();
            String string = threadGroupReferenceProxyImpl != null ? threadGroupReferenceProxyImpl.name() : null;
            String string2 = DebuggerUtilsEx.getThreadStatusText(this.getThreadReference().status());
            if (string != null && !"SYSTEM".equalsIgnoreCase(string)) {
                return DebuggerBundle.message((String)"label.thread.node.in.group", (Object[])new Object[]{this.i, threadReferenceProxyImpl.uniqueID(), string2, string});
            }
            return DebuggerBundle.message((String)"label.thread.node", (Object[])new Object[]{this.i, threadReferenceProxyImpl.uniqueID(), string2});
        }
        catch (ObjectCollectedException objectCollectedException) {
            return this.i != null ? DebuggerBundle.message((String)"label.thread.node.thread.collected", (Object[])new Object[]{this.i}) : "";
        }
    }

    @Override
    public ThreadReferenceProxyImpl getThreadReference() {
        return this.e;
    }

    public boolean isCurrent() {
        return this.l;
    }

    public boolean isFrozen() {
        return this.j;
    }

    @Override
    public boolean isExpandable() {
        return this.g;
    }

    @Override
    public void setContext(EvaluationContextImpl evaluationContextImpl) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getThreadReference();
        SuspendManager suspendManager = evaluationContextImpl != null ? evaluationContextImpl.getDebugProcess().getSuspendManager() : null;
        SuspendContextImpl suspendContextImpl = evaluationContextImpl != null ? evaluationContextImpl.getSuspendContext() : null;
        try {
            this.h = suspendManager != null ? suspendManager.isSuspended(threadReferenceProxyImpl) : threadReferenceProxyImpl.isSuspended();
        }
        catch (ObjectCollectedException objectCollectedException) {
            this.h = false;
        }
        this.g = this.a(this.h);
        this.k = suspendManager != null ? SuspendManagerUtil.findContextByThread(suspendManager, threadReferenceProxyImpl) : suspendContextImpl;
        this.f = threadReferenceProxyImpl.isAtBreakpoint();
        this.l = suspendContextImpl != null ? suspendContextImpl.getThread() == threadReferenceProxyImpl : false;
        this.j = suspendManager != null ? suspendManager.isFrozen(threadReferenceProxyImpl) : this.h;
    }

    private boolean a(boolean bl2) {
        if (!bl2) {
            return false;
        }
        int n2 = this.getThreadReference().status();
        return n2 != -1 && n2 != 5 && n2 != 0;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.k;
    }

    public boolean isAtBreakpoint() {
        return this.f;
    }

    public boolean isSuspended() {
        return this.h;
    }

    public Icon getIcon() {
        if (this.isCurrent()) {
            return AllIcons.Debugger.ThreadCurrent;
        }
        if (this.isAtBreakpoint()) {
            return AllIcons.Debugger.ThreadAtBreakpoint;
        }
        if (this.isFrozen()) {
            return AllIcons.Debugger.ThreadFrozen;
        }
        if (this.isSuspended()) {
            return AllIcons.Debugger.ThreadSuspended;
        }
        return AllIcons.Debugger.ThreadRunning;
    }
}

