/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorNameAdjuster;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValueDescriptorImpl
extends NodeDescriptorImpl
implements ValueDescriptor {
    protected final Project myProject;
    NodeRenderer myRenderer = null;
    NodeRenderer myAutoRenderer = null;
    private Value j;
    private boolean n;
    private EvaluateException f;
    protected EvaluationContextImpl myStoredEvaluationContext = null;
    private String m;
    private String l;
    private boolean e = false;
    @Nullable
    private Icon k;
    protected boolean myIsNew = true;
    private boolean g = false;
    private boolean o = false;
    private boolean i;
    private boolean h = true;

    protected ValueDescriptorImpl(Project project2, Value value) {
        this.myProject = project2;
        this.j = value;
        this.n = true;
    }

    protected ValueDescriptorImpl(Project project2) {
        this.myProject = project2;
    }

    private void a() {
        if (!this.n) {
            LOG.error("Value is not yet calculated for " + this.getClass());
        }
    }

    @Override
    public boolean isArray() {
        this.a();
        return this.j instanceof ArrayReference;
    }

    public boolean isDirty() {
        this.a();
        return this.g;
    }

    @Override
    public boolean isLvalue() {
        this.a();
        return this.o;
    }

    @Override
    public boolean isNull() {
        this.a();
        return this.j == null;
    }

    @Override
    public boolean isString() {
        this.a();
        return this.j instanceof StringReference;
    }

    @Override
    public boolean isPrimitive() {
        this.a();
        return this.j instanceof PrimitiveValue;
    }

    public boolean isEnumConstant() {
        this.a();
        return this.j instanceof ObjectReference && ValueDescriptorImpl.a((ObjectReference)this.j);
    }

    public boolean isValueValid() {
        return this.f == null;
    }

    public boolean isShowIdLabel() {
        return this.h && Registry.is((String)"debugger.showTypes");
    }

    public void setShowIdLabel(boolean bl2) {
        this.h = bl2;
    }

    @Override
    public Value getValue() {
        EvaluationContextImpl evaluationContextImpl;
        if (Patches.IBM_JDK_DISABLE_COLLECTION_BUG && (evaluationContextImpl = this.myStoredEvaluationContext) != null && !evaluationContextImpl.getSuspendContext().isResumed() && this.j instanceof ObjectReference && VirtualMachineProxyImpl.isCollected((ObjectReference)this.j)) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            evaluationContextImpl.getDebugProcess().getManagerThread().invoke(new SuspendContextCommandImpl(evaluationContextImpl.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                    if (suspendContextImpl == null) {
                        1.b(0);
                    }
                    try {
                        ValueDescriptorImpl.this.setContext(ValueDescriptorImpl.this.myStoredEvaluationContext);
                    }
                    finally {
                        semaphore.up();
                    }
                }

                @Override
                protected void commandCancelled() {
                    semaphore.up();
                }

                private static /* synthetic */ void b(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl$1", "contextAction"));
                }
            });
            semaphore.waitFor();
        }
        this.a();
        return this.j;
    }

    @Override
    public boolean isExpandable() {
        return this.i;
    }

    public abstract Value calcValue(EvaluationContextImpl var1) throws EvaluateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setContext(EvaluationContextImpl evaluationContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myStoredEvaluationContext = evaluationContextImpl;
        try {
            Value value;
            block10: {
                value = this.calcValue(evaluationContextImpl);
                if (!this.myIsNew) {
                    try {
                        if (this.j instanceof DoubleValue && Double.isNaN(((DoubleValue)this.j).doubleValue())) {
                            this.g = !(value instanceof DoubleValue);
                            break block10;
                        }
                        if (this.j instanceof FloatValue && Float.isNaN(((FloatValue)this.j).floatValue())) {
                            this.g = !(value instanceof FloatValue);
                            break block10;
                        }
                        this.g = value == null ? this.j != null : !value.equals(this.j);
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        this.g = true;
                    }
                }
            }
            this.j = value;
            this.f = null;
        }
        catch (EvaluateException evaluateException) {
            this.f = evaluateException;
            this.setFailed(evaluateException);
            this.j = ValueDescriptorImpl.a(evaluationContextImpl, evaluateException, this.isPrintExceptionToConsole() || ApplicationManager.getApplication().isUnitTestMode());
            this.i = false;
        }
        finally {
            this.n = true;
        }
        this.myIsNew = false;
    }

    protected boolean isPrintExceptionToConsole() {
        return true;
    }

    @Nullable
    protected static Value invokeExceptionGetStackTrace(ObjectReference objectReference, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Method method = ((ClassType)objectReference.referenceType()).concreteMethodByName("getStackTrace", "()[Ljava/lang/StackTraceElement;");
        if (method != null) {
            return evaluationContextImpl.getDebugProcess().invokeMethod((EvaluationContext)evaluationContextImpl, objectReference, method, Collections.emptyList());
        }
        return null;
    }

    @Nullable
    private static ObjectReference a(@Nullable EvaluationContextImpl evaluationContextImpl, EvaluateException evaluateException, boolean bl2) {
        ObjectReference objectReference = evaluateException.getExceptionFromTargetVM();
        if (objectReference != null && evaluationContextImpl != null) {
            try {
                Value value = ValueDescriptorImpl.invokeExceptionGetStackTrace(objectReference, evaluationContextImpl);
                if (bl2 && value instanceof ArrayReference) {
                    DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
                    ArrayReference arrayReference = (ArrayReference)value;
                    debugProcessImpl.printToConsole(DebuggerUtils.getValueAsString((EvaluationContext)evaluationContextImpl, (Value)objectReference) + "\n");
                    for (Value value2 : arrayReference.getValues()) {
                        debugProcessImpl.printToConsole("\tat " + DebuggerUtils.getValueAsString((EvaluationContext)evaluationContextImpl, (Value)value2) + "\n");
                    }
                }
            }
            catch (EvaluateException evaluateException2) {
            }
            catch (Throwable throwable) {
                LOG.info(throwable);
            }
        }
        return objectReference;
    }

    @Override
    public void setAncestor(NodeDescriptor nodeDescriptor) {
        super.setAncestor(nodeDescriptor);
        this.myIsNew = false;
        if (!this.n) {
            ValueDescriptorImpl valueDescriptorImpl = (ValueDescriptorImpl)nodeDescriptor;
            if (valueDescriptorImpl.n) {
                this.j = valueDescriptorImpl.getValue();
                this.n = true;
            }
        }
    }

    protected void setLvalue(boolean bl2) {
        this.o = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String calcRepresentation(EvaluationContextImpl evaluationContextImpl, DescriptorLabelListener descriptorLabelListener) {
        String string;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
        NodeRenderer nodeRenderer = this.getRenderer(debugProcessImpl);
        EvaluateException evaluateException = this.f;
        this.i = (evaluateException == null || evaluateException.getExceptionFromTargetVM() != null) && this.getChildrenRenderer(debugProcessImpl).isExpandable(this.getValue(), evaluationContextImpl, this);
        try {
            this.setValueIcon(nodeRenderer.calcValueIcon(this, evaluationContextImpl, descriptorLabelListener));
        }
        catch (EvaluateException evaluateException2) {
            LOG.info((Throwable)evaluateException2);
            this.setValueIcon(null);
        }
        if (evaluateException == null) {
            long l2 = nodeRenderer instanceof NodeRendererImpl && ((NodeRendererImpl)nodeRenderer).hasOverhead() ? System.currentTimeMillis() : 0L;
            try {
                string = nodeRenderer.calcLabel(this, evaluationContextImpl, descriptorLabelListener);
            }
            catch (EvaluateException evaluateException3) {
                string = this.setValueLabelFailed(evaluateException3);
            }
            finally {
                if (l2 > 0L) {
                    OverheadTimings.add(debugProcessImpl, new NodeRendererImpl.Overhead((NodeRendererImpl)nodeRenderer), 1L, System.currentTimeMillis() - l2);
                }
            }
        } else {
            string = this.setValueLabelFailed(evaluateException);
        }
        this.setValueLabel(string);
        return "";
    }

    @Override
    public String getLabel() {
        return this.calcValueName() + this.getDeclaredTypeLabel() + " = " + this.getValueLabel();
    }

    public ValueDescriptorImpl getFullValueDescriptor() {
        ValueDescriptorImpl valueDescriptorImpl = new ValueDescriptorImpl(this.myProject, this.j){

            @Override
            public Value calcValue(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
                return ValueDescriptorImpl.this.j;
            }

            @Override
            public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
                return null;
            }

            @Override
            public NodeRenderer getRenderer(DebugProcessImpl debugProcessImpl) {
                return ValueDescriptorImpl.this.getRenderer(debugProcessImpl);
            }

            @Override
            public <T> T getUserData(Key<T> key) {
                return ValueDescriptorImpl.this.getUserData(key);
            }
        };
        valueDescriptorImpl.e = true;
        return valueDescriptorImpl;
    }

    @Override
    public void setValueLabel(@NotNull String string) {
        if (string == null) {
            ValueDescriptorImpl.a(0);
        }
        string = this.e ? string : DebuggerUtilsEx.truncateString(string);
        Value value = this.n ? this.getValue() : null;
        NodeRendererImpl nodeRendererImpl = (NodeRendererImpl)this.getLastRenderer();
        EvaluationContextImpl evaluationContextImpl = this.myStoredEvaluationContext;
        String string2 = this.n && evaluationContextImpl != null && nodeRendererImpl != null && !evaluationContextImpl.getSuspendContext().isResumed() ? nodeRendererImpl.getIdLabel(value, evaluationContextImpl.getDebugProcess()) : null;
        this.l = string;
        this.m = this.isShowIdLabel() ? string2 : null;
    }

    @Override
    public String setValueLabelFailed(EvaluateException evaluateException) {
        String string = this.setFailed(evaluateException);
        this.setValueLabel(string);
        return string;
    }

    @Override
    public Icon setValueIcon(Icon icon) {
        this.k = icon;
        return this.k;
    }

    @Nullable
    public Icon getValueIcon() {
        return this.k;
    }

    public String calcValueName() {
        String string = this.getName();
        NodeDescriptorNameAdjuster nodeDescriptorNameAdjuster = NodeDescriptorNameAdjuster.findFor((NodeDescriptor)this);
        if (nodeDescriptorNameAdjuster != null) {
            return nodeDescriptorNameAdjuster.fixName(string, (NodeDescriptor)this);
        }
        return string;
    }

    @Nullable
    public String getDeclaredType() {
        return null;
    }

    @Override
    public void displayAs(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptorImpl = (ValueDescriptorImpl)nodeDescriptor;
            this.myRenderer = valueDescriptorImpl.myRenderer;
        }
        super.displayAs(nodeDescriptor);
    }

    public Renderer getLastRenderer() {
        return this.myRenderer != null ? this.myRenderer : this.myAutoRenderer;
    }

    public NodeRenderer getChildrenRenderer(DebugProcessImpl debugProcessImpl) {
        return OnDemandRenderer.isOnDemandForced(debugProcessImpl) ? DebugProcessImpl.getDefaultRenderer(this.getValue()) : this.getRenderer(debugProcessImpl);
    }

    public NodeRenderer getRenderer(DebugProcessImpl debugProcessImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Type type = this.getType();
        if (type != null && this.myRenderer != null && this.myRenderer.isApplicable(type)) {
            return this.myRenderer;
        }
        this.myAutoRenderer = debugProcessImpl.getAutoRenderer(this);
        return this.myAutoRenderer;
    }

    public void setRenderer(NodeRenderer nodeRenderer) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myRenderer = nodeRenderer;
        this.myAutoRenderer = null;
    }

    @Nullable
    public PsiElement getTreeEvaluation(JavaValue javaValue, DebuggerContextImpl debuggerContextImpl) throws EvaluateException {
        JavaValue javaValue2 = javaValue.getParent();
        if (javaValue2 != null) {
            ValueDescriptorImpl valueDescriptorImpl = javaValue2.getDescriptor();
            PsiElement psiElement = valueDescriptorImpl.getTreeEvaluation(javaValue2, debuggerContextImpl);
            if (!(psiElement instanceof PsiExpression)) {
                return null;
            }
            return DebuggerTreeNodeExpression.substituteThis(valueDescriptorImpl.getChildrenRenderer(debuggerContextImpl.getDebugProcess()).getChildValueExpression(new DebuggerTreeNodeMock(javaValue), debuggerContextImpl), (PsiExpression)psiElement, valueDescriptorImpl.getValue());
        }
        return this.getDescriptorEvaluation(debuggerContextImpl);
    }

    public abstract PsiExpression getDescriptorEvaluation(DebuggerContext var1) throws EvaluateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIdLabel(ObjectReference objectReference) {
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        if (objectReference instanceof StringReference && !classRenderer.SHOW_STRINGS_TYPE) {
            return null;
        }
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            int n2;
            boolean bl2;
            boolean bl3 = bl2 = !classRenderer.SHOW_DECLARED_TYPE || !(objectReference instanceof StringReference) && !(objectReference instanceof ClassObjectReference) && !ValueDescriptorImpl.a(objectReference);
            if (bl2 || classRenderer.SHOW_OBJECT_ID) {
                if (bl2) {
                    stringBuilder.append(classRenderer.renderTypeName(objectReference.type().name()));
                }
                if (classRenderer.SHOW_OBJECT_ID) {
                    stringBuilder.append('@');
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        stringBuilder.append("uniqueID");
                    } else {
                        stringBuilder.append(objectReference.uniqueID());
                    }
                }
            }
            if (objectReference instanceof ArrayReference && (n2 = stringBuilder.indexOf("[")) >= 0) {
                stringBuilder.insert(n2 + 1, Integer.toString(((ArrayReference)objectReference).length()));
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    private static boolean a(ObjectReference objectReference) {
        try {
            Type type = objectReference.type();
            return type instanceof ClassType && ((ClassType)type).isEnum();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return false;
        }
    }

    public boolean canSetValue() {
        return this.n && !this.myIsSynthetic && this.isLvalue();
    }

    public XValueModifier getModifier(JavaValue javaValue) {
        return null;
    }

    @NotNull
    public String getIdLabel() {
        String string = StringUtil.notNullize((String)this.m);
        if (string == null) {
            ValueDescriptorImpl.a(1);
        }
        return string;
    }

    public String getValueLabel() {
        String string = this.getIdLabel();
        if (!StringUtil.isEmpty((String)string)) {
            return '{' + string + '}' + this.getValueText();
        }
        return this.getValueText();
    }

    @NotNull
    public String getValueText() {
        String string = StringUtil.notNullize((String)this.l);
        if (string == null) {
            ValueDescriptorImpl.a(2);
        }
        return string;
    }

    @Override
    public void clear() {
        super.clear();
        this.setValueLabel("");
        this.i = false;
    }

    @Override
    @Nullable
    public ValueMarkup getMarkup(DebugProcess debugProcess) {
        Value value = this.getValue();
        if (value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            Map<ObjectReference, ValueMarkup> map = ValueDescriptorImpl.getMarkupMap(debugProcess);
            if (map != null) {
                return map.get(objectReference);
            }
        }
        return null;
    }

    @Override
    public void setMarkup(DebugProcess debugProcess, @Nullable ValueMarkup valueMarkup) {
        Map<ObjectReference, ValueMarkup> map;
        Value value = this.getValue();
        if (value instanceof ObjectReference && (map = ValueDescriptorImpl.getMarkupMap(debugProcess)) != null) {
            ObjectReference objectReference = (ObjectReference)value;
            if (valueMarkup != null) {
                map.put(objectReference, valueMarkup);
            } else {
                map.remove(objectReference);
            }
        }
    }

    public boolean canMark() {
        if (!this.n) {
            return false;
        }
        return this.getValue() instanceof ObjectReference;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getDeclaredTypeLabel() {
        String string;
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        if (classRenderer.SHOW_DECLARED_TYPE && !StringUtil.isEmpty((String)(string = this.getDeclaredType()))) {
            String string2 = ": " + classRenderer.renderTypeName(string);
            if (string2 == null) {
                ValueDescriptorImpl.a(3);
            }
            return string2;
        }
        if ("" == null) {
            ValueDescriptorImpl.a(4);
        }
        return "";
    }

    public EvaluationContextImpl getStoredEvaluationContext() {
        return this.myStoredEvaluationContext;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredTypeLabel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setValueLabel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DebuggerTreeNodeMock
    implements DebuggerTreeNode {
        private final JavaValue a;

        public DebuggerTreeNodeMock(JavaValue javaValue) {
            this.a = javaValue;
        }

        @Override
        public DebuggerTreeNode getParent() {
            return new DebuggerTreeNodeMock(this.a.getParent());
        }

        @Override
        public ValueDescriptorImpl getDescriptor() {
            return this.a.getDescriptor();
        }

        @Override
        public Project getProject() {
            return this.a.getProject();
        }

        @Override
        public void setRenderer(NodeRenderer nodeRenderer) {
        }
    }
}

