/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.Color;
import javax.swing.Icon;

class ColorObjectRenderer
extends CompoundReferenceRenderer {
    public ColorObjectRenderer(NodeRendererSettings nodeRendererSettings) {
        super(nodeRendererSettings, "Color", null, null);
        this.setClassName("java.awt.Color");
        this.setEnabled(true);
    }

    @Override
    public Icon calcValueIcon(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        Value value = valueDescriptor.getValue();
        if (value instanceof ObjectReference) {
            try {
                Value value2;
                ObjectReference objectReference = (ObjectReference)value;
                ReferenceType referenceType = objectReference.referenceType();
                Field field = referenceType.fieldByName("value");
                if (field != null && (value2 = objectReference.getValue(field)) instanceof IntegerValue) {
                    Color color = new Color(((IntegerValue)value2).value(), true);
                    return JBUI.scale((JBUI.JBIcon)new ColorIcon(16, 12, color, true));
                }
            }
            catch (Exception exception) {
                throw new EvaluateException(exception.getMessage(), (Throwable)exception);
            }
        }
        return null;
    }
}

