/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CustomPopupFullValueEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.debugger.ImageSerializer;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImageObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    private static final Logger e = Logger.getInstance(ImageObjectRenderer.class);

    public ImageObjectRenderer(NodeRendererSettings nodeRendererSettings) {
        super(nodeRendererSettings, "Image", null, null);
        this.setClassName("java.awt.Image");
        this.setEnabled(true);
    }

    @Override
    @Nullable
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContextImpl, final ValueDescriptorImpl valueDescriptorImpl) {
        return new IconPopupEvaluator(DebuggerBundle.message((String)"message.node.show.image", (Object[])new Object[0]), evaluationContextImpl){

            @Override
            protected Icon getData() {
                return ImageObjectRenderer.getIcon(this.getEvaluationContext(), valueDescriptorImpl.getValue(), "imageToBytes");
            }
        };
    }

    static JComponent createIconViewer(@Nullable Icon icon) {
        if (icon == null) {
            return new JLabel("No data", 0);
        }
        int n2 = icon.getIconWidth();
        int n3 = icon.getIconHeight();
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(n2, n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return ImageEditorManagerImpl.createImageEditorUI((BufferedImage)bufferedImage);
    }

    @Nullable
    static ImageIcon getIcon(EvaluationContext evaluationContext, Value value, String string) {
        try {
            Value value2 = ImageObjectRenderer.a(evaluationContext, value, string);
            byte[] byArray = ImageObjectRenderer.a(value2);
            if (byArray != null) {
                return new ImageIcon(byArray);
            }
        }
        catch (Exception exception) {
            e.info("Exception while getting image data", (Throwable)exception);
        }
        return null;
    }

    private static Value a(EvaluationContext evaluationContext, Value value, String string) throws EvaluateException {
        List<Method> list2;
        DebugProcess debugProcess = evaluationContext.getDebugProcess();
        EvaluationContext evaluationContext2 = evaluationContext.createEvaluationContext(value);
        ClassType classType = ClassLoadingUtils.getHelperClass(ImageSerializer.class.getName(), evaluationContext2, debugProcess);
        if (classType != null && !(list2 = classType.methodsByName(string)).isEmpty()) {
            return debugProcess.invokeMethod(evaluationContext2, classType, list2.get(0), Collections.singletonList(value));
        }
        return null;
    }

    private static byte[] a(Value value) {
        if (value instanceof ArrayReference) {
            List<Value> list2 = ((ArrayReference)value).getValues();
            byte[] byArray = new byte[list2.size()];
            int n2 = 0;
            for (Value value2 : list2) {
                if (value2 instanceof ByteValue) {
                    byArray[n2++] = ((ByteValue)value2).value();
                    continue;
                }
                return null;
            }
            return byArray;
        }
        return null;
    }

    static abstract class IconPopupEvaluator
    extends CustomPopupFullValueEvaluator<Icon> {
        public IconPopupEvaluator(@NotNull String string, @NotNull EvaluationContextImpl evaluationContextImpl) {
            if (string == null) {
                IconPopupEvaluator.c(0);
            }
            if (evaluationContextImpl == null) {
                IconPopupEvaluator.c(1);
            }
            super(string, evaluationContextImpl);
        }

        @Override
        protected JComponent createComponent(Icon icon) {
            return ImageObjectRenderer.createIconViewer(icon);
        }

        private static /* synthetic */ void c(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linkText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "evaluationContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/ui/tree/render/ImageObjectRenderer$IconPopupEvaluator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

