/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.actions.StartInplaceEditing;
import com.intellij.designer.componentTree.AttributeWrapper;
import com.intellij.designer.componentTree.QuickFixManager;
import com.intellij.designer.componentTree.TreeNodeDescriptor;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class ComponentTree
extends Tree
implements DataProvider {
    private final StartInplaceEditing d;
    private QuickFixManager f;
    private DesignerEditorPanel e;
    private EditableArea b;
    private RadComponent c;
    private int a;

    public ComponentTree() {
        this.newModel();
        this.setScrollsOnExpand(true);
        this.a();
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        TreeUtil.installActions((JTree)((Object)this));
        this.d = DesignerActionPanel.createInplaceEditingAction((JComponent)((Object)this));
    }

    public void setUI(TreeUI treeUI) {
        super.setUI(treeUI);
        this.getActionMap().put("selectAll", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ComponentTree.this.e != null) {
                    ComponentTree.this.e.getActionPanel().createSelectAllAction(ComponentTree.this.e.getSurfaceArea()).actionPerformed(null);
                }
            }
        });
    }

    public void newModel() {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
    }

    public void initQuickFixManager(JViewport jViewport) {
        this.f = new QuickFixManager((JComponent)((Object)this), jViewport);
    }

    public void updateInspections() {
        this.f.update();
    }

    public void setDesignerPanel(@Nullable DesignerEditorPanel designerEditorPanel) {
        this.e = designerEditorPanel;
        this.c = null;
        this.b = null;
        this.d.setDesignerPanel(designerEditorPanel);
        this.f.setDesigner(designerEditorPanel);
    }

    public void setArea(@Nullable EditableArea editableArea) {
        this.b = editableArea;
        this.f.setEditableArea(editableArea);
    }

    public void mark(RadComponent radComponent, int n2) {
        this.c = radComponent;
        this.a = n2;
        this.repaint();
    }

    public Object getData(@NonNls String string) {
        if (EditableArea.DATA_KEY.is(string)) {
            return this.b;
        }
        if (this.e != null) {
            if (PlatformDataKeys.FILE_EDITOR.is(string)) {
                return this.e.getEditor();
            }
            return this.e.getActionPanel().getData(string);
        }
        return null;
    }

    @Nullable
    public RadComponent extractComponent(Object object) {
        TreeNodeDescriptor treeNodeDescriptor;
        Object object2;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object3 = defaultMutableTreeNode.getUserObject();
        if (this.e != null && object3 instanceof TreeNodeDescriptor && (object2 = (treeNodeDescriptor = (TreeNodeDescriptor)((Object)object3)).getElement()) instanceof RadComponent) {
            return (RadComponent)((Object)object2);
        }
        return null;
    }

    public int getEdgeSize() {
        return Math.max(5, ((JComponent)((Object)this.getCellRenderer())).getPreferredSize().height / 2 - 3);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        List<ErrorInfo> list2;
        RadComponent radComponent;
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && (radComponent = this.extractComponent(treePath.getLastPathComponent())) != null && !(list2 = RadComponent.getError(radComponent)).isEmpty()) {
            return list2.get(0).getName();
        }
        return super.getToolTipText(mouseEvent);
    }

    @Nullable
    private static HighlightDisplayLevel a(Project project2, RadComponent radComponent) {
        HighlightDisplayLevel highlightDisplayLevel = null;
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar((Project)project2);
        for (ErrorInfo errorInfo : RadComponent.getError(radComponent)) {
            if (highlightDisplayLevel != null && severityRegistrar.compare(errorInfo.getLevel().getSeverity(), highlightDisplayLevel.getSeverity()) <= 0) continue;
            highlightDisplayLevel = errorInfo.getLevel();
        }
        return highlightDisplayLevel;
    }

    private AttributeWrapper a(RadComponent radComponent) {
        AttributeWrapper attributeWrapper = AttributeWrapper.DEFAULT;
        HighlightDisplayLevel highlightDisplayLevel = ComponentTree.a(this.e.getProject(), radComponent);
        if (highlightDisplayLevel != null) {
            TextAttributesKey textAttributesKey = SeverityRegistrar.getSeverityRegistrar((Project)this.e.getProject()).getHighlightInfoTypeBySeverity(highlightDisplayLevel.getSeverity()).getAttributesKey();
            final TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(textAttributesKey);
            attributeWrapper = new AttributeWrapper(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public SimpleTextAttributes getAttribute(SimpleTextAttributes simpleTextAttributes) {
                    Color color = textAttributes.getBackgroundColor();
                    try {
                        textAttributes.setBackgroundColor(null);
                        SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.fromTextAttributes((TextAttributes)TextAttributes.merge((TextAttributes)simpleTextAttributes.toTextAttributes(), (TextAttributes)textAttributes));
                        return simpleTextAttributes2;
                    }
                    finally {
                        textAttributes.setBackgroundColor(color);
                    }
                }
            };
        }
        return attributeWrapper;
    }

    private void a() {
        this.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
                try {
                    RadComponent radComponent = ComponentTree.this.extractComponent(object);
                    if (radComponent != null) {
                        ComponentTree.this.e.getTreeDecorator().decorate(radComponent, (SimpleColoredComponent)this, ComponentTree.this.a(radComponent), true);
                        if (ComponentTree.this.c == radComponent) {
                            if (ComponentTree.this.a == 2) {
                                this.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
                            } else {
                                this.setBorder(new InsertBorder(ComponentTree.this.a));
                            }
                        } else {
                            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (ComponentTree.this.e == null) {
                        throw runtimeException;
                    }
                    ComponentTree.this.e.showError("Tree paint operation", runtimeException);
                }
            }
        });
    }

    private static class InsertBorder
    extends LineBorder {
        private final int a;

        public InsertBorder(int n2) {
            super(Color.BLACK, 2);
            this.a = n2;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.a == 0 ? this.thickness : 0;
            insets.left = insets.right = this.thickness;
            insets.bottom = this.a == 1 ? this.thickness : 0;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Color color = graphics.getColor();
            graphics.setColor(this.getLineColor());
            if (this.a == 0) {
                graphics.fillRect(n2, n3, n4, this.thickness);
                graphics.fillRect(n2, n3, this.thickness, 2 * this.thickness);
                graphics.fillRect(n2 + n4 - this.thickness, n3, this.thickness, 2 * this.thickness);
            } else {
                graphics.fillRect(n2, n3 + n5 - this.thickness, n4, this.thickness);
                graphics.fillRect(n2, n3 + n5 - 2 * this.thickness, this.thickness, 2 * this.thickness);
                graphics.fillRect(n2 + n4 - this.thickness, n3 + n5 - 2 * this.thickness, this.thickness, 2 * this.thickness);
            }
            graphics.setColor(color);
        }
    }
}

