/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.utils.Cursors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ArrayUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class TreeDropListener
extends DropTargetAdapter {
    private final EditableArea b;
    private final ToolProvider i;
    private final Class[] c;
    private final OperationContext e = new OperationContext();
    private DropTargetDragEvent j;
    private EditOperation g;
    private RadComponent f;
    private boolean d;
    private boolean a;
    private static final Cursor h = Cursors.getMoveCursor();

    public TreeDropListener(ComponentTree componentTree, EditableArea editableArea, ToolProvider toolProvider) {
        this((JComponent)((Object)componentTree), editableArea, toolProvider, TreeDropListener.class, PaletteItem.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            componentTree.setDragEnabled(true);
            componentTree.setTransferHandler(new TreeTransfer(TreeDropListener.class));
        }
    }

    public TreeDropListener(JComponent jComponent, EditableArea editableArea, ToolProvider toolProvider, Class ... classArray) {
        this.b = editableArea;
        this.e.setArea(editableArea);
        this.i = toolProvider;
        this.c = classArray;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            jComponent.setDropTarget(new DropTarget(jComponent, this));
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.f();
        this.b(false);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.j = dropTargetDragEvent;
        this.a();
        this.d();
        this.b();
        this.g();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        this.f();
        this.e();
        this.b(true);
        dropTargetDropEvent.dropComplete(true);
    }

    private void g() {
        if (this.g != null) {
            this.g.showFeedback();
        }
        this.a = true;
    }

    private void f() {
        if (this.a) {
            this.a = false;
            if (this.g != null) {
                this.g.eraseFeedback();
            }
        }
    }

    private void a() {
        this.e.setLocation(this.c());
        if (this.e.getComponents() == null) {
            if (!ArrayUtil.contains((Object)SimpleTransferable.getData(this.j.getTransferable(), Class.class), (Object[])this.c)) {
                this.e.setComponents(Collections.emptyList());
                return;
            }
            if (this.i.getActiveTool() instanceof CreationTool) {
                this.e.setType("create_children");
                CreationTool creationTool = (CreationTool)this.i.getActiveTool();
                try {
                    this.e.setComponents(Collections.singletonList(creationTool.getFactory().create()));
                }
                catch (Throwable throwable) {
                    this.e.setComponents(Collections.emptyList());
                    this.i.loadDefaultTool();
                }
                return;
            }
            List<RadComponent> list2 = RadComponent.getPureSelection(this.b.getSelection());
            RadComponent radComponent = null;
            for (RadComponent radComponent2 : list2) {
                if (radComponent == null) {
                    radComponent = radComponent2.getParent();
                    continue;
                }
                if (radComponent == radComponent2.getParent()) continue;
                list2 = Collections.emptyList();
                break;
            }
            this.e.setComponents(list2);
            this.e.resetMoveAddEnabled();
            for (RadComponent radComponent2 : list2) {
                radComponent2.processDropOperation(this.e);
            }
        }
    }

    private void d() {
        if (this.e.getComponents().isEmpty()) {
            return;
        }
        final ArrayList<RadComponent> arrayList = new ArrayList<RadComponent>(this.e.getComponents());
        if (!this.e.isCreate()) {
            for (RadComponent object2 : this.e.getComponents()) {
                object2.accept(new RadComponentVisitor(){

                    @Override
                    public void endVisit(RadComponent radComponent) {
                        arrayList.add(radComponent);
                    }
                }, true);
            }
        }
        final EditOperation[] editOperationArray = new EditOperation[1];
        ComponentTargetFilter componentTargetFilter = new ComponentTargetFilter(){

            @Override
            public boolean preFilter(RadComponent radComponent) {
                return TreeDropListener.this.e.isCreate() || !arrayList.contains((Object)radComponent);
            }

            @Override
            public boolean resultFilter(RadComponent radComponent) {
                if (!TreeDropListener.this.e.isCreate()) {
                    if (TreeDropListener.this.e.getComponents().get(0).getParent() == radComponent) {
                        TreeDropListener.this.e.setType("move_children");
                    } else {
                        TreeDropListener.this.e.setType("add_children");
                    }
                }
                if (TreeDropListener.this.f == radComponent) {
                    return true;
                }
                RadLayout radLayout = radComponent.getLayout();
                if (radLayout != null) {
                    editOperationArray[0] = radLayout.processChildOperation(TreeDropListener.this.e);
                }
                return editOperationArray[0] != null;
            }
        };
        Point point = this.c();
        RadComponent radComponent = this.b.findTarget(point.x, point.y, componentTargetFilter);
        if (radComponent != this.f) {
            if (this.g != null) {
                this.f();
            }
            this.f = radComponent;
            this.g = editOperationArray[0];
        }
        if (radComponent == null) {
            if (!this.e.isCreate()) {
                this.e.setType(null);
            }
        } else {
            this.g.setComponents(this.e.getComponents());
        }
    }

    private Point c() {
        return this.j.getLocation();
    }

    private void b() {
        if (this.g != null) {
            if (this.e.isMove()) {
                this.a(this.e.isMoveEnabled() && this.g.canExecute());
            } else if (this.e.isAdd()) {
                this.a(this.e.isAddEnabled() && this.g.canExecute());
            } else if (this.e.isCreate()) {
                this.a(this.g.canExecute());
            } else {
                this.a(false);
            }
        } else {
            this.a(false);
        }
    }

    private void a(boolean bl2) {
        this.d = bl2;
        if (bl2) {
            this.j.acceptDrag(this.j.getDropAction());
            this.b.setCursor(this.e.isCreate() ? Cursors.getCopyCursor() : h);
        } else {
            this.j.rejectDrag();
            this.b.setCursor(Cursors.getSystemNoCursor());
        }
    }

    private void e() {
        if (this.d) {
            this.i.execute(Collections.singletonList(this.g), this.e.getMessage());
            if (this.e.isCreate()) {
                this.b.setSelection(this.e.getComponents());
            }
        }
    }

    private void b(boolean bl2) {
        this.e.setComponents(null);
        this.j = null;
        this.g = null;
        this.f = null;
        this.d = false;
        if (bl2 || !this.e.isCreate()) {
            this.e.setType(null);
            this.i.loadDefaultTool();
        }
        this.b.setCursor(null);
    }
}

