/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.feedbacks.LineMarginBorder;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyEditorListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ThrowableRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class InplaceEditingLayer
extends JComponent {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.designer.designSurface.InplaceEditingLayer");
    private final FocusWatcher h = new FocusWatcher(){

        protected void focusLostImpl(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (focusEvent.isTemporary() || component != null && SwingUtilities.isDescendingFrom(component, this.getTopComponent())) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> InplaceEditingLayer.this.a(true), ModalityState.NON_MODAL);
        }
    };
    private final ComponentSelectionListener a = new ComponentSelectionListener(){

        @Override
        public void selectionChanged(EditableArea editableArea) {
            InplaceEditingLayer.this.a(true);
        }
    };
    private final PropertyEditorListener d = new PropertyEditorListener(){

        public void valueCommitted(PropertyEditor propertyEditor, boolean bl2, boolean bl3) {
            InplaceEditingLayer.this.a(true);
        }

        public void editingCanceled(PropertyEditor propertyEditor) {
            InplaceEditingLayer.this.a(false);
        }

        public void preferredSizeChanged(PropertyEditor propertyEditor) {
            InplaceEditingLayer.this.a();
        }
    };
    private RadComponent f;
    private List<Property> c;
    private List<PropertyEditor> j;
    private final DesignerEditorPanel i;
    private JComponent g;
    private int e;

    public InplaceEditingLayer(DesignerEditorPanel designerEditorPanel) {
        this.i = designerEditorPanel;
    }

    public void startEditing(@Nullable InplaceContext inplaceContext) {
        try {
            JComponent jComponent;
            List<RadComponent> list2 = this.i.getSurfaceArea().getSelection();
            if (list2.size() != 1) {
                return;
            }
            this.f = list2.get(0);
            this.c = this.f.getInplaceProperties();
            if (this.c.isEmpty()) {
                this.f = null;
                this.c = null;
                return;
            }
            this.g = new JPanel((LayoutManager)new GridLayoutManager(this.c.size(), 2));
            this.g.setBorder(new LineMarginBorder(5, 5, 5, 5));
            new AnAction(){

                public void actionPerformed(AnActionEvent anActionEvent) {
                    InplaceEditingLayer.this.a(false);
                }
            }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.g);
            this.j = new ArrayList<PropertyEditor>();
            JComponent jComponent2 = null;
            Font font = null;
            if (inplaceContext == null) {
                inplaceContext = new InplaceContext();
            }
            int n2 = 0;
            for (Property object2 : this.c) {
                jComponent = new JLabel(object2.getName() + ":");
                if (font == null) {
                    font = jComponent.getFont().deriveFont(1);
                }
                jComponent.setFont(font);
                this.g.add((Component)jComponent, new GridConstraints(n2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
                PropertyEditor propertyEditor = object2.getEditor();
                this.j.add(propertyEditor);
                JComponent jComponent3 = propertyEditor.getComponent((PropertiesContainer)this.f, (PropertyContext)this.i, object2.getValue((PropertiesContainer)this.f), inplaceContext);
                this.g.add((Component)jComponent3, new GridConstraints(n2++, 1, 1, 1, 0, 1, 2, 0, null, null, null));
                if (jComponent2 != null) continue;
                jComponent2 = propertyEditor.getPreferredFocusedComponent();
            }
            for (PropertyEditor propertyEditor : this.j) {
                propertyEditor.addPropertyEditorListener(this.d);
            }
            Rectangle rectangle = this.f.getBounds(this);
            Dimension dimension = this.g.getPreferredSize();
            this.e = Math.max(dimension.width, rectangle.width);
            this.g.setBounds(rectangle.x, rectangle.y, this.e, dimension.height);
            this.add(this.g);
            this.i.getSurfaceArea().addSelectionListener(this.a);
            if (jComponent2 == null) {
                jComponent2 = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.g);
            }
            if (jComponent2 == null) {
                jComponent2 = this.g;
            }
            if (jComponent2.requestFocusInWindow()) {
                this.h.install((Component)this.g);
            } else {
                this.grabFocus();
                jComponent = jComponent2;
                ApplicationManager.getApplication().invokeLater(() -> {
                    jComponent.requestFocusInWindow();
                    this.h.install((Component)this.g);
                });
            }
            this.enableEvents(16L);
            this.repaint();
        }
        catch (Throwable throwable) {
            b.error(throwable);
        }
    }

    private void a(boolean bl2) {
        this.i.getSurfaceArea().removeSelectionListener(this.a);
        if (this.g != null) {
            if (bl2) {
                this.i.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
                    int n2 = this.c.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Object object;
                        Property property = this.c.get(i2);
                        Object object2 = property.getValue((PropertiesContainer)this.f);
                        if (Comparing.equal((Object)object2, (Object)(object = this.j.get(i2).getValue()))) continue;
                        property.setValue((PropertiesContainer)this.f, object);
                    }
                }), DesignerBundle.message("command.set.property.value", new Object[0]), true);
            }
            for (PropertyEditor propertyEditor : this.j) {
                propertyEditor.removePropertyEditorListener(this.d);
            }
            this.c();
            this.h.deinstall((Component)this.g);
            this.g = null;
        }
        this.f = null;
        this.c = null;
        this.j = null;
        this.i.getPreferredFocusedComponent().requestFocusInWindow();
        this.disableEvents(16L);
        this.repaint();
    }

    private void a() {
        this.g.revalidate();
        Dimension dimension = this.g.getPreferredSize();
        this.g.setSize(Math.max(dimension.width, this.e), this.g.getHeight());
        this.g.revalidate();
        this.repaint();
    }

    private void c() {
        LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent((JComponent)this.i.getPreferredFocusedComponent());
        try {
            this.remove(this.g);
        }
        finally {
            LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(null);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.g != null && (501 == mouseEvent.getID() || 502 == mouseEvent.getID())) {
            this.a(true);
        }
        super.processMouseEvent(mouseEvent);
    }

    public boolean isEditing() {
        return this.g != null;
    }
}

