/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.feedbacks;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class LineFeedback
extends JComponent {
    protected final Color myColor;
    private final int a;
    protected boolean myHorizontal;

    public LineFeedback(Color color, int n2, boolean bl2) {
        this.myColor = color;
        this.a = n2;
        this.myHorizontal = bl2;
    }

    public void size(int n2, int n3) {
        if (this.myHorizontal) {
            this.setSize(n2, this.a);
        } else {
            this.setSize(this.a, n3);
        }
    }

    public void horizontal(int n2, int n3, int n4) {
        this.myHorizontal = true;
        this.setBounds(n2, n3, n4, this.a);
        this.setVisible(true);
    }

    public void vertical(int n2, int n3, int n4) {
        this.myHorizontal = false;
        this.setBounds(n2, n3, this.a, n4);
        this.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.myColor);
        this.paintLines(graphics);
    }

    protected void paintLines(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.myHorizontal) {
            this.paintHorizontal(graphics, dimension);
        } else {
            this.paintVertical(graphics, dimension);
        }
    }

    protected void paintHorizontal(Graphics graphics, Dimension dimension) {
        for (int i2 = 0; i2 < this.a; ++i2) {
            graphics.drawLine(0, i2, dimension.width, i2);
        }
    }

    protected void paintVertical(Graphics graphics, Dimension dimension) {
        for (int i2 = 0; i2 < this.a; ++i2) {
            graphics.drawLine(i2, 0, i2, dimension.height);
        }
    }
}

