/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.ResizeTracker;
import com.intellij.designer.model.RadComponent;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public class DirectionResizePoint
extends ResizePoint {
    protected int myDirection;
    private final Object d;
    protected double myXSeparator;
    protected double myYSeparator;
    private final String e;

    public DirectionResizePoint(int n2, Object object, @Nullable String string) {
        this.a(n2);
        this.d = object;
        this.e = string;
    }

    public DirectionResizePoint(Color color, Color color2, int n2, Object object, @Nullable String string) {
        super(color, color2);
        this.a(n2);
        this.d = object;
        this.e = string;
    }

    private void a(int n2) {
        this.myDirection = n2;
        int n3 = this.myDirection & 0xC;
        this.myXSeparator = n3 == 4 ? 0.0 : (n3 == 8 ? 1.0 : 0.5);
        int n4 = this.myDirection & 3;
        this.myYSeparator = n4 == 1 ? 0.0 : (n4 == 2 ? 1.0 : 0.5);
    }

    public DirectionResizePoint move(double d2, double d3) {
        this.myXSeparator = d2;
        this.myYSeparator = d3;
        return this;
    }

    public int getDirection() {
        return this.myDirection;
    }

    @Override
    public Object getType() {
        return this.d;
    }

    @Override
    protected InputTool createTool(RadComponent radComponent) {
        return new ResizeTracker(this.myDirection, this.d, this.e);
    }

    @Override
    protected Point getLocation(DecorationLayer decorationLayer, RadComponent radComponent) {
        Rectangle rectangle = this.getBounds(decorationLayer, radComponent);
        int n2 = (this.getSize() + 1) / 2;
        int n3 = rectangle.x + (int)((double)rectangle.width * this.myXSeparator) - n2;
        int n4 = rectangle.y + (int)((double)rectangle.height * this.myYSeparator) - n2;
        return new Point(n3, n4);
    }

    protected Rectangle getBounds(DecorationLayer decorationLayer, RadComponent radComponent) {
        return radComponent.getBounds(decorationLayer);
    }
}

