/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ResizePoint
extends ComponentDecorator {
    private static final int c = 5;
    private final Color a;
    private final Color b;

    public ResizePoint() {
        this(Color.GREEN, Color.BLACK);
    }

    public ResizePoint(Color color, Color color2) {
        this.a = color;
        this.b = color2;
    }

    @Override
    public InputTool findTargetTool(DecorationLayer decorationLayer, RadComponent radComponent, int n2, int n3) {
        Point point = this.getLocation(decorationLayer, radComponent);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.getSize(), this.getSize());
        int n4 = this.getNeighborhoodSize();
        if (n4 > 0) {
            rectangle.grow(n4, n4);
        }
        if (rectangle.contains(n2, n3)) {
            return this.createTool(radComponent);
        }
        return null;
    }

    @Override
    protected void paint(DecorationLayer decorationLayer, Graphics2D graphics2D, RadComponent radComponent) {
        Point point = this.getLocation(decorationLayer, radComponent);
        graphics2D.setColor(this.a);
        graphics2D.fillRect(point.x, point.y, this.getSize(), this.getSize());
        graphics2D.setColor(this.b);
        graphics2D.drawRect(point.x, point.y, this.getSize(), this.getSize());
    }

    public abstract Object getType();

    protected abstract InputTool createTool(RadComponent var1);

    protected abstract Point getLocation(DecorationLayer var1, RadComponent var2);

    protected int getSize() {
        return 5;
    }

    protected int getNeighborhoodSize() {
        return 0;
    }
}

